/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.tyx.pingancai;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.util.BASE64Util;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.FileHelp;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.PAC_MD5Util;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageMessagePAC {
    private static Logger logger = LoggerFactory.getLogger(PackageMessagePAC.class);
    private static final String FORMAT = "json";
    private static final String SIGNTYPE = "md5";
    private static final String CHARSET = "utf-8";
    private static final String PARTNERCODE = "P_BCX_GA";
    private static final String DEPARTMENTCODE = "20126";

    public static String pay_pc(OrderFormVo dto, String url) throws Exception {
        String key = "OPENAPI";
        String returnUrl = GlobalResources.DONOW_PATH + "transaction/common-syntony/" + dto.getOid();
        if ("BLB".equals(dto.getWeb_type())) {
            returnUrl = GlobalResources.WEB_URL + "/insurance/tyx/transaction/syntony-service/" + dto.getOid();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dataSource", "179");
        map.put("customerName", dto.getApplicant_name());
        map.put("businessNo", dto.getNotice_no());
        map.put("currencyNo", "RMB");
        map.put("amount", dto.getGross_premium());
        map.put("documentNo", dto.getPolicy_serial_number());
        map.put("insuredName", dto.getInsured_role());
        map.put("key", key);
        String test = "179" + dto.getApplicant_name() + dto.getNotice_no() + "RMB" + dto.getGross_premium() + dto.getPolicy_serial_number() + key;
        String sign = PAC_MD5Util.sha256Hex((String)test);
        System.out.println("P-1> " + test);
        System.out.println("P-2> " + sign);
        map.put("signMsg", sign);
        map.put("callBackURL", returnUrl);
        map.put("url", url);
        map.remove("key");
        String data = JSONArray.toJSONString(map);
        System.out.println("P-3> " + data);
        return data;
    }

    public static String pay_app(OrderFormVo dto, String url) throws Exception {
        String key = "P_BCXZR_GP";
        String return_url = GlobalResources.DONOW_PATH + "/weixin/product/pay/finish/" + dto.getOid();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dataSource", "179");
        map.put("customerName", dto.getApplicant_name());
        map.put("businessNo", dto.getNotice_no());
        map.put("currencyNo", "RMB");
        map.put("amount", dto.getGross_premium());
        map.put("productName", dto.getProduct_name());
        map.put("callBackURL", return_url);
        String test = "179" + dto.getApplicant_name() + dto.getNotice_no() + "RMB" + dto.getGross_premium() + key;
        String sign = PAC_MD5Util.sha256Hex((String)test);
        System.out.println("P-1> test:" + test);
        System.out.println("P-2> sign:" + sign);
        map.put("signMsg", sign);
        map.put("url", url);
        String data = JSONArray.toJSONString(map);
        System.out.println("P-3> map:" + data);
        return data;
    }

    public static String pdqr_marshal(String policyNo, String transType, String endorseApplyNo, String actualPremiumChange, String transSerialNo) throws Exception {
        JSONObject jsonHead = new JSONObject();
        if (TransTypeEnum.PDQR.getValue().equals(transType)) {
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            jsonHead.put((Object)"requestId", (Object)String.valueOf(idWorker.nextId()));
            JSONObject moreInfo = new JSONObject();
            moreInfo.put((Object)"partnerCode", (Object)PARTNERCODE);
            moreInfo.put((Object)"edrSceneCode", (Object)"18002");
            moreInfo.put((Object)"policyNo", (Object)policyNo);
            moreInfo.put((Object)"endorseApplyNo", (Object)endorseApplyNo);
            moreInfo.put((Object)"actualPremiumChange", (Object)actualPremiumChange);
            moreInfo.put((Object)"confirmEndorse", (Object)"Y");
            moreInfo.put((Object)"transSerialNo", (Object)transSerialNo);
            moreInfo.put((Object)"isSendElectronicEndorse", (Object)"N");
            jsonHead.put((Object)"endorseInfo", (Object)moreInfo);
        }
        return jsonHead.toString();
    }

    public static String marshal(GMRPolicyVo vo, OrderFormVo dto, String transType, InsPreservationRecordVo iprVo) throws Exception {
        JSONObject jsonHead = new JSONObject();
        IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
        if (TransTypeEnum.HB.getValue().equals(transType)) {
            jsonHead.put((Object)"partnerCode", (Object)PARTNERCODE);
            jsonHead.put((Object)"transSerialNo", (Object)dto.getTrade_serial_number());
            jsonHead.put((Object)"departmentCode", (Object)DEPARTMENTCODE);
            JSONObject jsonContract = new JSONObject();
            JSONArray jsonApplicantArray = new JSONArray();
            JSONObject jsonApplicant = new JSONObject();
            PackageMessagePAC.doApplicantInfo(vo, dto, jsonApplicant);
            jsonApplicantArray.add((Object)jsonApplicant);
            jsonContract.put((Object)"applicantInfoList", (Object)jsonApplicantArray);
            JSONObject jsonBase = new JSONObject();
            PackageMessagePAC.doBaseInfo(vo, dto, jsonBase);
            jsonContract.put((Object)"baseInfo", (Object)jsonBase);
            JSONObject jsonExtend = new JSONObject();
            jsonExtend.put((Object)"isPolicyBeforePayfee", (Object)"1");
            jsonContract.put((Object)"extendInfo", (Object)jsonExtend);
            JSONArray jsonRiskPropertyArray = new JSONArray();
            JSONObject jsonRiskProperty = new JSONObject();
            PackageMessagePAC.doRiskGroupInfo(vo, dto, jsonRiskProperty);
            jsonRiskPropertyArray.add((Object)jsonRiskProperty);
            jsonContract.put((Object)"riskGroupInfoList", (Object)jsonRiskPropertyArray);
            jsonHead.put((Object)"contract", (Object)jsonContract);
        } else if (TransTypeEnum.CBXX.getValue().equals(transType)) {
            jsonHead.put((Object)"applyPolicyNo", (Object)dto.getPolicy_serial_number());
        } else if (TransTypeEnum.DZBD.getValue().equals(transType)) {
            String printTime = DateUtil.getCurrentDateTime();
            String productCode = PackageMessagePAC.getPlanCode(dto.getProduct_code());
            jsonHead.put((Object)"partnerCode", (Object)PARTNERCODE);
            jsonHead.put((Object)"departmentCode", (Object)DEPARTMENTCODE);
            jsonHead.put((Object)"productCode", (Object)productCode);
            jsonHead.put((Object)"policyNo", (Object)dto.getExternal_reference());
            jsonHead.put((Object)"signInfo", (Object)PackageMessagePAC.signInfo_sha256(dto.getExternal_reference(), productCode, printTime));
            jsonHead.put((Object)"printTime", (Object)printTime);
            jsonHead.put((Object)"documentType", (Object)"1");
        } else if (TransTypeEnum.DZPD.getValue().equals(transType)) {
            String printTime = DateUtil.getCurrentDateTime();
            String productCode = PackageMessagePAC.getPlanCode(dto.getProduct_code());
            jsonHead.put((Object)"partnerCode", (Object)PARTNERCODE);
            jsonHead.put((Object)"departmentCode", (Object)DEPARTMENTCODE);
            jsonHead.put((Object)"productCode", (Object)productCode);
            jsonHead.put((Object)"policyNo", (Object)dto.getExternal_reference());
            jsonHead.put((Object)"endorseNo", (Object)iprVo.getRevise_serial_num_ins());
            jsonHead.put((Object)"signInfo", (Object)PackageMessagePAC.signInfo_sha256(dto.getExternal_reference(), productCode, printTime));
            jsonHead.put((Object)"printTime", (Object)printTime);
            jsonHead.put((Object)"documentType", (Object)"3");
        } else if (TransTypeEnum.ZFDZ.getValue().equals(transType)) {
            String productCode = PackageMessagePAC.getPlanCode(dto.getProduct_code());
            jsonHead.put((Object)"partnerCode", (Object)PARTNERCODE);
            jsonHead.put((Object)"departmentCode", (Object)DEPARTMENTCODE);
            jsonHead.put((Object)"tradeNo", (Object)String.valueOf(idWorker.nextId()));
            jsonHead.put((Object)"productCode", (Object)productCode);
            jsonHead.put((Object)"noticeNo", (Object)dto.getNotice_no());
            jsonHead.put((Object)"amount", (Object)dto.getGross_premium());
            jsonHead.put((Object)"customerName", (Object)dto.getApplicant_name());
            jsonHead.put((Object)"productName", (Object)dto.getProduct_name());
            jsonHead.put((Object)"productType", (Object)"0A");
            jsonHead.put((Object)"signMsg", (Object)PackageMessagePAC.signMsg_sha256(dto, productCode));
            jsonHead.put((Object)"returnUrl", (Object)GlobalResources.WEB_URL);
            String returnUrl = GlobalResources.WEB_URL + "api/syntony-service/" + dto.getOid();
            if ("BLB".equals(dto.getWeb_type())) {
                returnUrl = GlobalResources.WEB_URL + "/insurance/tyx/transaction/syntony-service/" + dto.getOid();
            }
            jsonHead.put((Object)"frontNotifyUrl", (Object)returnUrl);
        } else if (TransTypeEnum.DZFP.getValue().equals(transType)) {
            jsonHead.put((Object)"partnerCode", (Object)PARTNERCODE);
            JSONArray invoiceArray = new JSONArray();
            JSONObject jsonInvoice = new JSONObject();
            PackageMessagePAC.doInvoice(vo, dto, jsonInvoice);
            invoiceArray.add((Object)jsonInvoice);
            jsonHead.put((Object)"invoiceList", (Object)invoiceArray);
        } else if (TransTypeEnum.PD.getValue().equals(transType)) {
            jsonHead.put((Object)"transSerialNo", (Object)iprVo.getRevise_serial_number());
            jsonHead.put((Object)"partnerCode", (Object)PARTNERCODE);
            jsonHead.put((Object)"departmentCode", (Object)DEPARTMENTCODE);
            jsonHead.put((Object)"policyNo", (Object)dto.getExternal_reference());
            jsonHead.put((Object)"edrSceneCode", (Object)"18002");
            jsonHead.put((Object)"requestId", (Object)DateUtil.convertDateToString((Date)new Date(), (String)"yyyyMMddHHmmss"));
            JSONObject moreInfo = new JSONObject();
            moreInfo.put((Object)"isSendElectronicEndorse", (Object)"N");
            moreInfo.put((Object)"effectiveDate", (Object)(iprVo.getInception_date() + " 00:00:00"));
            moreInfo.put((Object)"isBeforePayfee", (Object)"0");
            jsonHead.put((Object)"moreInfo", (Object)moreInfo);
            JSONArray riskPersonArray = new JSONArray();
            PackageMessagePAC.doRiskPersonList(iprVo, dto, riskPersonArray);
            jsonHead.put((Object)"riskPersonList", (Object)riskPersonArray);
        }
        return jsonHead.toString();
    }

    private static String signInfo_sha256(String policyNo, String productCode, String printTime) {
        return PAC_MD5Util.sha256Hex((String)(policyNo + productCode + printTime));
    }

    private static String signMsg_sha256(OrderFormVo dto, String productCode) {
        return PAC_MD5Util.sha256Hex((String)(PARTNERCODE + productCode + dto.getApplicant_name() + dto.getGross_premium() + dto.getNotice_no()));
    }

    private static void doBaseInfo(GMRPolicyVo vo, OrderFormVo dto, JSONObject json) {
        json.put((Object)"productCode", (Object)PackageMessagePAC.getPlanCode(dto.getProduct_code()));
        json.put((Object)"businessType", (Object)"2");
        json.put((Object)"amountCurrencyCode", (Object)"01");
        json.put((Object)"totalActualPremium", (Object)dto.getGross_premium());
        json.put((Object)"insuranceBeginDate", (Object)(dto.getInception_date() + " 00:00:00"));
        json.put((Object)"insuranceEndDate", (Object)(dto.getPlanned_end_date() + " 23:59:59"));
    }

    private static void doInvoice(GMRPolicyVo vo, OrderFormVo dto, JSONObject json) {
        JSONArray policyArray = new JSONArray();
        for (RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()) {
            if (!"1".equals(roleSubjectVo.getKind())) continue;
            String organizationCode = roleSubjectVo.getOrganization_code();
            if (StringUtils.isNotEmpty((CharSequence)organizationCode) && "1".equals(roleSubjectVo.getId_type())) {
                organizationCode = organizationCode.split("-")[0] + organizationCode.split("-")[1];
            }
            json.put((Object)"transactionNo", (Object)dto.getTrade_serial_number());
            json.put((Object)"invoiceCreater", (Object)PARTNERCODE);
            json.put((Object)"invoiceEmail", (Object)roleSubjectVo.getLink_email());
            json.put((Object)"invoicePhone", (Object)roleSubjectVo.getLink_tel());
            json.put((Object)"invoiceOwner", (Object)roleSubjectVo.getName_cn());
            json.put((Object)"taxPayerNO", (Object)organizationCode);
            if (vo.getMailPolicyVo() != null && "1".equals(vo.getMailPolicyVo().getNeed_receipt())) {
                json.put((Object)"taxPayerTel", (Object)vo.getMailPolicyVo().getTaker_mobile());
                json.put((Object)"taxPayerAddress", (Object)vo.getMailPolicyVo().getRegister_address_invoice());
                json.put((Object)"taxPayerBankName", (Object)vo.getMailPolicyVo().getBank_invoice());
                json.put((Object)"taxPayerBankAccount", (Object)vo.getMailPolicyVo().getBank_account_invoice());
            }
            JSONObject policyInfo = new JSONObject();
            policyInfo.put((Object)"policyNo", (Object)dto.getExternal_reference());
            policyInfo.put((Object)"personnelName", (Object)roleSubjectVo.getName_cn());
            policyInfo.put((Object)"certificateType", (Object)PackageMessagePAC.idTypeSet(roleSubjectVo.getId_type()));
            policyInfo.put((Object)"certificateNo", (Object)organizationCode);
            policyArray.add((Object)policyInfo);
        }
        json.put((Object)"policyList", (Object)policyArray);
    }

    private static void doRiskPersonList(InsPreservationRecordVo vo, OrderFormVo dto, JSONArray arr) {
        for (InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
            int age;
            JSONObject riskPerson = new JSONObject();
            String type = PackageMessagePAC.conventPType(vo.getRevise_type());
            riskPerson.put((Object)"status", (Object)type);
            riskPerson.put((Object)"personnelAttribute", (Object)"100");
            riskPerson.put((Object)"name", (Object)ipdVo.getName());
            riskPerson.put((Object)"certificateNo", (Object)ipdVo.getId_card());
            riskPerson.put((Object)"certificateType", (Object)PackageMessagePAC.getCard(ipdVo.getId_type()));
            riskPerson.put((Object)"birthday", (Object)ipdVo.getBirthday());
            try {
                age = DateUtil.getAge((String)ipdVo.getBirthday());
            }
            catch (Exception e) {
                age = 0;
            }
            riskPerson.put((Object)"age", (Object)String.valueOf(age));
            riskPerson.put((Object)"sexCode", (Object)("1".equals(ipdVo.getSex()) ? "M" : "F"));
            riskPerson.put((Object)"riskGroupName", (Object)PackageMessagePAC.getPlanName(dto.getProduct_code()));
            riskPerson.put((Object)"relationshipWithApplicant", (Object)"6");
            riskPerson.put((Object)"mobileTelephone", (Object)ipdVo.getTel());
            if ("C".equals(type) && ipdVo.getBusiness_vo() != null) {
                riskPerson.put((Object)"oldName", (Object)ipdVo.getBusiness_vo().getName());
                riskPerson.put((Object)"oldCertificateNo", (Object)ipdVo.getBusiness_vo().getId_card());
            }
            arr.add((Object)riskPerson);
        }
    }

    private static String conventPType(String revise_type) {
        String rt = "";
        if ("1".equals(revise_type)) {
            rt = "A";
        } else if ("2".equals(revise_type)) {
            rt = "D";
        } else if ("3".equals(revise_type)) {
            rt = "C";
        }
        return rt;
    }

    private static void doSpecialPromiseList(GMRPolicyVo vo, OrderFormVo dto, JSONArray arr) {
        JSONObject specialPromise = new JSONObject();
        specialPromise.put((Object)"businessType", (Object)"true");
        specialPromise.put((Object)"contentType", (Object)"1");
        specialPromise.put((Object)"promiseCode", (Object)"");
        specialPromise.put((Object)"promiseDesc", (Object)"");
        specialPromise.put((Object)"promiseType", (Object)"Y");
        specialPromise.put((Object)"sortIndex", (Object)"1");
        arr.add((Object)specialPromise);
    }

    private static void doRiskGroupInfo(GMRPolicyVo gvo, OrderFormVo dto, JSONObject json) {
        JSONArray riskPackageInfoArray = new JSONArray();
        JSONObject riskPackageInfoList = new JSONObject();
        riskPackageInfoList.put((Object)"applyNum", (Object)"1");
        riskPackageInfoList.put((Object)"productPackageCode", (Object)PackageMessagePAC.getProductPackageCode(dto.getProduct_code()));
        riskPackageInfoArray.add((Object)riskPackageInfoList);
        JSONArray riskPersonInfoArray = new JSONArray();
        List roleList = gvo.getRoleSubjectList();
        for (RoleSubjectVo vo : roleList) {
            int age;
            if (!"2".equals(vo.getKind())) continue;
            JSONObject riskPersonInfo = new JSONObject();
            riskPersonInfo.put((Object)"name", (Object)vo.getName_cn());
            try {
                age = DateUtil.getAge((String)vo.getBirth_date());
            }
            catch (Exception e) {
                age = 0;
            }
            riskPersonInfo.put((Object)"age", (Object)String.valueOf(age));
            riskPersonInfo.put((Object)"certificateNo", (Object)vo.getOrganization_code());
            riskPersonInfo.put((Object)"certificateType", (Object)PackageMessagePAC.getCard(vo.getId_type()));
            riskPersonInfo.put((Object)"birthday", (Object)vo.getBirth_date());
            riskPersonInfo.put((Object)"personnelAttribute", (Object)"100");
            riskPersonInfo.put((Object)"sexCode", (Object)("1".equals(vo.getSex()) ? "M" : "F"));
            riskPersonInfo.put((Object)"mobileTelephone", (Object)vo.getMobile());
            riskPersonInfo.put((Object)"professionClass", (Object)"2");
            riskPersonInfo.put((Object)"professionCode", (Object)PackageMessagePAC.getProfessionCode(vo.getMajor_group()));
            riskPersonInfo.put((Object)"relationshipWithApplicant", (Object)"1");
            riskPersonInfo.put((Object)"destinationCountry", (Object)"\u4e2d\u56fd");
            riskPersonInfoArray.add((Object)riskPersonInfo);
        }
        json.put((Object)"riskPackageInfoList", (Object)riskPackageInfoArray);
        json.put((Object)"riskPersonInfoList", (Object)riskPersonInfoArray);
    }

    private static String getProfessionCode(String major_group) {
        if (!GlobalResources.IS_TEST_ENVI.booleanValue()) {
            return "3".equals(major_group) ? "N010404" : "N010401";
        }
        return "3".equals(major_group) ? "0201002" : "0201002";
    }

    private static String getCard(String cardType) {
        if ("0".equals(cardType)) {
            return "01";
        }
        if ("3".equals(cardType)) {
            return "02";
        }
        if ("4".equals(cardType)) {
            return "06";
        }
        return "";
    }

    private static String getPlanCode(String product_code) {
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-PAC-1".equals(product_code)) {
            return "MP18010167";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-PAC-2".equals(product_code)) {
            return "MP18010166";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-PAC-3".equals(product_code)) {
            return "MP18010168";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-PAC-4".equals(product_code)) {
            return "MP18010169";
        }
        return "";
    }

    private static String getPlanName(String product_code) {
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-PAC-1".equals(product_code)) {
            return "\u65b9\u6848\u4e00";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-PAC-2".equals(product_code)) {
            return "\u65b9\u6848\u4e8c";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-PAC-3".equals(product_code)) {
            return "\u65b9\u6848\u4e09";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-PAC-4".equals(product_code)) {
            return "\u65b9\u6848\u56db";
        }
        return "";
    }

    private static String getProductPackageCode(String product_code) {
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-PAC-1".equals(product_code)) {
            return "PK00025205";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-PAC-2".equals(product_code)) {
            return "PK00025206";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-PAC-3".equals(product_code)) {
            return "PK00025207";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-PAC-4".equals(product_code)) {
            return "PK00025208";
        }
        return "";
    }

    private static void doApplicantInfo(GMRPolicyVo vo, OrderFormVo dto, JSONObject json) {
        for (RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()) {
            if (!"1".equals(roleSubjectVo.getKind())) continue;
            String organizationCode = roleSubjectVo.getOrganization_code();
            if (StringUtils.isNotEmpty((CharSequence)organizationCode) && "1".equals(roleSubjectVo.getId_type())) {
                organizationCode = organizationCode.split("-")[0] + organizationCode.split("-")[1];
            }
            json.put((Object)"name", (Object)roleSubjectVo.getName_cn().replace("\uff08", "(").replace("\uff09", ")"));
            json.put((Object)"personnelType", (Object)"0");
            json.put((Object)"certificateType", (Object)PackageMessagePAC.idTypeSet(roleSubjectVo.getId_type()));
            json.put((Object)"certificateNo", (Object)organizationCode);
            json.put((Object)"linkManName", (Object)roleSubjectVo.getLink_name());
            String address = RegionUtils.getRegionNameByALLCode((String)roleSubjectVo.getReg_province(), (String)roleSubjectVo.getReg_city(), (String)roleSubjectVo.getReg_district()) + roleSubjectVo.getReg_address();
            json.put((Object)"address", (Object)address);
            json.put((Object)"mobileTelephone", (Object)roleSubjectVo.getLink_tel());
            json.put((Object)"email", (Object)roleSubjectVo.getLink_email());
            if (vo.getMailPolicyVo() != null && "1".equals(vo.getMailPolicyVo().getNeed_receipt())) {
                json.put((Object)"invoicePrintType", (Object)("0".equals(vo.getMailPolicyVo().getInvoice_type()) ? "01" : "02"));
                json.put((Object)"billingAddress", (Object)vo.getMailPolicyVo().getRegister_address_invoice());
                json.put((Object)"billingPhone", (Object)vo.getMailPolicyVo().getTaker_mobile());
                json.put((Object)"billingDepositBank", (Object)vo.getMailPolicyVo().getBank_invoice());
                json.put((Object)"billingDepositBankAccount", (Object)vo.getMailPolicyVo().getBank_account_invoice());
                json.put((Object)"taxpayerCertificateType", (Object)"02");
                json.put((Object)"taxpayerCertificateNo", (Object)vo.getMailPolicyVo().getTaxpayer_number_invoice());
                continue;
            }
            json.put((Object)"invoicePrintType", (Object)"03");
        }
    }

    private static void doInsurantInfo(SpecialPublicDutyVo vo, OrderFormVo dto, JSONObject json) {
        for (RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()) {
            if (!"2".equals(roleSubjectVo.getKind())) continue;
            String organizationCode = roleSubjectVo.getOrganization_code();
            if (StringUtils.isNotEmpty((CharSequence)organizationCode) && "1".equals(roleSubjectVo.getId_type())) {
                organizationCode = organizationCode.split("-")[0] + organizationCode.split("-")[1];
            }
            json.put((Object)"name", (Object)roleSubjectVo.getName_cn().replace("\uff08", "(").replace("\uff09", ")"));
            json.put((Object)"personnelType", (Object)"1");
            json.put((Object)"certificateType", (Object)PackageMessagePAC.idTypeSet(roleSubjectVo.getId_type()));
            json.put((Object)"certificateNo", (Object)organizationCode);
            json.put((Object)"linkManName", (Object)roleSubjectVo.getLink_name());
            String address = RegionUtils.getRegionNameByALLCode((String)roleSubjectVo.getReg_province(), (String)roleSubjectVo.getReg_city(), (String)roleSubjectVo.getReg_district()) + roleSubjectVo.getReg_address();
            json.put((Object)"address", (Object)address);
            json.put((Object)"mobileTelephone", (Object)roleSubjectVo.getLink_tel());
        }
    }

    private static String idTypeSet(String value) {
        if ("1".equals(value)) {
            return "01";
        }
        if ("2".equals(value)) {
            return "03";
        }
        if ("6".equals(value)) {
            return "02";
        }
        if ("7".equals(value)) {
            return "04";
        }
        return "";
    }

    public static String returnAnalysisJson(String json, String transType) {
        JSONObject jsonHead = JSONObject.fromObject((Object)json);
        if (jsonHead == null) {
            return "300#\uff08APP-PAC-001\uff09\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u6570\u636e\uff01";
        }
        if (!"0".equals(jsonHead.get("ret"))) {
            return "300#\uff08APP-PAC-" + jsonHead.get("ret") + "\uff09" + jsonHead.get("msg");
        }
        if (TransTypeEnum.DZFP.getValue().equals(transType)) {
            JSONArray arr = JSONArray.parseArray((String)JSON.toJSONString((Object)jsonHead.get("data")));
            JSONObject jsonDate = JSONObject.fromObject((Object)arr.get(0));
            if (!"999999".equals(jsonDate.get("resultCode"))) {
                return "300#\uff08APP-PAC-" + jsonDate.get("resultCode") + "\uff09" + jsonDate.get("resultMessage");
            }
            String filePath = PackageMessagePAC.uploadFile(String.valueOf(jsonDate.get("invoiceValue")), "pdf", "/policy/");
            if (StringUtils.isNotEmpty((CharSequence)filePath)) {
                return "200#" + filePath;
            }
            return "300#\uff08APP-PAC-002\uff09\u7535\u5b50\u53d1\u7968\u6253\u5370\u6587\u4ef6\u6d41\u89e3\u6790\u5931\u8d25\uff01";
        }
        JSONObject jsonDate = JSONObject.fromObject((Object)jsonHead.get("data"));
        JSONObject resultJson = JSONObject.fromObject((Object)jsonDate.get("result"));
        if (TransTypeEnum.HB.getValue().equals(transType)) {
            if ("999999".equals(jsonDate.get("responseCode"))) {
                return "200#" + resultJson.get("applyPolicyNo") + "#" + resultJson.get("noticeNo") + "#" + resultJson.get("totalActualPremium") + "#" + resultJson.get("totalInsuredAmount");
            }
            return "300#\uff08APP-PAC-" + jsonDate.get("responseCode") + "\uff09" + jsonDate.get("responseMsg");
        }
        if (TransTypeEnum.CBXX.getValue().equals(transType)) {
            if ("999999".equals(jsonDate.get("responseCode")) || "888888".equals(jsonDate.get("responseCode"))) {
                return "200#" + resultJson.get("policyNo") + "#" + resultJson.get("applyPolicyNo") + "#" + resultJson.get("totalActualPremium");
            }
            return "300#\uff08APP-PAC-" + jsonDate.get("responseCode") + "\uff09" + jsonDate.get("responseMsg");
        }
        if (TransTypeEnum.DZBD.getValue().equals(transType)) {
            if (!"999999".equals(jsonDate.get("responseCode"))) {
                return "300#\uff08APP-PAC-" + jsonDate.get("responseCode") + "\uff09" + jsonDate.get("responseMsg");
            }
            String filePath = PackageMessagePAC.uploadFile(String.valueOf(jsonDate.get("fileData")), String.valueOf(jsonDate.get("fileType")), "/policy/");
            if (StringUtils.isNotEmpty((CharSequence)filePath)) {
                return "200#" + filePath;
            }
            return "300#\uff08APP-PAC-002\uff09\u7535\u5b50\u4fdd\u5355\u6253\u5370\u6587\u4ef6\u6d41\u89e3\u6790\u5931\u8d25\uff01";
        }
        if (TransTypeEnum.DZPD.getValue().equals(transType)) {
            if (!"999999".equals(jsonDate.get("responseCode"))) {
                return "300#\uff08APP-PAC-" + jsonDate.get("responseCode") + "\uff09" + jsonDate.get("responseMsg");
            }
            String filePath = PackageMessagePAC.uploadFile(String.valueOf(jsonDate.get("fileData")), String.valueOf(jsonDate.get("fileType")), "/policy/");
            if (StringUtils.isNotEmpty((CharSequence)filePath)) {
                return "200#" + filePath;
            }
            return "300#\uff08APP-PAC-002\uff09\u7535\u5b50\u6279\u5355\u6253\u5370\u6587\u4ef6\u6d41\u89e3\u6790\u5931\u8d25\uff01";
        }
        if (TransTypeEnum.ZFDZ.getValue().equals(transType)) {
            if ("SUCCESS".equals(jsonDate.get("resultCode"))) {
                return "200#" + jsonDate.get("tradeNo") + "#" + jsonDate.get("payUrl");
            }
            return "300#\uff08APP-PAC-" + jsonDate.get("resultCode") + "\uff09" + jsonDate.get("resultMsg");
        }
        if (TransTypeEnum.PD.getValue().equals(transType)) {
            if ("999999".equals(jsonDate.get("responseCode"))) {
                return "200#" + resultJson.get("policyNo") + "#" + resultJson.get("endorseNo") + "#" + resultJson.get("actualPremiumChange") + "#" + resultJson.get("endorseApplyNo");
            }
            return "300#\uff08APP-PAC-" + jsonDate.get("responseCode") + "\uff09" + jsonDate.get("responseMsg");
        }
        if (TransTypeEnum.PDQR.getValue().equals(transType)) {
            if ("999999".equals(jsonDate.get("responseCode"))) {
                return "200#" + resultJson.get("policyNo") + "#" + resultJson.get("endorseNo") + "#" + resultJson.get("actualPremiumChange") + "#" + resultJson.get("noticeNo");
            }
            return "300#\uff08APP-PAC-" + jsonDate.get("responseCode") + "\uff09" + jsonDate.get("responseMsg");
        }
        return "300#\uff08APP-PAC-001.1\uff09\u6570\u636e\u5904\u7406\u5931\u8d25\uff01";
    }

    public static void main(String[] args) {
        String a = "{\"ret\":\"0\",\"msg\":\"\",\"requestId\":\"null\",\"data\":[\n      {\n      \"resultCode\":\"999999\",\n      \"resultMessage\":\"\u8c03\u7528\u6210\u529f\",\n      \"responseCode\":\"999999\",\n      \"responseMsg\":\"\u8c03\u7528\u6210\u529f\",\n      \"transactionNo\":\"1189811087348985856\",\n      \"invoiceNo\":\"45109327\",\n      \"invoiceCode\":\"050003521270\",\n      \"invoiceAmount\":\"1240\",\n      \"invoiceValue\":\"bD4=\"\n    }\n]}";
        String b = PackageMessagePAC.returnAnalysisJson(a, "7");
        System.out.println(b);
    }

    public static String uploadFile(String fileStr, String fileType, String savePath) {
        String result = "";
        if (StringUtils.isEmpty((CharSequence)fileStr)) {
            return result;
        }
        try {
            if (StringUtils.isEmpty((CharSequence)fileType)) {
                fileType = "pdf";
            }
            byte[] bytes = BASE64Util.decryptBASE64Byte((String)fileStr);
            String files = DateUtil.generatorRadomNumber() + "." + fileType;
            result = savePath + files;
            String path = GlobalResources.COM_IMG_RE + savePath;
            FileHelp.byteFile((byte[])bytes, (String)path, (String)files);
            result = "/getResource?path=" + result;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "";
        }
        return result;
    }

    private static String getDate(String doTime, int status) {
        String result = "";
        if (StringUtils.isEmpty((CharSequence)doTime)) {
            return result;
        }
        try {
            if (status == 0) {
                result = DateUtil.convertDateToString((Date)DateUtil.parseDate((String)doTime), (String)"yyyy-MM-dd");
            } else if (status == 1) {
                result = DateUtil.convertDateToString((Date)DateUtil.parseDate((String)doTime), (String)"yyyy-MM-dd");
                if (StringUtils.isNotEmpty((CharSequence)result)) {
                    result = result + " 00:00:00";
                }
            } else if (status == 2) {
                Date beT = DateUtil.parseDate((String)doTime);
                Calendar cDate = Calendar.getInstance();
                cDate.setTime(beT);
                cDate.set(5, cDate.get(5) - 1);
                result = DateUtil.convertDateToString((Date)beT, (String)"yyyy-MM-dd");
                if (StringUtils.isNotEmpty((CharSequence)result)) {
                    result = result + " 23:59:59";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String getCityCodeByPro(String pro, String city) {
        if ("110000".equals(pro)) {
            return pro;
        }
        if ("120000".equals(pro)) {
            return pro;
        }
        if ("500000".equals(pro)) {
            return pro;
        }
        if ("310000".equals(pro)) {
            return pro;
        }
        if ("710000".equals(pro)) {
            return pro;
        }
        if ("810000".equals(pro)) {
            return pro;
        }
        if ("820000".equals(pro)) {
            return pro;
        }
        return city;
    }

    private static void doResultCheDan() {
        String resultMsg = "{\"header\":{\"transactionCode\":\"TCEGISNBUWD001\",\"partnerId\":\"PCXM001\",\"requestId\":\"1493865755617\",\"code\":\"CRIGHT_0000\",\"message\":null},\"body\":\"\\\"{\\\\\\\"errorMessage\\\\\\\":\\\\\\\"fail\\\\\\\",\\\\\\\"rcptnoList\\\\\\\":[{\\\\\\\"message\\\\\\\":\\\\\\\"\u6761\u5f62\u78019041K009837424\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u5141\u8bb8\u8fdb\u884c\u64a4\u4ef6\\\\\\\",\\\\\\\"no\\\\\\\":\\\\\\\"30000070075776495\\\\\\\"}],\\\\\\\"resultFlag\\\\\\\":\\\\\\\"-1\\\\\\\"}\\\"\"}";
        Map map = null;
        try {
            map = (Map)JSON.parseObject((String)resultMsg, Map.class);
            Map header = (Map)JSON.parseObject((String)map.get("header").toString(), Map.class);
            if (!header.get("code").equals("CRIGHT_0000")) {
                logger.info("300#\u64a4\u5355\u5931\u8d25");
                return;
            }
            String bodyStr = map.get("body").toString();
            bodyStr = bodyStr.replaceFirst("\"", "");
            bodyStr = bodyStr.substring(ConstProp.INT_NUMBER_ZERO, bodyStr.lastIndexOf(34));
            Map body = (Map)JSON.parseObject((String)(bodyStr = bodyStr.replace("\\", "")), Map.class);
            if (body.get("resultFlag").toString().equals("0")) {
                String errorMessage = body.get("errorMessage").toString();
                logger.info("200#" + errorMessage);
            } else {
                JSONArray array = JSON.parseArray((String)body.get("rcptnoList").toString());
                String result = "";
                for (int i = ConstProp.INT_NUMBER_ZERO.intValue(); i < array.size(); ++i) {
                    com.alibaba.fastjson.JSONObject object = (com.alibaba.fastjson.JSONObject)array.get(i);
                    result = result + "#" + object.get((Object)"message") + "#" + object.get((Object)"no");
                }
                String errorMessage = body.get("resultFlag").toString();
                logger.info("300" + result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void doResultTouBao() {
        String resultMsg = "{\"header\":{\"transactionCode\":\"TCEGISNBUAPC001\",\"partnerId\":\"PCXM001\",\"requestId\":\"1493866040327\",\"code\":\"CRIGHT_0000\",\"message\":null},\"body\":\"{\\\"barCode\\\":\\\"9041K009837633\\\",\\\"receiptNo\\\":\\\"30000070075777063\\\",\\\"responseMsg\\\":\\\"AMESB\u63a5\u53e3InsuredAMESBService\u8c03\u7528\u6210\u529f\uff01\\\",\\\"returnFlag\\\":\\\"1\\\",\\\"totalPremium\\\":\\\"510\\\"}\"}";
        Map map = null;
        try {
            map = (Map)JSON.parseObject((String)resultMsg, Map.class);
            Map header = (Map)JSON.parseObject((String)map.get("header").toString(), Map.class);
            if (header.get("code").equals("CRIGHT_0000")) {
                Map body = (Map)JSON.parseObject((String)map.get("body").toString(), Map.class);
                String receiptNo = body.get("receiptNo").toString();
                String totalPremium = body.get("totalPremium").toString();
                logger.info("200#" + receiptNo + "#" + totalPremium + "#" + "http://www.baidu.com");
            } else {
                Map message = (Map)JSON.parseObject((String)header.get("message").toString(), Map.class);
                String msg = message.get("ResponseMsg").toString();
                logger.info("300#" + msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

