/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.tyx.pingan.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.third.tyx.pingan.util.Base64Utils;
import com.bcxin.ins.third.tyx.pingan.util.PaAesUtils;
import com.bcxin.ins.third.tyx.pingan.util.PaRsaUtils;
import com.bcxin.ins.util.GlobalResources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownload {
    private static Logger logger = LoggerFactory.getLogger(FileDownload.class);

    public String getFileAddress(String fileId) {
        try {
            String path = this.sendRequest(fileId);
            if (path == null) {
                return null;
            }
            return "/getResource.do?path=" + path;
        }
        catch (Exception ex) {
            logger.error("FD-ERROR-00007:\u8def\u5f84\u5904\u7406\u5f02\u5e38", (Throwable)ex);
            return null;
        }
    }

    public String sendRequest(String fileId) throws HttpException, Exception {
        String privateKey = GlobalResources.PN_POLICY_FILE_KEY;
        JSONObject returnParams = new JSONObject();
        returnParams.put("partnerId", (Object)"PCXM001");
        returnParams.put("fileId", (Object)fileId);
        returnParams.put("timestamp", (Object)System.currentTimeMillis());
        String params = returnParams.toString();
        String sign = "";
        try {
            sign = PaRsaUtils.sign(params.getBytes(), privateKey);
        }
        catch (Exception e) {
            logger.error("FD-ERROR-00001:\u52a0\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u79c1\u94a5\u3010privateKey\u3011\u548c\u53c2\u6570\u3010params\u3011", (Throwable)e);
            return null;
        }
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
        PostMethod method = new PostMethod(GlobalResources.PN_POLICY_FILE);
        method.setParameter("params", params);
        method.setParameter("sign", sign);
        httpClient.executeMethod((HttpMethod)method);
        Header headerParams = method.getResponseHeader("parameters");
        if (headerParams == null) {
            logger.error("FD-ERROR-00002:failed to get a reply");
            return null;
        }
        String plaintext = this.decode(headerParams.getValue());
        JSONObject paramObject = JSON.parseObject((String)plaintext);
        String returnCode = (String)paramObject.get((Object)"returnCode");
        String returnMessage = (String)paramObject.get((Object)"returnMessage");
        if (!returnCode.equals("0000")) {
            logger.error("FD-ERROR-00006:\u975e0000\uff0c\u7686\u9519");
            return null;
        }
        String encryptDir = "\\encryptDir\\";
        String decryptDir = "\\decrypted\\";
        String fileName = (String)paramObject.get((Object)"fileName");
        File encryptDirFile = new File(GlobalResources.COM_IMG_RE + encryptDir);
        File decryptDirFile = new File(GlobalResources.COM_IMG_RE + decryptDir);
        if (!encryptDirFile.exists()) {
            encryptDirFile.mkdirs();
        }
        if (!decryptDirFile.exists()) {
            decryptDirFile.mkdirs();
        }
        try (InputStream bis = method.getResponseBodyAsStream();
             FileOutputStream fos = new FileOutputStream(GlobalResources.COM_IMG_RE + encryptDir + fileName);){
            byte[] arrayOfByte = new byte[1024];
            int i = -1;
            while ((i = bis.read(arrayOfByte)) != -1) {
                ((OutputStream)fos).write(arrayOfByte, 0, i);
            }
            fos.flush();
        }
        Header parametersEncrypted = method.getResponseHeader("parametersEncrypted");
        if (parametersEncrypted == null) {
            logger.error("FD-ERROR-00005:\u5bc6\u6587\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
            return null;
        }
        JSONObject parametersEncryptedJson = JSON.parseObject((String)new String(PaRsaUtils.decryptByPrivateKey(this.baseDecode(this.decode(parametersEncrypted.getValue())), privateKey)));
        logger.info("(FileDownload),parametersEncryptedJson:" + parametersEncryptedJson.toJSONString());
        String encryptMode = parametersEncryptedJson.getString("encryptMode");
        String encryptKey = parametersEncryptedJson.getString("encryptKey");
        Integer encryptKeySize = parametersEncryptedJson.getInteger("encryptKeySize");
        String lastFilePath = null;
        logger.info("(FileDownload),encryptKey:" + encryptKey);
        if ("AES".equals(encryptMode)) {
            logger.info("(FileDownload),encryptDir-url:" + GlobalResources.COM_IMG_RE + encryptDir + fileName);
            logger.info("(FileDownload),decryptDir-url:" + GlobalResources.COM_IMG_RE + decryptDir + fileName);
            PaAesUtils.decryptFile(encryptKey, GlobalResources.COM_IMG_RE + encryptDir + fileName, GlobalResources.COM_IMG_RE + decryptDir + fileName);
            lastFilePath = decryptDir + fileName;
            return lastFilePath;
        }
        if ("PLAIN".equals(encryptMode)) {
            lastFilePath = encryptDir + fileName;
            return lastFilePath;
        }
        return null;
    }

    private String decode(String data) throws IOException {
        return URLDecoder.decode(data, "GBK");
    }

    private byte[] baseDecode(String data) throws IOException {
        return Base64Utils.decode(data);
    }
}

