/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.gzx.pingancai;

import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.third.gzx.pingancai.GZX_PackageMessagePingAnCai;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="gZX_PACRequestService")
@Transactional
public class GZX_PACRequestService {
    private Logger communicatorLog = LoggerFactory.getLogger(GZX_PACRequestService.class);
    @Autowired
    private PolicyService policyService;
    @Autowired
    private LogBusinessrequestService logBusinessrequestService;

    public String requestPAC(Long order_id, String transType, Map<String, String> map) throws Exception {
        this.communicatorLog.info("requestPAC-GZX\uff1astar-----------------------");
        this.communicatorLog.info("requestPAC-GZX\uff1a\u63a5\u53e3\u7f16\u7801-" + transType + ",\u8ba2\u5355id-" + order_id + ",MAP-" + (map != null ? map.toString() : "null"));
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        SpecialPublicDutyVo vo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(Long.parseLong(dto.getOid()));
        String result = "300#\uff08APP-PAC-GZX-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
        LogBusinessrequest lb = null;
        try {
            String json = GZX_PackageMessagePingAnCai.marshal(vo, dto, transType, map);
            this.communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + json);
            String url = GlobalResources.PN_INS_URL + "/open/" + GZX_PACRequestService.getUrlByTransType(transType) + "?access_token=" + this.policyService.pnc_access_token();
            this.communicatorLog.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
            Date bTime = new Date();
            String ret = RequestUtil.initHttp().doPostByAccept(url, json, "application/json", "UTF-8");
            lb = this.logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id), transType, url, json, ret, bTime, new Date(), TransTypeEnum.getAlias((String)transType));
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
            result = GZX_PackageMessagePingAnCai.returnAnalysisJson(ret, transType);
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
            this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
        }
        catch (Exception ex) {
            this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
            ex.printStackTrace();
        }
        this.communicatorLog.info("requestPAC-GZX\uff1aend-----------------------");
        return result;
    }

    private static String getUrlByTransType(String type) {
        if ("1".equals(type)) {
            return "/appsvr/property/standardGroupPropertyFeeApply";
        }
        if ("2".equals(type)) {
            return "/appsvr/property/standardGroupPropertyFeeAccept";
        }
        if ("3".equals(type)) {
            return "/appsvr/property/ePasElectronicPolicy";
        }
        return "";
    }
}

