/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.gzx.huatai;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static String sendPostRequest(String url, List<NameValuePair> params) {
        log.info("--------\u5f00\u59cb\u53d1\u9001http\u8bf7\u6c42--------");
        log.info("\u8bf7\u6c42\u5730\u5740:[{}]\uff1a" + url);
        log.info(params.toString());
        Stopwatch stopwatch = Stopwatch.createStarted();
        String result = "";
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
            CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = resp.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)StandardCharsets.UTF_8.toString());
            long nanos = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            log.info("\u8fd4\u56de\u7ed3\u679c\uff1a[{}]" + result);
            log.info("\u5171\u8017\u65f6[{}]\u6beb\u79d2\uff1a" + nanos);
            log.info("--------\u7ed3\u675fhttp\u8bf7\u6c42--------");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static Map<String, String> getAllRequestParam(HttpServletRequest request) {
        HashMap<String, String> res = new HashMap<String, String>();
        Enumeration temp = request.getParameterNames();
        if (null != temp) {
            while (temp.hasMoreElements()) {
                String en = (String)temp.nextElement();
                String value = request.getParameter(en);
                res.put(en, value);
                if (null != res.get(en) && !"".equals(res.get(en))) continue;
                res.remove(en);
            }
        }
        return res;
    }

    public static Map<String, String> getMapValue(String data) {
        JSONObject jsonback = JSONObject.parseObject((String)data);
        HashMap map = Maps.newHashMap();
        for (String key : jsonback.keySet()) {
            if (jsonback.get((Object)key) == null) continue;
            String value = (String)jsonback.get((Object)key);
            map.put(key, value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) {
        StringBuilder sb1 = new StringBuilder();
        byte[] bytes = new byte[4096];
        int size = 0;
        try {
            while ((size = is.read(bytes)) > 0) {
                String str = new String(bytes, 0, size, "UTF-8");
                sb1.append(str);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb1.toString();
    }
}

