/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.gzx.huatai;

import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.third.gzx.huatai.HttpUtil;
import com.bcxin.ins.third.gzx.huatai.util.Policy_ActivityFireFight;
import com.bcxin.ins.third.gzx.huatai.util.Policy_ActivityLocal;
import com.bcxin.ins.third.gzx.huatai.util.Policy_ActivityType;
import com.bcxin.ins.third.gzx.huatai.util.Whether;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.MD5Util;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class HtPolicyService {
    private Logger log = LoggerFactory.getLogger(HtPolicyService.class);
    @Autowired
    private LogBusinessrequestService logBusinessrequestService;

    private String assemblePolicy(InsInsuranceSlip policy, SpecialPublicDutyVo policyExtra, InsTransaction transaction) throws UnsupportedEncodingException {
        JSONObject json = new JSONObject();
        JSONObject channelObject = new JSONObject();
        channelObject.put((Object)"bizCode", (Object)"101");
        channelObject.put((Object)"channelCode", (Object)GlobalResources.HT_CHANNELCODE);
        channelObject.put((Object)"channelName", (Object)"\u767e\u5ddd\u4fe1\uff08\u53a6\u95e8\uff09\u7f51\u7edc\u4fe1\u606f\u670d\u52a1\u6709\u9650\u516c\u53f8");
        Date d = new Date();
        channelObject.put((Object)"createTime", (Object)DateUtil.convertDateToString((Date)d, (String)"yyyy-MM-dd HH:mm:ss"));
        channelObject.put((Object)"orderId", (Object)policy.getTrade_serial_number());
        JSONObject insuranceObject = new JSONObject();
        insuranceObject.put((Object)"insuranceCode", (Object)"2502");
        insuranceObject.put((Object)"insuranceName", (Object)"\u516c\u4f17\u8d23\u4efb\u9669");
        insuranceObject.put((Object)"amount", (Object)HtPolicyService.convertAmount(policyExtra.getInsured_amount()));
        insuranceObject.put((Object)"plan", (Object)"A");
        insuranceObject.put((Object)"prmCur", (Object)"01");
        insuranceObject.put((Object)"premium", (Object)HtPolicyService.confirmPayEnvi(policy.getPremium()));
        insuranceObject.put((Object)"amtCur", (Object)"01");
        insuranceObject.put((Object)"copy", (Object)"1");
        insuranceObject.put((Object)"effectiveTime", (Object)DateUtil.convertDateToString((Date)policy.getInception_date(), (String)"yyyy-MM-dd HH:mm:ss"));
        insuranceObject.put((Object)"terminalTime", (Object)("" + DateUtil.dateFormatLast((String)DateUtil.convertDateToString((Date)policy.getPlanned_end_date(), (String)"yyyy-MM-dd HH:mm:ss"))));
        BigDecimal baofei = new BigDecimal(policy.getPremium().toString());
        BigDecimal baoe = new BigDecimal(HtPolicyService.convertAmount(policyExtra.getInsured_amount()));
        insuranceObject.put((Object)"rate", (Object)baofei.multiply(new BigDecimal("1000")).divide(baoe, 4, RoundingMode.HALF_UP).toString());
        RoleSubjectVo rpApplicant = (RoleSubjectVo)policyExtra.getRoleSubjectList().get(0);
        JSONObject appntObject = new JSONObject();
        if ("7".equals(rpApplicant.getId_type())) {
            appntObject.put((Object)"appIDType", (Object)"96");
        } else if ("8".equals(rpApplicant.getId_type())) {
            appntObject.put((Object)"appIDType", (Object)"97");
        } else if ("9".equals(rpApplicant.getId_type())) {
            appntObject.put((Object)"appIDType", (Object)"06");
        }
        appntObject.put((Object)"appName", (Object)rpApplicant.getName_cn());
        appntObject.put((Object)"appNumber", (Object)rpApplicant.getOrganization_code());
        appntObject.put((Object)"appType", (Object)"2");
        appntObject.put((Object)"appAddr", (Object)(RegionUtils.getRegionNameByALLCode((String)rpApplicant.getReg_province(), (String)rpApplicant.getReg_city(), (String)rpApplicant.getReg_district()) + rpApplicant.getReg_address()));
        if (policy.getMailPolicy() != null && "1".equals(policy.getMailPolicy().getNeed_receipt())) {
            if ("2".equals(policy.getMailPolicy().getInvoice_type())) {
                appntObject.put((Object)"isTaxInvoice", (Object)"1");
                appntObject.put((Object)"appTelNumber", (Object)policy.getMailPolicy().getReceipt_phone());
                appntObject.put((Object)"appContact", (Object)"\u8054\u7cfb\u4eba\u540d\u5b57");
                appntObject.put((Object)"taxCertifi", (Object)"\u7a0e\u52a1\u767b\u8bb0\u8bc1\u53f7");
                appntObject.put((Object)"depositBank", (Object)"\u5f00\u6237\u94f6\u884c");
                appntObject.put((Object)"bankAccount", (Object)"\u94f6\u884c\u8d26\u6237");
            }
        } else {
            appntObject.put((Object)"isTaxInvoice", (Object)"0");
        }
        RoleSubjectVo rpInsured = (RoleSubjectVo)policyExtra.getRoleSubjectList().get(1);
        JSONArray insuredObjectArray = new JSONArray();
        JSONObject insuredObject = new JSONObject();
        if ("7".equals(rpInsured.getId_type())) {
            insuredObject.put((Object)"insuredIDType", (Object)"96");
        } else if ("8".equals(rpInsured.getId_type())) {
            insuredObject.put((Object)"insuredIDType", (Object)"97");
        } else if ("9".equals(rpInsured.getId_type())) {
            insuredObject.put((Object)"insuredIDType", (Object)"06");
        }
        insuredObject.put((Object)"insuredName", (Object)rpInsured.getName_cn());
        insuredObject.put((Object)"insuredNumber", (Object)rpInsured.getOrganization_code());
        insuredObject.put((Object)"insuredTelNumber", (Object)rpInsured.getLink_phone());
        insuredObject.put((Object)"insuredType", (Object)"2");
        insuredObject.put((Object)"isLegal", (Object)"1");
        insuredObject.put((Object)"insuredAddress", (Object)(RegionUtils.getRegionNameByALLCode((String)rpInsured.getReg_province(), (String)rpInsured.getReg_city(), (String)rpInsured.getReg_district()) + rpInsured.getReg_address()));
        insuredObjectArray.add((Object)insuredObject);
        JSONObject definedSafeObj = new JSONObject();
        definedSafeObj.put((Object)"isDefinedSafe", (Object)"1");
        JSONArray rdrDTOs = new JSONArray();
        JSONObject rdrDTO1 = new JSONObject();
        rdrDTO1.put((Object)"itemId", (Object)1);
        rdrDTO1.put((Object)"rdrAmount", (Object)HtPolicyService.convertAmount(policyExtra.getInsured_amount()));
        rdrDTO1.put((Object)"rdrCode", (Object)"01");
        rdrDTO1.put((Object)"rdrName", (Object)"\u516c\u4f17\u8d23\u4efb\u9669");
        rdrDTO1.put((Object)"rdrPremium", (Object)policy.getPremium().toString());
        rdrDTO1.put((Object)"rdrDeductible", (Object)"");
        rdrDTO1.put((Object)"rdrRemark", (Object)"");
        JSONObject rdrDTO2 = new JSONObject();
        rdrDTO2.put((Object)"itemId", (Object)2);
        rdrDTO2.put((Object)"rdrAmount", (Object)"0");
        rdrDTO2.put((Object)"rdrCode", (Object)"02");
        rdrDTO2.put((Object)"rdrName", (Object)"\u4ea4\u53c9\u8d23\u4efb\u6761\u6b3e");
        rdrDTO2.put((Object)"rdrPremium", (Object)"0");
        rdrDTO2.put((Object)"rdrDeductible", (Object)"");
        rdrDTO2.put((Object)"rdrRemark", (Object)"");
        JSONObject rdrDTO3 = new JSONObject();
        rdrDTO3.put((Object)"itemId", (Object)3);
        rdrDTO3.put((Object)"rdrAmount", (Object)"0");
        rdrDTO3.put((Object)"rdrCode", (Object)"03");
        rdrDTO3.put((Object)"rdrName", (Object)"\u7f62\u5de5\u3001\u66b4\u4e71\u3001\u6c11\u4f17\u9a9a\u52a8\u53ca\u6076\u610f\u7834\u574f\u6761\u6b3e");
        rdrDTO3.put((Object)"rdrPremium", (Object)"0");
        rdrDTO3.put((Object)"rdrDeductible", (Object)"");
        rdrDTO3.put((Object)"rdrRemark", (Object)"");
        JSONObject rdrDTO4 = new JSONObject();
        rdrDTO4.put((Object)"itemId", (Object)4);
        rdrDTO4.put((Object)"rdrAmount", (Object)"0");
        rdrDTO4.put((Object)"rdrCode", (Object)"04");
        rdrDTO4.put((Object)"rdrName", (Object)"\u706b\u707e\u548c\u7206\u70b8\u8d23\u4efb\u6761\u6b3e");
        rdrDTO4.put((Object)"rdrPremium", (Object)"0");
        rdrDTO4.put((Object)"rdrDeductible", (Object)"");
        rdrDTO4.put((Object)"rdrRemark", (Object)"");
        JSONObject rdrDTO5 = new JSONObject();
        rdrDTO5.put((Object)"itemId", (Object)5);
        rdrDTO5.put((Object)"rdrAmount", (Object)"0");
        rdrDTO5.put((Object)"rdrCode", (Object)"05");
        rdrDTO5.put((Object)"rdrName", (Object)"\u6025\u6551\u8d39\u7528\u6761\u6b3e");
        rdrDTO5.put((Object)"rdrPremium", (Object)"0");
        rdrDTO5.put((Object)"rdrDeductible", (Object)"");
        rdrDTO5.put((Object)"rdrRemark", (Object)"");
        JSONObject rdrDTO6 = new JSONObject();
        rdrDTO6.put((Object)"itemId", (Object)6);
        rdrDTO6.put((Object)"rdrAmount", (Object)"0");
        rdrDTO6.put((Object)"rdrCode", (Object)"06");
        rdrDTO6.put((Object)"rdrName", (Object)"\u5e7f\u544a\u62db\u724c\u53ca\u88c5\u9970\u7269\u8d23\u4efb\u6761\u6b3e");
        rdrDTO6.put((Object)"rdrPremium", (Object)"0");
        rdrDTO6.put((Object)"rdrDeductible", (Object)"");
        rdrDTO6.put((Object)"rdrRemark", (Object)"");
        rdrDTOs.add((Object)rdrDTO1);
        rdrDTOs.add((Object)rdrDTO2);
        rdrDTOs.add((Object)rdrDTO3);
        rdrDTOs.add((Object)rdrDTO4);
        rdrDTOs.add((Object)rdrDTO5);
        rdrDTOs.add((Object)rdrDTO6);
        definedSafeObj.put((Object)"rdrDTOs", (Object)rdrDTOs.toString());
        JSONObject payObject = new JSONObject();
        payObject.put((Object)"isSinglePay", (Object)"1");
        payObject.put((Object)"payMode", (Object)"23");
        payObject.put((Object)"payDate", (Object)DateUtil.convertDateToString((Date)d, (String)"yyyy-MM-dd HH:mm:ss"));
        payObject.put((Object)"payBankNo", (Object)transaction.getPay_order_number());
        JSONObject agreementObject = new JSONObject();
        agreementObject.put((Object)"policyDeductible", (Object)"\u8d22\u4ea7\u635f\u5931500\u5143\uff0c\u4eba\u8eab\u4f24\u5bb3\u65e0\u514d\u8d54");
        JSONObject productDiffObject = new JSONObject();
        String localAddress = policyExtra.getReport_local();
        if (localAddress.endsWith("#")) {
            localAddress = localAddress.substring(0, localAddress.length() - 1);
        }
        productDiffObject.put((Object)"activityArea", (Object)localAddress);
        productDiffObject.put((Object)"activityName", (Object)policyExtra.getReport_name());
        Policy_ActivityType activityType = Policy_ActivityType.convert_value(policyExtra.getReport_active());
        productDiffObject.put((Object)"activityType", (Object)activityType.getName());
        productDiffObject.put((Object)"activityTime", (Object)(policyExtra.getReport_begin_date() + "-" + policyExtra.getReport_end_date()));
        Policy_ActivityLocal activityLocal = Policy_ActivityLocal.convert_name(policyExtra.getActivity_local());
        productDiffObject.put((Object)"activityPlace", (Object)activityLocal.getName());
        Policy_ActivityFireFight activityFireFight = Policy_ActivityFireFight.convert_name(policyExtra.getActivity_fire_fight());
        productDiffObject.put((Object)"activityFireFight", (Object)activityFireFight.getName());
        Whether whether = Whether.convert_name(policyExtra.getDanger());
        productDiffObject.put((Object)"isActivityDanger", (Object)whether.getName());
        productDiffObject.put((Object)"activityAttendSum", (Object)policyExtra.getPeople_num());
        productDiffObject.put((Object)"accidentRdrAmount", (Object)HtPolicyService.convertAmount(policyExtra.getInsured_amount()));
        productDiffObject.put((Object)"injuryRdrAmount", (Object)"250000");
        productDiffObject.put((Object)"businessNature", (Object)rpInsured.getCom_type());
        String disputeString = policyExtra.getDispute();
        if ("0".equals(disputeString)) {
            productDiffObject.put((Object)"disputeHandling", (Object)"02");
            productDiffObject.put((Object)"arbitrationOrg", (Object)"");
        } else {
            productDiffObject.put((Object)"disputeHandling", (Object)"01");
            productDiffObject.put((Object)"arbitrationOrg", (Object)policyExtra.getPolicy_extra_dispute());
        }
        productDiffObject.put((Object)"reMark", (Object)"\u672c\u4fdd\u5355\u4e0d\u8d1f\u8d23\u8d54\u507f\u7531\u4e8e\u7b2c\u4e09\u8005\u81ea\u8eab\u539f\u56e0\uff08\u5305\u62ec\u4f46\u4e0d\u9650\u4e8e\u81ea\u8eab\u75be\u75c5\u3001\u81ea\u8eab\u8fd0\u52a8\u635f\u4f24\u3001\u81ea\u8eab\u4f53\u8d28\u7b49\uff09\u5bfc\u81f4\u7684\u4eba\u8eab\u4f24\u4ea1\u6216\u8d22\u4ea7\u635f\u5931\u4e8b\u6545 , \u88ab\u4fdd\u9669\u4eba\u6240\u627f\u62c5\u7684\u7ecf\u6d4e\u8d54\u507f\u8d23\u4efb,\u53c2\u4e0e\u6587\u827a\u6f14\u51fa\u3001\u4f53\u80b2\u8d5b\u4e8b\u7684\u6f14\u5458\u3001\u8fd0\u52a8\u5458\u4e0d\u5728\u672c\u4fdd\u5355\u627f\u4fdd\u8303\u56f4\u5185,\u7528\u4e8e\u5c55\u51fa\u7684\u5c55\u54c1\u906d\u53d7\u7684\u4efb\u4f55\u635f\u5931\uff0c\u4e0d\u5728\u672c\u4fdd\u5355\u627f\u4fdd\u8303\u56f4\u5185");
        json.put((Object)"agreementObject", (Object)agreementObject);
        json.put((Object)"appntObject", (Object)appntObject);
        json.put((Object)"channelObject", (Object)channelObject);
        json.put((Object)"definedSafeObj", (Object)definedSafeObj);
        json.put((Object)"insuranceObject", (Object)insuranceObject);
        json.put((Object)"insuredObject", (Object)insuredObjectArray);
        json.put((Object)"payObject", (Object)payObject);
        json.put((Object)"productDiffObject", (Object)productDiffObject);
        System.out.println("\u534e\u6cf0\u6295\u4fdd\u8bf7\u6c42\u62a5\u6587\uff1a" + json.toString());
        return json.toString();
    }

    public String insureInvoke(InsInsuranceSlip policy, SpecialPublicDutyVo policyExtra, InsTransaction transaction) throws Exception {
        String insureJson = this.assemblePolicy(policy, policyExtra, transaction);
        this.log.info("HtPolicyService\u534e\u6cf0\u8bf7\u6c42\u62a5\u6587:" + insureJson);
        insureJson = insureJson.replaceAll("%", "%25").replaceAll("&", "%26").replaceAll("\\+", "%2B");
        this.log.info("HtPolicyService\u534e\u6cf0\u8bf7\u6c42\u62a5\u6587\uff08\u8fc7\u6ee4\uff09:" + insureJson);
        String result = "";
        ArrayList params = Lists.newArrayList();
        params.add(new BasicNameValuePair("insureJson", insureJson));
        params.add(new BasicNameValuePair("channel", GlobalResources.HT_CHANNELCODE));
        params.add(new BasicNameValuePair("transSign", MD5Util.string2MD5((String)(GlobalResources.HT_CHANNELCODE + DateUtil.getCurrentDate()))));
        String url = GlobalResources.P_SERVICES_URL + "/ht/policy/insure";
        result = HttpUtil.sendPostRequest(url, params);
        Date bTime = new Date();
        LogBusinessrequest lb = this.logBusinessrequestService.initLogBusinessrequest(String.valueOf(policy.getTrade_serial_number()), "5", url, insureJson, result, bTime, new Date(), TransTypeEnum.getAlias((String)"5"));
        this.logBusinessrequestService.supplementDecAndSave(lb, result.contains("policyNO") ? 1 : 0, "");
        return result;
    }

    public String htPay(HttpServletResponse res, InsInsuranceSlip policy, RoleSubjectVo applicant) {
        ArrayList params = Lists.newArrayList();
        params.add(new BasicNameValuePair("premium", HtPolicyService.confirmPayEnvi(policy.getPremium())));
        params.add(new BasicNameValuePair("orderNo", policy.getTrade_serial_number()));
        params.add(new BasicNameValuePair("phone", applicant.getPhone()));
        params.add(new BasicNameValuePair("thirdType", "03"));
        params.add(new BasicNameValuePair("tradeName", "\u516c\u5171\u8d23\u4efb\u9669"));
        params.add(new BasicNameValuePair("tradeTime", DateUtil.convertDateToString((Date)policy.getSigned_date(), (String)"yyyy-MM-dd HH:mm:ss")));
        params.add(new BasicNameValuePair("tradeType", "08"));
        params.add(new BasicNameValuePair("channel", GlobalResources.HT_CHANNELCODE));
        params.add(new BasicNameValuePair("callbackUrl", GlobalResources.WEB_PRO_URL + "/api/afr/pay/ht/callback/back"));
        params.add(new BasicNameValuePair("callfrontUrl", GlobalResources.WEB_PRO_URL + "/api/afr/pay/ht/callback/front"));
        try {
            String result = HttpUtil.sendPostRequest(GlobalResources.P_SERVICES_URL + "/ht/policy/pay", params);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String confirmPayEnvi(BigDecimal premium) {
        if (GlobalResources.IS_TEST_ENVI.booleanValue()) {
            return "0.01";
        }
        return premium.toString();
    }

    private static String convertAmount(String num) {
        double d = Double.parseDouble(num);
        int a = (int)d;
        return a + "";
    }
}

