/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.product.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.entity.MySysInsCompany;
import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.core.service.MySysInsCompanyService;
import com.bcxin.ins.core.service.SysCompanyService;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.dao.product.InsProductAPIDao;
import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.entity.product_core.ProPrimaryExpire;
import com.bcxin.ins.service.order.ComRegionAPIService;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.InsProductResponsibilityAPIService;
import com.bcxin.ins.service.product.InsProductggAPIService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsProductVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResponsibilityVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsProductAPIServiceImpl
extends ServiceImpl<InsProductAPIDao, ProPrimary>
implements InsProductAPIService {
    @Autowired
    private InsProductAPIDao dao;
    @Autowired
    private InsProductggAPIService insProductggService;
    @Autowired
    private SysCompanyService sysCompanyService;
    @Autowired
    private ComRegionAPIService regionService;
    @Autowired
    private MySysInsCompanyService mySysInsCompanyService;
    @Autowired
    private InsProductResponsibilityAPIService insProductResponsibilityService;
    private static List<ProductVo> DEFAULT_PRO_LIST = Lists.newArrayList();

    @Override
    public List<ProductVo> selectProductVoListByCondition(String keywords) {
        ArrayList<ProductVo> voList = new ArrayList<ProductVo>();
        List<ProPrimary> productList = this.selectInsProductListByCondition(keywords);
        for (ProPrimary product : productList) {
            voList.add(this.willInsProductSetUpProductVo(product));
        }
        return voList;
    }

    @Override
    public ProPrimary findProductByCode(String code) {
        return this.dao.getInsProductgByCode(code);
    }

    @Override
    public List<ProPrimary> selectInsProductListByCondition(String keywords) {
        return this.dao.selectInsProductListByCondition(keywords);
    }

    @Override
    public List<ProductVo> fillProductList(String[] pids) {
        ArrayList<ProductVo> plist = new ArrayList<ProductVo>();
        for (String pid : pids) {
            plist.add(this.willInsProductAndFeeSetUpProductVo(this.dao.getProduct(Long.parseLong(pid))));
        }
        return plist;
    }

    @Override
    public ProductVo willInsProductAndFeeSetUpProductVo(ProPrimary product) {
        ProductVo vo = new ProductVo();
        vo.setOid(String.valueOf(product.getPro_primary_id()));
        vo.setProduct_name(product.getInsurance_name());
        vo.setProduct_code(product.getProduct_code());
        if (product.getSupplier() != null) {
            vo.setInsurance_name(product.getSupplier().getCompany_name());
        }
        SysUser user = SysUserUtils.getUser();
        return vo;
    }

    @Override
    public ProductVo willInsProductSetUpProductVo(ProPrimary product) {
        ProductVo vo = new ProductVo();
        vo.setOid(String.valueOf(product.getPro_primary_id()));
        vo.setProduct_name(product.getInsurance_name());
        vo.setProduct_label(product.getLabel());
        vo.setDo_hot(product.getDo_hot());
        vo.setScope(product.getScope());
        vo.setSource(product.getSource());
        vo.setFrom_of_policy(product.getFrom_of_policy());
        vo.setIntro(product.getIntro());
        vo.setProduct_type(product.getProduct_type());
        vo.setProduct_code(product.getProduct_code());
        vo.setPremium_min(String.valueOf(product.getPremium_min()));
        vo.setP_status(String.valueOf(product.getStatus()));
        vo.setEffective_date(String.valueOf(product.getEffective_date()));
        vo.setEffective_date_after_n(String.valueOf(product.getEffective_date_after_n()));
        vo.setEffective_date_before_n(String.valueOf(product.getEffective_date_before_n()));
        if (product.getSupplier() != null) {
            vo.setInsurance_name(product.getSupplier().getCompany_name());
            vo.setIns_com_intro(product.getSupplier().getIntro());
            vo.setMin_insurance_draw(product.getSupplier().getCompany_logo());
        }
        vo.setResponsibilityVoList(this.insProductResponsibilityService.findResponsibilityVoList(String.valueOf(product.getPro_primary_id())));
        return vo;
    }

    @Override
    public List<ProPrimary> findProductList(ProPrimary insProduct) {
        return this.dao.findProductList(insProduct);
    }

    @Override
    public List<SysCompany> fillCompanyList(String[] cids) {
        ArrayList<SysCompany> slist = new ArrayList<SysCompany>();
        for (String cid : cids) {
            SysCompany sysCompany = this.sysCompanyService.get(Long.valueOf(Long.parseLong(cid)));
            slist.add(sysCompany);
        }
        return slist;
    }

    @Override
    public InsProductVo getProductAttrListByPid(Long pid, String type) {
        return this.dao.getProductAttrListByPid(pid, type);
    }

    @Override
    public ProPrimary getProduct(Long pid) {
        return this.dao.getProduct(pid);
    }

    @Override
    public List<ProductVo> getProductsByConditionAndPage(String pro_type, String condition, DwzPage page) {
        ArrayList<ProductVo> voList = new ArrayList<ProductVo>();
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        System.out.println(condition);
        List<ProPrimary> productList = this.dao.getProductsByConditionAndPage(pro_type, condition, (Page<ProPrimary>)pageHelper);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        for (ProPrimary ip : productList) {
            voList.add(this.willInsProductSetUpProductVo(ip));
        }
        return voList;
    }

    @Override
    public void accordingToProductIDToGetInsProductSetUpOrderFormVo(OrderFormVo vo, Long insProduct_id) {
        ProPrimary insProduct = this.dao.getProduct(insProduct_id);
        if (insProduct != null) {
            MySysInsCompany sysCompany;
            ProPrimaryExpire insProductgg = this.insProductggService.getInsProductggByInsProductID(insProduct.getPro_primary_id());
            if (insProductgg != null) {
                vo.setFees_for(insProductgg.getFees_for());
                vo.setPay_methods(insProductgg.getPay_methods());
            }
            vo.setProduct_name(insProduct.getInsurance_name());
            vo.setProduct_type(insProduct.getProduct_type());
            vo.setProduct_code(insProduct.getProduct_code());
            if (insProduct.getSupplier() != null && (sysCompany = (MySysInsCompany)this.mySysInsCompanyService.selectById((Serializable)insProduct.getSupplier().getSys_ins_company_id())) != null) {
                vo.setInsurance_name(sysCompany.getCompany_name());
            }
        }
    }

    @Override
    public void accordingToProductIDToGetInsProductSetUpAdviceNoteVo(AdviceNoteVo vo, Long insProduct_id) {
        ProPrimary insProduct = this.dao.getProduct(insProduct_id);
        if (insProduct != null) {
            MySysInsCompany sysCompany;
            vo.setProduct_name(insProduct.getInsurance_name());
            vo.setProduct_type(insProduct.getProduct_type());
            if (insProduct.getSupplier() != null && (sysCompany = (MySysInsCompany)this.mySysInsCompanyService.selectById((Serializable)insProduct.getSupplier().getSys_ins_company_id())) != null) {
                vo.setCompany_ename(sysCompany.getCompany_ename());
                vo.setCompany_name(sysCompany.getCompany_name());
                vo.setShort_name(sysCompany.getShort_name());
                String address = "";
                ComRegion pro = this.regionService.findDistrictByCode("", sysCompany.getProvince());
                ComRegion city = this.regionService.findDistrictByCode("", sysCompany.getCity());
                ComRegion dis = this.regionService.findDistrictByCode("", sysCompany.getDistrict());
                if (pro != null && city != null && dis != null) {
                    address = pro.getNamed() + city.getNamed() + dis.getNamed();
                }
                vo.setRegistered_address(address);
                vo.setBank_name(sysCompany.getBank_name());
                vo.setBank_account(sysCompany.getBank_account());
                vo.setBank_account_name(sysCompany.getBank_account_name());
            }
        }
    }

    @Override
    public List<ProductVo> selectProductVoList(ProPrimary insProduct) {
        ArrayList<ProductVo> voList = new ArrayList<ProductVo>();
        List<ProPrimary> productList = this.dao.findProductList(insProduct);
        for (ProPrimary ip : productList) {
            voList.add(this.willInsProductSetUpProductVo(ip));
        }
        return voList;
    }

    @Override
    public List<ProductVo> getProductsByOnLine(String code) {
        List<ProductVo> voList;
        if (StringUtils.isEmpty((CharSequence)code)) {
            if (DEFAULT_PRO_LIST.size() == 0) {
                this.loadDefaultProducts();
            }
            return DEFAULT_PRO_LIST;
        }
        String key = "BLB:CACHE:PRODUCT-PCO-" + code + "-";
        if (JedisUtils.exists((String)key)) {
            voList = JSON.parseArray((String)JedisUtils.get((String)key), ProductVo.class);
        } else {
            voList = this.dao.getProductsByOnLine(code);
            for (ProductVo vo : voList) {
                vo.setResponsibilityVoList(this.insProductResponsibilityService.findResponsibilityVoList(vo.getOid()));
            }
            JedisUtils.set((String)key, (String)JSON.toJSONString(voList), (int)ConstProp.ONE_MONTH_TIMEOUT_SECONDS);
        }
        return voList;
    }

    @Override
    public void loadDefaultProducts() {
        List<ProductVo> voList = this.dao.getProductsByOnLine("DEFAULT");
        for (ProductVo vo : voList) {
            vo.setResponsibilityVoList(this.insProductResponsibilityService.findResponsibilityVoList(vo.getOid()));
        }
        DEFAULT_PRO_LIST = voList;
    }

    @Override
    public ProductVo accordingToInsProductIDToGetInsProductInProductVo(Long insProductID) {
        ProductVo ip;
        String key = "BLB:CACHE:PRODUCT-ID-" + String.valueOf(insProductID);
        if (JedisUtils.exists((String)key)) {
            ip = (ProductVo)JSON.parseObject((String)JedisUtils.get((String)key), ProductVo.class);
        } else {
            ip = this.dao.accordingToInsProductIDToGetInsProductInProductVo(insProductID);
            if (ip != null) {
                ip.setResponsibilityVoList(this.insProductResponsibilityService.findResponsibilityVoList(ip.getOid()));
                JedisUtils.set((String)key, (String)JSON.toJSONString((Object)ip), (int)ConstProp.ONE_MONTH_TIMEOUT_SECONDS);
            }
        }
        return ip;
    }

    @Override
    public String listProductAndResponsibility() {
        List<ProductVo> pList = this.dao.listProductAndResponsibility("TYX");
        JSONArray ja1 = new JSONArray();
        List<ResponsibilityVo> rList = null;
        for (ProductVo p : pList) {
            JSONObject jo1 = new JSONObject();
            rList = this.insProductResponsibilityService.findResponsibilityVoList(p.getOid());
            JSONArray ja2 = new JSONArray();
            for (ResponsibilityVo r : rList) {
                JSONObject jo2 = new JSONObject();
                jo2.put("name", (Object)r.getName());
                jo2.put("guaProjectCode", (Object)r.getResponsibility_code());
                jo2.put("fcy", (Object)r.getFcy());
                ja2.add((Object)jo2);
                jo2 = null;
            }
            jo1.put("insName", (Object)p.getProduct_name());
            jo1.put("comName", (Object)p.getInsurance_name());
            jo1.put("proIntro", (Object)p.getIntro());
            jo1.put("proImgPath", (Object)p.getDetail_product_draw());
            jo1.put("insFee", (Object)String.valueOf(new BigDecimal(p.getPremium_min())));
            jo1.put("proCode", (Object)p.getProduct_code());
            jo1.put("resList", (Object)ja2);
            ja1.add((Object)jo1);
            jo1 = null;
            rList = null;
            ja2 = null;
        }
        String result = JSON.toJSONString((Object)ja1);
        System.out.println("\u4ea7\u54c1\u4fe1\u606f\uff1a----------------------");
        System.out.println(result);
        System.out.println("\u4ea7\u54c1\u4fe1\u606f\uff1a----------------------");
        return result;
    }
}

