/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.preservation.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.util.DOM;
import com.bcxin.ins.dao.preservation.InsPreservationResultSetAPIDao;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.policy_core.InsPreservationDetail;
import com.bcxin.ins.entity.policy_core.InsPreservationRecord;
import com.bcxin.ins.entity.policy_core.InsPreservationResultSet;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.service.order.ComTaskResidualAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsRoleInpolicyAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationDetailAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.IdCardVerify;
import com.bcxin.ins.util.IdNumberValidator;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.ValidatorUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.HirelingVo;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationResultSetVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.ins.vo.excel.InsPerExcelVo;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.poi.excel.ExcelReader;
import com.xiaoleilu.hutool.poi.excel.ExcelUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class InsPreservationResultSetAPIServiceImpl
extends ServiceImpl<InsPreservationResultSetAPIDao, InsPreservationResultSet>
implements InsPreservationResultSetAPIService {
    private Logger log = LoggerFactory.getLogger(InsPreservationResultSetAPIServiceImpl.class);
    @Autowired
    private InsPreservationResultSetAPIDao dao;
    @Autowired
    private InsPreservationDetailAPIService insPreservationDetailAPIService;
    @Autowired
    private InsPreservationRecordAPIService insPreservationRecordAPIService;
    @Autowired
    private InsRoleInpolicyAPIService insRoleInpolicyAPIService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ComTaskResidualAPIService comTaskResidualAPIService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipAPIService;

    @Override
    public List<InsPreservationResultSet> findInsPreservationResultSetByKeyword(DwzPage page, Long preservationId, String keyword, String status, String start_time, String end_time) {
        List<InsPreservationResultSet> list = null;
        if (page != null) {
            Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
            list = this.dao.findResultSetByKeyword((Page<InsPreservationResultSet>)pageHelper, preservationId, keyword, status, start_time, end_time);
            page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        } else {
            list = this.dao.findResultSetByKeyword(preservationId, keyword, status, start_time, end_time);
        }
        return list;
    }

    @Override
    public List<InsPreservationResultSet> initFindInsPreservationResultSetByKeyword(DwzPage page, Long policyId, String keyword, String status, String start_time, String end_time) {
        List<InsPreservationResultSet> list = null;
        if (page != null) {
            Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
            list = this.dao.findResultSetByKeyword((Page<InsPreservationResultSet>)pageHelper, policyId, keyword, status, start_time, end_time);
            page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        } else {
            list = this.dao.findResultSetByKeyword(policyId, keyword, status, start_time, end_time);
        }
        return list;
    }

    @Override
    public List<InsPreservationResultSet> findZBByPolicyId(Long policyId, String productCode) {
        if (StringUtils.isNotEmpty((String)productCode)) {
            productCode = productCode.split("-")[0];
        }
        return this.dao.findZBByPolicyId(policyId, productCode);
    }

    @Override
    public List<InsPreservationDetailVo> findInsPreservationDetailVoByIdCards(Long policyId, String idCards) {
        String[] arr = idCards.split(",");
        return this.dao.findInsPreservationDetailVoByIdCards(policyId, arr);
    }

    @Override
    public List<InsPreservationDetailVo> findInsPreservationDetailVoByImportBatchId(Long policyId, String importBatchId) {
        return this.dao.findInsPreservationDetailVoByImportBatchId(policyId, importBatchId);
    }

    @Override
    public Integer findZBNumber(int dqNum, Long policyId) {
        return this.dao.findZBNumber(dqNum, policyId);
    }

    private void roleInPolicyToResultSet(InsRoleInpolicy role, InsPreservationResultSetVo iprsVo) {
        iprsVo.setName(role.getName_cn());
        iprsVo.setId_card(role.getOrganization_code());
        iprsVo.setId_type(role.getId_type());
        iprsVo.setBelong_to_id(String.valueOf(role.getIns_role_inpolicy_id()));
        iprsVo.setBelong_to_type("ROLE");
        iprsVo.setBirthday(role.getBirth_date());
        iprsVo.setSex(role.getSex());
        iprsVo.setTel(role.getMobile());
        iprsVo.setCareer(role.getMajor_group());
    }

    private void preservationDetailToResultSet(InsPreservationDetail ipd, InsPreservationResultSetVo iprsVo) {
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)ipd), (Object)iprsVo);
            iprsVo.setBelong_to_type("PRESERVE");
            iprsVo.setBelong_to_id(String.valueOf(ipd.getIns_preservation_detail_id()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public InsPreservationResultSetVo getInsPreservationResultSetVoByOidAndSign(String oid, String sign) {
        InsPreservationResultSetVo iprsVo = new InsPreservationResultSetVo();
        if ("ROLE".equals(sign)) {
            iprsVo = this.insRoleInpolicyAPIService.setResultSetVo(Long.parseLong(oid));
        } else if ("PRESERVE".equals(sign) || "THIS".equals(sign) || StringUtils.isEmpty((String)sign)) {
            iprsVo = this.dao.setResultSetVo(Long.parseLong(oid));
        }
        return iprsVo;
    }

    @Override
    public List<InsPreservationResultSetVo> getInsPreservationResultSetVoByIdCardsAndOrderId(Long policyId, List<String> idCardList) {
        return this.dao.setResultSetVoList(policyId, idCardList);
    }

    @Override
    public boolean getEffectivePersonnelBySet(Long policyId, String id_card) {
        return policyId != null && !StringUtils.isEmpty((String)id_card) && this.dao.getResultSetIdByRecord(policyId, id_card) != null;
    }

    @Override
    public JSONObject readIPRSExcel(MultipartFile mFile) throws Exception {
        JSONObject jo = new JSONObject();
        ArrayList list = null;
        String msg = "";
        boolean cum = false;
        String cds = "";
        int career1 = 0;
        int career2 = 0;
        int career3 = 0;
        int career4 = 0;
        String[] arrStr = new String[]{"name", "id_type", "id_card", "birthday", "sex", "tel", "career"};
        list = Lists.newArrayList();
        try {
            InputStream is = mFile.getInputStream();
            HSSFWorkbook hssfWorkbook = new HSSFWorkbook(is);
            block18: for (int numSheet = 0; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
                HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                InsPreservationResultSetVo iprsVo = null;
                for (int rowNum = 6; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    int hh = rowNum + 1;
                    if (hssfRow == null) continue;
                    if (StringUtils.isEmpty((String)String.valueOf(hssfRow.getCell(1)).trim()) && StringUtils.isEmpty((String)String.valueOf(hssfRow.getCell(2)).trim()) && StringUtils.isEmpty((String)String.valueOf(hssfRow.getCell(3)).trim()) && StringUtils.isEmpty((String)String.valueOf(hssfRow.getCell(6)).trim()) && StringUtils.isEmpty((String)String.valueOf(hssfRow.getCell(7)).trim()) && StringUtils.isEmpty((String)String.valueOf(hssfRow.getCell(8)).trim())) continue block18;
                    HSSFCell cell = null;
                    iprsVo = new InsPreservationResultSetVo();
                    HashMap map = Maps.newHashMap();
                    String cd = "";
                    for (int i = 1; i < 8; ++i) {
                        String _value;
                        block39: {
                            block44: {
                                block45: {
                                    block40: {
                                        block43: {
                                            block42: {
                                                block41: {
                                                    block38: {
                                                        cell = hssfRow.getCell(i);
                                                        _value = InsPreservationResultSetAPIServiceImpl.getValue(cell).trim();
                                                        if (StringUtils.isEmpty((String)_value)) {
                                                            String n = i == 1 ? "\u59d3\u540d" : (i == 2 ? "\u8bc1\u4ef6\u7c7b\u578b" : (i == 3 ? "\u8bc1\u4ef6\u53f7" : (i == 4 ? "\u51fa\u751f\u65e5\u671f" : (i == 5 ? "\u6027\u522b" : (i == 6 ? "\u624b\u673a" : "\u804c\u4e1a")))));
                                                            msg = msg + "\u7b2c " + hh + " \u884c\uff1a" + n + "\u4e0d\u80fd\u4e3a\u7a7a;";
                                                            cum = true;
                                                            continue;
                                                        }
                                                        if (!"name".equals(arrStr[i - 1])) break block38;
                                                        if (StringUtils.isNotEmpty((String)_value)) {
                                                            _value = _value.replace(" ", "");
                                                        }
                                                        break block39;
                                                    }
                                                    if (!"id_type".equals(arrStr[i - 1])) break block40;
                                                    if (!"\u5c45\u6c11\u8eab\u4efd\u8bc1".equals(_value)) break block41;
                                                    _value = "0";
                                                    break block39;
                                                }
                                                if (!"\u62a4\u7167".equals(_value)) break block42;
                                                _value = "3";
                                                break block39;
                                            }
                                            if (!"\u53f0\u80de\u8bc1".equals(_value)) break block43;
                                            _value = "4";
                                            break block39;
                                        }
                                        if (!"\u56de\u4e61\u8bc1".equals(_value)) break block39;
                                        _value = "5";
                                        break block39;
                                    }
                                    if (!"sex".equals(arrStr[i - 1])) break block44;
                                    if (!"\u7537".equals(_value)) break block45;
                                    _value = "1";
                                    break block39;
                                }
                                if (!"\u5973".equals(_value)) break block39;
                                _value = "2";
                                break block39;
                            }
                            if ("birthday".equals(arrStr[i - 1])) {
                                block37: {
                                    try {
                                        if (_value.contains("-")) {
                                            DateUtil.parseDate((String)_value);
                                            break block37;
                                        }
                                        if (!HSSFDateUtil.isCellDateFormatted((Cell)cell)) break block37;
                                        Date d = cell.getDateCellValue();
                                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
                                        _value = formater.format(d);
                                    }
                                    catch (Exception e) {
                                        msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u51fa\u751f\u65e5\u671f\u6709\u8bef;";
                                        cum = true;
                                        break;
                                    }
                                }
                                if (IdNumberValidator.getAgeFromBirthday((String)_value) > 65 || IdNumberValidator.getAgeFromBirthday((String)_value) < 16) {
                                    msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u4eba\u5458\u7684\u5e74\u9f84\u8d85\u51fa\u9650\u5236\uff08\u533a\u95f4\uff1a16-65\u5468\u5c81\uff09;";
                                    cum = true;
                                    break;
                                }
                            } else if ("id_card".equals(arrStr[i - 1])) {
                                if (!IdCardVerify.isValidatedAllIdcard((String)(_value = _value.toUpperCase()))) {
                                    msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u8bc1\u4ef6\u53f7\u7801\u4e0d\u662f\u6709\u6548\u8bc1\u4ef6\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d;";
                                    cum = true;
                                    break;
                                }
                                cd = _value;
                            } else if ("career".equals(arrStr[i - 1])) {
                                if (!"1234".contains(_value = _value.replace(".0", ""))) {
                                    msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u804c\u4e1a\u7f16\u7801\u65e0\u6548;";
                                    cum = true;
                                    break;
                                }
                                switch (_value) {
                                    case "1": {
                                        ++career1;
                                        break;
                                    }
                                    case "2": {
                                        ++career2;
                                        break;
                                    }
                                    case "3": {
                                        ++career3;
                                        break;
                                    }
                                    case "4": {
                                        ++career4;
                                        break;
                                    }
                                }
                            } else if ("tel".equals(arrStr[i - 1])) {
                                if (_value.contains("E")) {
                                    try {
                                        DecimalFormat df = new DecimalFormat("#");
                                        _value = df.format(cell.getNumericCellValue());
                                    }
                                    catch (Exception e) {
                                        msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u624b\u673a\u53f7\u7801\u683c\u5f0f\u6709\u8bef;";
                                        cum = true;
                                        break;
                                    }
                                }
                                if (!ValidatorUtil.validatePhone((String)_value)) {
                                    msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u624b\u673a\u53f7\u7801\u683c\u5f0f\u6709\u8bef;";
                                    cum = true;
                                    break;
                                }
                            }
                        }
                        map.put(arrStr[i - 1], _value);
                    }
                    if (StringUtils.isNotEmpty((String)cd) && cds.contains(cd)) {
                        msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u8be5\u8bc1\u4ef6\u53f7\u5df2\u5728\u672c\u6e05\u5355\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u5f55\u5165;";
                        cum = true;
                    }
                    cds = cds + cd + ";";
                    if (iprsVo == null || map.size() <= 0) continue;
                    MyConverUtil.map2PO((Map)map, (Object)iprsVo);
                    list.add(iprsVo);
                    iprsVo = null;
                }
            }
        }
        catch (Exception e) {
            cum = true;
            msg = "Excel\u6e05\u5355\u6a21\u677f\u6587\u4ef6\u6570\u636e\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u4f7f\u7528\u6807\u51c6\u7684Excel\u6e05\u5355\u6a21\u677f\u4e0a\u4f20\uff01\n\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u6a21\u677f\u6587\u4ef6\u5934\u90e8\u5185\u5bb9\u88ab\u5220\u9664\u6216\u6574\u4f53\u6837\u5f0f\u88ab\u6539\u53d8\uff1b\n2.\u76f4\u63a5\u5b83\u5904\u590d\u5236\u7684\u4eba\u5458\u4fe1\u606f\u9644\u5e26\u683c\u5f0f\u3002";
        }
        jo.put("ret", (Object)(cum ? "300" : "200"));
        jo.put("msg", (Object)msg);
        jo.put("list", (Object)list);
        jo.put("career1", (Object)career1);
        jo.put("career2", (Object)career2);
        jo.put("career3", (Object)career3);
        jo.put("career4", (Object)career4);
        return jo;
    }

    private static String getValue(HSSFCell hssfRow) {
        if (hssfRow.getCellType() == 4) {
            return String.valueOf(hssfRow.getBooleanCellValue());
        }
        if (hssfRow.getCellType() == 0) {
            return String.valueOf(hssfRow.getNumericCellValue());
        }
        return String.valueOf(hssfRow.getStringCellValue());
    }

    @Override
    public void initAllOrderToResultSet(String product_code) {
        List<String> list = this.insInsuranceSlipAPIService.selectOrderIdByProductCode(product_code);
        if (list != null) {
            for (String oid : list) {
                this.initResultSetByOrderId(Long.parseLong(oid));
            }
        }
    }

    @Override
    public void initResultSetByOrderId(Long oid) {
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(oid);
        if (StringUtils.isEmpty((String)dto.getProduct_code())) {
            return;
        }
        ArrayList<InsPreservationResultSet> iprsList = new ArrayList<InsPreservationResultSet>();
        InsPreservationResultSet iprs = null;
        if (dto.getProduct_code().contains("TYX")) {
            GMRPolicyVo vo = this.policyService.accordingToOrderIDToGetGMRPolicyVo(oid);
            for (RoleSubjectVo rvo : vo.getRoleSubjectList()) {
                if ("1".equals(rvo.getKind())) continue;
                iprs = new InsPreservationResultSet();
                this.setResultSetByRole(iprs, rvo, oid);
                iprs.setIns_preservation_result_set_id(Long.valueOf(IdWorker.getId()));
                iprsList.add(iprs);
                iprs = null;
            }
        } else if (dto.getProduct_code().contains("GZZRX")) {
            SpecialHirelingVo vo = this.policyService.accordingToOrderIDToGetSpecialHirelingVo(oid);
            for (HirelingVo hvo : vo.getHirelingVoList()) {
                iprs = new InsPreservationResultSet();
                this.setResultSetByHireling(iprs, hvo, oid);
                iprs.setIns_preservation_result_set_id(Long.valueOf(IdWorker.getId()));
                iprsList.add(iprs);
                iprs = null;
            }
        }
        if (iprsList.size() > 0) {
            this.dao.batchInsert(iprsList);
        }
    }

    private void setResultSetByRole(InsPreservationResultSet iprs, RoleSubjectVo rvo, Long oid) {
        iprs.setName(rvo.getName_cn());
        iprs.setId_card(rvo.getOrganization_code());
        iprs.setId_type(rvo.getId_type());
        iprs.setBirthday(rvo.getBirth_date());
        iprs.setSex(rvo.getSex());
        iprs.setTel(rvo.getMobile());
        iprs.setCareer(rvo.getMajor_group());
        iprs.setIns_insurance_slip_id(oid);
        iprs.setStatus(0);
        iprs.setBelong_to_type("ROLE");
        iprs.setRevise_time(new Date());
    }

    private void setResultSetByHireling(InsPreservationResultSet iprs, HirelingVo hvo, Long oid) {
        iprs.setName(hvo.getName());
        iprs.setId_card(hvo.getId_card());
        iprs.setId_type(hvo.getId_type());
        iprs.setBirthday(hvo.getBirth_date());
        iprs.setSex(hvo.getSex());
        iprs.setTel(hvo.getMobile());
        iprs.setCareer(hvo.getCareer());
        iprs.setIns_insurance_slip_id(oid);
        iprs.setStatus(0);
        iprs.setBelong_to_type("HIRE");
        iprs.setRevise_time(new Date());
    }

    @Override
    public boolean pushResultSetByRecord(Long record_id, String revise_type) {
        try {
            Long[] longs;
            Long[] _l;
            int count;
            InsPreservationResultSet iprs;
            int status = 0;
            Date date = new Date();
            HashMap params = Maps.newHashMap();
            params.put("id", record_id);
            List<Map<Object, Object>> l = this.insPreservationDetailAPIService.queryDetail(params);
            InsPreservationRecord record = (InsPreservationRecord)this.insPreservationRecordAPIService.selectById(record_id);
            ArrayList l2 = Lists.newArrayList();
            ArrayList b1 = Lists.newArrayList();
            if ("1".equals(revise_type)) {
                for (Map<Object, Object> m : l) {
                    iprs = (InsPreservationResultSet)DOM.mtd(m, (Object)new InsPreservationResultSet());
                    iprs.setRevise_time(date);
                    iprs.setIns_preservation_result_set_id(Long.valueOf(IdWorker.getId()));
                    iprs.setStatus(status);
                    iprs.setIns_insurance_slip_id(record.getIns_insurance_slip_id());
                    iprs.setBelong_to_type("PRESERVE");
                    l2.add(iprs);
                }
            } else if ("2".equals(revise_type)) {
                for (Map<Object, Object> m : l) {
                    Long belong_to_id = (Long)m.get("belong_to_id");
                    if (belong_to_id == null) {
                        belong_to_id = this.dao.getResultSetIdByRecord(record.getIns_insurance_slip_id(), String.valueOf(m.get("id_card")));
                    }
                    if (belong_to_id == null) {
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                        return false;
                    }
                    b1.add(belong_to_id);
                }
            } else if ("3".equals(revise_type)) {
                for (Map<Object, Object> m : l) {
                    iprs = (InsPreservationResultSet)DOM.mtd(m, (Object)new InsPreservationResultSet());
                    iprs.setRevise_time(date);
                    iprs.setIns_preservation_result_set_id(Long.valueOf(IdWorker.getId()));
                    iprs.setStatus(status);
                    iprs.setIns_insurance_slip_id(record.getIns_insurance_slip_id());
                    iprs.setBelong_to_type("PRESERVE");
                    iprs.setBelong_to_id(null);
                    l2.add(iprs);
                    b1.add((Long)m.get("belong_to_id"));
                }
            }
            if (l2.size() > 0) {
                this.dao.batchInsert(l2);
            }
            if (b1.size() > 0 && (count = this.dao.batchUpdateStatus(_l = b1.toArray(longs = new Long[b1.size()]), 1, revise_type, DateUtil.getCurrentDate_1())) == 0) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return false;
            }
            record.setRelease_time(date);
            this.insPreservationRecordAPIService.updateById(record);
            return true;
        }
        catch (NullPointerException nup) {
            this.log.error("\u66f4\u65b0\u7ed3\u679c\u96c6\u4e1a\u52a1\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)nup);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        catch (Exception e) {
            this.log.error("\u66f4\u65b0\u7ed3\u679c\u96c6\u4e1a\u52a1\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
    }

    @Override
    public void updateResultSet(Long record_id, String revise_type) {
        if (!this.pushResultSetByRecord(record_id, revise_type)) {
            this.comTaskResidualAPIService.saveComTaskResidual("pushResultSetByRecord", "\u66f4\u65b0\u7ed3\u679c\u96c6\u4e1a\u52a1", "com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService", 2, "Long,String", record_id + "," + revise_type);
        }
    }

    @Override
    public InsPreservationResultSet getResultSetBypolicyIdAndCardNo(String id_card, Long order_id) {
        if (StringUtils.isEmpty((String)id_card) || order_id == null) {
            return null;
        }
        return this.dao.getResultSetBypolicyIdAndCardNo(order_id, id_card);
    }

    @Override
    public Long getIdByIdCardAndOrderId(String id_card, Long order_id) {
        if (StringUtils.isEmpty((String)id_card) || order_id == null) {
            return null;
        }
        return this.dao.getResultSetIdByRecord(order_id, id_card);
    }

    @Override
    public String getBusinessInceptionDateByBusinessId(String businessId) {
        if (StringUtils.isEmpty((String)businessId)) {
            return "";
        }
        return this.dao.getBusinessInceptionDateByBusinessId(businessId);
    }

    @Override
    public String findDuplicateIdCardNo(String appName, String code, String[] list) {
        return this.dao.findDuplicateIdCardNo(GlobalResources.POLICY_END_DAY, appName, code, list);
    }

    @Override
    public String findNotUnderWarrantyIdCardNo(String orderId, String[] list) {
        return this.dao.findNotUnderWarrantyIdCardNo(orderId, list);
    }

    @Override
    public List<Map> sassFindPerNameByIdCard(String[] list) {
        return this.dao.sassFindPerNameByIdCard(list);
    }

    @Override
    public Map<String, Integer> countCareer(String[] list) {
        return this.dao.countCareer(list);
    }

    @Override
    public Map<String, String> getCostByOrderId(int lastDay, int recordCount, Long oid) {
        return this.dao.getCostByOrderId(lastDay, recordCount, oid);
    }

    @Override
    public void downResultSet(Long oid, HttpServletResponse response) {
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(oid);
        com.bcxin.ins.util.excel.ExcelUtil util = new com.bcxin.ins.util.excel.ExcelUtil(ResultSetExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((orderVo.getExternal_reference() + "-\u5728\u4fdd\u4eba\u5458.xls").getBytes("gb2312"), "ISO8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try (ServletOutputStream os = response.getOutputStream();){
            List<ResultSetExcelVo> voList = this.dao.queryResultSetVo(oid);
            util.exportExcel(voList, orderVo.getExternal_reference() + "\u5728\u4fdd\u4eba\u5458", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Result minusBatchUploadInsPer(Long importBatchId, MultipartFile file) throws Exception {
        List<Map<String, Object>> excellist;
        try (InputStream in = file.getInputStream();){
            ExcelReader reader = ExcelUtil.getReader((InputStream)in);
            reader.isIgnoreEmptyRow();
            excellist = reader.read(2, 6, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            return Result.fail((String)"Excel\u6a21\u677f\u6587\u4ef6\u5f02\u5e38\uff01");
        }
        excellist = this.screenValidData(excellist);
        if (excellist.size() == 0) {
            return Result.fail((String)"Excel\u6587\u4ef6\u65e0\u6709\u6548\u6570\u636e");
        }
        this.dao.deleteTempBatchInsPerImport(importBatchId);
        this.dao.saveTempBatchInsPerImport(excellist, importBatchId);
        this.dao.checkIdCardNoRepeat(importBatchId);
        this.dao.checkIsZb(importBatchId);
        Integer errCount = this.dao.countErrOrSuccessTempBatchInsPerImport("0", importBatchId);
        Integer successCount = this.dao.countErrOrSuccessTempBatchInsPerImport("1", importBatchId);
        List<Map<String, String>> mapList = this.dao.findValidMinusInsByImportBatchId(importBatchId);
        HashMap param = Maps.newHashMap();
        param.put("importBatchId", String.valueOf(importBatchId));
        param.put("errCount", String.valueOf(errCount));
        param.put("successCount", String.valueOf(successCount));
        param.put("minusInsList", mapList);
        JedisUtils.setObject((String)("BLB:CACHE:POLICYS-" + importBatchId), mapList, (int)ConstProp.ONE_HOURS_TIMEOUT_SECONDS);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)param);
    }

    private List<Map<String, Object>> screenValidData(List<Map<String, Object>> excellist) {
        this.log.info("\u83b7\u53d6\u5230\u7684\u6587\u4ef6\u4fe1\u606f" + JSON.toJSON(excellist));
        String[] keys = new String[]{"name", "idCardNo", "birthday", "idCardType", "perType", "sex", "mobilePhone", "number", "isSuccess", "errorMsg"};
        HashMap newMap = null;
        ArrayList mlist = Lists.newArrayList();
        for (Map<String, Object> map : excellist) {
            if (StringUtils.isEmpty((String)String.valueOf(map.get("\u59d3\u540d"))) && StringUtils.isEmpty((String)String.valueOf(map.get("\u804c\u4e1a"))) && StringUtils.isEmpty((String)String.valueOf(map.get("\u8bc1\u4ef6\u53f7\u7801"))) && StringUtils.isEmpty((String)String.valueOf(map.get("\u624b\u673a\u53f7"))) && StringUtils.isEmpty((String)String.valueOf(map.get("\u51fa\u751f\u65e5\u671f"))) && StringUtils.isEmpty((String)String.valueOf(map.get("\u8bc1\u4ef6\u7c7b\u578b"))) && StringUtils.isEmpty((String)String.valueOf(map.get("\u6027\u522b")))) continue;
            newMap = Maps.newHashMap();
            boolean isNull = false;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String val = String.valueOf(entry.getValue());
                switch (entry.getKey()) {
                    case "\u59d3\u540d": {
                        newMap.put(keys[0], val);
                        break;
                    }
                    case "\u8bc1\u4ef6\u53f7\u7801": {
                        newMap.put(keys[1], val);
                        break;
                    }
                    case "\u51fa\u751f\u65e5\u671f": {
                        if (StringUtils.isNotEmpty((String)val)) {
                            val = val.replace(" 00:00:00", "");
                        }
                        newMap.put(keys[2], val);
                        break;
                    }
                    case "\u8bc1\u4ef6\u7c7b\u578b": {
                        if (StringUtils.isNotEmpty((String)val)) {
                            val = "\u5c45\u6c11\u8eab\u4efd\u8bc1".equals(val) ? "0" : ("\u62a4\u7167".equals(val) ? "3" : ("\u53f0\u80de\u8bc1".equals(val) ? "4" : ("\u56de\u4e61\u8bc1".equals(val) ? "5" : "")));
                        }
                        newMap.put(keys[3], val);
                        break;
                    }
                    case "\u804c\u4e1a": {
                        newMap.put(keys[4], val);
                        break;
                    }
                    case "\u6027\u522b": {
                        if (StringUtils.isNotEmpty((String)val)) {
                            val = "\u7537".equals(val) ? "1" : ("\u5973".equals(val) ? "2" : "");
                        }
                        newMap.put(keys[5], val);
                        break;
                    }
                    case "\u624b\u673a\u53f7": {
                        newMap.put(keys[6], val);
                        break;
                    }
                    case "\u5e8f\u53f7": {
                        newMap.put(keys[7], val);
                        break;
                    }
                }
                if (!StringUtils.isEmpty((String)val) || !StringUtils.isNotEmpty((String)entry.getKey())) continue;
                isNull = true;
            }
            if (isNull) {
                newMap.put(keys[8], "0");
                newMap.put(keys[9], "\u5b58\u5728\u7a7a\u503c\u6216\u6570\u636e\u4e0d\u5408\u6cd5");
            } else {
                String errMsg = "";
                if ("0".equals(String.valueOf(newMap.get(keys[1]))) && !IdCardVerify.isValidatedAllIdcard((String)String.valueOf(newMap.get(keys[1])))) {
                    errMsg = "\u8eab\u4efd\u8bc1\u53f7\u7801\u9519\u8bef\uff1b";
                }
                try {
                    int age = DateUtil.getAge((String)String.valueOf(newMap.get(keys[2])));
                    if (age < 16 || age > 65) {
                        errMsg = errMsg + "\u5e74\u9f84\u4e0d\u7b26\u5408\u6295\u4fdd\u6761\u4ef6\uff1b";
                    }
                }
                catch (Exception e) {
                    errMsg = errMsg + "\u51fa\u751f\u65e5\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff1b";
                }
                String car = String.valueOf(newMap.get(keys[4]));
                if (car.length() > 1 || !"1234".contains(car)) {
                    errMsg = errMsg + "\u804c\u4e1a\u7f16\u7801\u9519\u8bef\uff1b";
                }
                if (!InsPreservationResultSetAPIServiceImpl.validateMobile(String.valueOf(newMap.get(keys[6])))) {
                    errMsg = errMsg + "\u624b\u673a\u53f7\u7801\u9519\u8bef\uff1b";
                }
                if (StringUtils.isNotEmpty((String)errMsg)) {
                    newMap.put(keys[8], "0");
                    newMap.put(keys[9], errMsg);
                } else {
                    newMap.put(keys[8], "1");
                    newMap.put(keys[9], "");
                }
            }
            mlist.add(newMap);
        }
        return mlist;
    }

    public static boolean validateMobile(String mobile) {
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1][3,4,5,6,7,8,9][0-9]{9}$");
        m = p.matcher(mobile);
        b = m.matches();
        return b;
    }

    @Override
    public Result downErrInsPer(String importBatchId, HttpServletResponse response) {
        try {
            ServletOutputStream os = null;
            com.bcxin.ins.util.excel.ExcelUtil util = new com.bcxin.ins.util.excel.ExcelUtil(InsPerExcelVo.class);
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u9519\u8bef\u4eba\u5458\u4fe1\u606f.xls".getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            List<InsPerExcelVo> list = this.dao.findErrTempBatchInsPerImport(Long.parseLong(importBatchId));
            util.exportExcel(list, "\u9519\u8bef\u4eba\u5458\u4fe1\u606f", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            return Result.fail((String)"\u5bfc\u51faExcel\u9519\u8bef\u4eba\u5458\u5931\u8d25\uff01");
        }
        return Result.success((String)"\u5bfc\u51faExcel\u9519\u8bef\u4eba\u5458\u6210\u529f\uff01");
    }
}

