/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.util.HttpUtil;
import com.bcxin.ins.dto.oauth.AccessToken;
import com.bcxin.ins.entity.user.SysClientCompany;
import com.bcxin.ins.entity.user.SysClientUser;
import com.bcxin.ins.spring.listener.SessionContext;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.BASE64Util;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.IpAddress;
import com.bcxin.ins.vo.ClientUserVo;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class UserSupportUtil {
    private static Logger log = LoggerFactory.getLogger(UserSupportUtil.class);
    private static final String USER_SYNCHRONIZATION = "api/webUser/receiveData";
    private static final String COMPANY_SYNCHRONIZATION = "api/webCompany/receiveTerminalData";
    private static final Logger logger = LoggerFactory.getLogger(UserSupportUtil.class);

    public static ClientUserVo getSessionUser() {
        String referer_url;
        HttpServletRequest request = null;
        if (RequestContextHolder.getRequestAttributes() == null) {
            return null;
        }
        request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String access_token = request.getParameter("ACCESS_TOKEN");
        if (StringUtils.isEmpty((String)access_token) && StringUtils.isNotEmpty((String)(referer_url = request.getHeader("Referer"))) && referer_url.contains("ACCESS_TOKEN=") && !referer_url.endsWith("ACCESS_TOKEN=")) {
            String x_at = referer_url.split("ACCESS_TOKEN=")[1];
            if (x_at.length() == 32) {
                access_token = x_at;
            } else if (x_at.length() > 32) {
                access_token = x_at.substring(0, 32);
            }
        }
        AccessToken accessToken = (AccessToken)JedisUtils.getObject((String)("BLB:CACHE:BLB-REQ-TOKEN-" + access_token));
        ClientUserVo user = null;
        if (accessToken != null) {
            user = accessToken.getUserVo();
            if (null != user) {
                return user;
            }
        } else if (StringUtils.isNotEmpty((String)access_token)) {
            return null;
        }
        HttpSession session = request.getSession();
        try {
            user = (ClientUserVo)session.getAttribute("userdetail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != user) {
            return user;
        }
        String sessionId = JedisUtils.get((String)("BLB:CACHE:THR-REQ-TOKEN-" + request.getParameter("ACCESS_TOKEN")));
        if (StringUtils.isEmpty((String)sessionId)) {
            return null;
        }
        session = SessionContext.getInstance().getSession(sessionId);
        if (session == null) {
            return null;
        }
        user = (ClientUserVo)session.getAttribute("userdetail");
        if (null != user) {
            return user;
        }
        return null;
    }

    public static void setSessionUser(ClientUserVo vo) {
        HttpServletRequest request = null;
        if (RequestContextHolder.getRequestAttributes() != null) {
            request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HttpSession session = request.getSession();
            session.setAttribute("userdetail", (Object)vo);
        }
    }

    public static void setSessionWeiXinUser(ClientUserVo vo) {
        HttpServletRequest request = null;
        if (RequestContextHolder.getRequestAttributes() != null) {
            request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HttpSession session = request.getSession();
            session.setAttribute("weixinVo", (Object)vo);
        }
    }

    public static Map<String, Object> getUserSynchronization(SysClientUser user, String sys_client_company_id) {
        String url = (String)GlobalResources.map.get("YWZC_URL") + USER_SYNCHRONIZATION;
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put("webType", "BLB");
        if (StringUtils.isNotEmpty((String)user.getWeb_type()) && !"BLB".equals(user.getWeb_type())) {
            mapParams.put("webTHirdType", user.getWeb_type());
            mapParams.put("webUserName", user.getWeb_type() + user.getWeb_user_name());
        }
        if (user.getLogin_name() != null) {
            mapParams.put("loginName", "BLB" + user.getLogin_name());
        }
        if (user.getUser_name() != null) {
            mapParams.put("userName", "BLB" + user.getUser_name());
        }
        if (user.getReal_name() != null) {
            mapParams.put("realName", user.getReal_name());
        }
        if (user.getSex() != null) {
            mapParams.put("sex", user.getSex());
        }
        if (user.getAge() != null) {
            mapParams.put("age", user.getAge());
        }
        if (user.getEmail() != null) {
            mapParams.put("email", user.getEmail());
        }
        if (user.getTelephone() != null) {
            mapParams.put("telephone", user.getTelephone());
        }
        if (user.getSys_client_user_id() != null) {
            mapParams.put("webUserId", user.getSys_client_user_id());
        }
        if (user.getBusiness_support_id() != null) {
            mapParams.put("id", user.getBusiness_support_id());
        }
        if (StringUtils.isNotEmpty((String)sys_client_company_id) && !"1".equals(sys_client_company_id) && !"0".equals(sys_client_company_id)) {
            mapParams.put("sysCompany.id", sys_client_company_id);
        }
        if (StringUtils.isNotEmpty((String)user.getId_card())) {
            mapParams.put("idNumber", user.getId_card());
        }
        if (StringUtils.isNotEmpty((String)user.getId_type())) {
            mapParams.put("idType", user.getId_type());
        }
        try {
            logger.debug("\u540c\u6b65\u5185\u5bb9\u53c2\u6570" + mapParams);
            String s = HttpUtil.doPost2((String)url, mapParams);
            logger.debug("\u540c\u6b65\u5185\u5bb9\u7ed3\u679c" + s);
            JSONObject json = JSON.parseObject((String)s);
            if (json != null && json.get((Object)"success").toString().equals("true")) {
                map.put("status", true);
                map.put("webID", json.get((Object)"data"));
            }
        }
        catch (Exception ex) {
            log.error("\u7528\u6237\u540c\u6b65\u5185\u5bb9", (Throwable)ex);
            map.put("status", false);
        }
        return map;
    }

    public static Map<String, Object> getCompany(SysClientCompany company) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String url = (String)GlobalResources.map.get("YWZC_URL") + COMPANY_SYNCHRONIZATION;
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put("sign", "BLB");
        mapParams.put("webType", "BLB");
        if (company.getWeb_id() != null) {
            mapParams.put("id", company.getWeb_id());
        }
        if (company.getCompany_name() != null) {
            mapParams.put("companyName", company.getCompany_name());
        }
        if (company.getCompany_ename() != null) {
            mapParams.put("companyEname", company.getCompany_ename());
        }
        if (company.getProvince() != null) {
            mapParams.put("province", company.getProvince());
        }
        if (company.getCity() != null) {
            mapParams.put("city", company.getCity());
        }
        if (company.getDistrict() != null) {
            mapParams.put("district", company.getDistrict());
        }
        if (company.getRegistered_address() != null) {
            mapParams.put("registeredAddress", company.getRegistered_address());
        }
        if (company.getBusiness_address() != null) {
            mapParams.put("businessAddress", company.getBusiness_address());
        }
        if (company.getOrganization_code_type() != null && "7".equals(company.getOrganization_code_type())) {
            mapParams.put("documentType", "1");
        }
        if (company.getOrganization_code_type() != null && "2".equals(company.getOrganization_code_type())) {
            mapParams.put("documentType", "2");
        }
        if (company.getOrganization_code_type() != null && "1".equals(company.getOrganization_code_type())) {
            mapParams.put("documentType", "3");
        }
        if (company.getOrganization_code() != null) {
            mapParams.put("organizationCode", company.getOrganization_code());
        }
        if (company.getEnterprise_type() != null) {
            mapParams.put("enterpriseType", company.getEnterprise_type());
        }
        if (company.getManagement_nature() != null) {
            mapParams.put("natureManagement", company.getManagement_nature());
        }
        if (company.getLink_name() != null) {
            mapParams.put("contactsList[0].contactsType", 2);
            mapParams.put("contactsList[0].name", company.getLink_name());
        }
        if (company.getAgent_duty() != null) {
            mapParams.put("contactsList[0].contactsDuty", company.getLink_duty());
        }
        if (company.getLink_phone() != null) {
            mapParams.put("contactsList[0].contactsWay", company.getLink_phone());
        }
        if (company.getLink_email() != null) {
            mapParams.put("contactsList[0].email", company.getLink_email());
        }
        try {
            logger.info("\u540c\u6b65\u673a\u6784\u5185\u5bb9" + ((Object)mapParams).toString());
            String s = HttpUtil.doPost2((String)url, mapParams);
            logger.info("\u540c\u6b65\u673a\u6784\u8fd4\u56de\u503c" + s);
            JSONObject json = JSON.parseObject((String)s);
            if (json != null && json.get((Object)"success").toString().equals("true")) {
                map.put("status", true);
                map.put("webID", json.get((Object)"data"));
            }
        }
        catch (Exception ex) {
            map.put("status", false);
            log.error("\u540c\u6b65\u673a\u6784", (Throwable)ex);
        }
        return map;
    }

    public static String getRecommendCode() {
        String r_code = JedisUtils.get((String)("r_code:" + IpAddress.getIpAddress((HttpServletRequest)UserSupportUtil.getRequest())));
        if (StringUtils.isNotEmpty((String)r_code)) {
            try {
                r_code = BASE64Util.decryptBASE64((String)r_code);
            }
            catch (Exception e) {
                log.error("\u4ea7\u54c1\u5206\u4eab\u4e0a\u7684\u90a3\u4e2a\u7801", (Throwable)e);
            }
            return r_code;
        }
        return "";
    }

    public static void setRecommendCodeXH(String rCode) {
        try {
            JedisUtils.set((String)("r_code:" + IpAddress.getIpAddress((HttpServletRequest)UserSupportUtil.getRequest())), (String)BASE64Util.encryptBASE64((String)rCode), (int)1800);
        }
        catch (Exception e) {
            log.error("UserSupportUtil-setRecommendCodeXH\uff1a\u4ea7\u54c1\u5206\u4eab\u7801base64\u52a0\u5bc6\u5931\u8d25--", (Throwable)e);
        }
    }

    public static void setRecommendCode(String rCode) {
        JedisUtils.set((String)("r_code:" + IpAddress.getIpAddress((HttpServletRequest)UserSupportUtil.getRequest())), (String)rCode, (int)1800);
    }

    public static void delCustomSession(String key) {
        JedisUtils.del((String)(key + IpAddress.getIpAddress((HttpServletRequest)UserSupportUtil.getRequest())));
    }

    public static void setCustomSession(String key, String value) {
        JedisUtils.set((String)(key + IpAddress.getIpAddress((HttpServletRequest)UserSupportUtil.getRequest())), (String)value, (int)600);
    }

    public static String getCustomSession(String key) {
        return JedisUtils.get((String)(key + IpAddress.getIpAddress((HttpServletRequest)UserSupportUtil.getRequest())));
    }

    public static HttpServletRequest getRequest() {
        if (RequestContextHolder.getRequestAttributes() != null) {
            return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        }
        return null;
    }

    public static void setQrCode(String key, String value) {
        JedisUtils.set((String)("qr_code:" + key), (String)value, (int)600);
    }

    public static String getQrCode(String key) {
        return JedisUtils.get((String)("qr_code:" + key));
    }

    public static void main(String[] args) {
    }
}

