<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>未见费保单信息记录列表</title>
    <%@include file="/WEB-INF/include/head.jsp"%>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">

    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">

                <div class="ibox-content">
                    <div class="alert alert-success">
                        未见费保单信息记录指请求保险公司平台核保接口，对方按未见费模式出单，这时对方返回报文中含保单信息，我方检索到信息并记录，用于补承保操作。
                    </div>
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <form id="queryForm">
                                        <table>
                                            <tr>
                                                <td style="padding-left:0px;">
                                                    <div style="display:inline;padding-left:9px;">
                                                        关键字:
                                                        <input  class="easyui-textbox" name="keyword" data-options="prompt:'订单号/投保单号/保单号'" placeholder="" style="width:275px;" />
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="queryBtn" type="button" class="btn  btn-primary btn-sm" >
                                                            <i class="glyphicon glyphicon-search"></i> 搜索</button>
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="clearQueryForm" type="button" class="btn btn-primary btn-sm " >
                                                            <i class="glyphicon glyphicon-minus"></i> 清空</button>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                    <table id="defaultTable"
                                           data-toggle="table"
                                           data-show-refresh="true"
                                           data-search="false"
                                           data-show-toggle="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="sort"
                                           data-url="${ctx}/unseefee/query"
                                           data-method="post"
                                           data-content-type="application/x-www-form-urlencoded; charset=UTF-8"
                                           data-side-pagination="server"
                                           data-page-list="[10, 25, 50, 100, ALL]"
                                           data-query-params="myQueryParams"
                                           data-sort-order="asc"
                                           load-success.bs.table="onLoadSuccessFn"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-halign="center" data-align="center" data-sortable="false" data-field="rownum" data-formatter="rownumFn">序号</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="trade_serial_number" >订单号</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="appno" >投保单号</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="polno" >保单号</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="premium" >保费</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="name_cn" >投保人</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="create_time">产生时间</th>
                                            <th data-halign="center" data-align="center" data-sortable="false" data-field="" data-formatter="formatOperationFn">操作 </th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script type="text/javascript">
        function refresh(){
            $('#defaultTable').bootstrapTable('refresh');
        }
        $(document).ready(function () {
            //查询按钮
            $("#queryBtn").unbind('click').click(function(){
                $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});
            });

            //清空查询列表
            $("#clearQueryForm").unbind('click').click(function(){
                $("#queryForm").form("clear");
            });

        });

        function rownumFn(value, row, index){
            var opt = $('#defaultTable').bootstrapTable('getOptions');
            if(opt.pageSize=="All") return index +1;
            return opt.pageSize * (opt.pageNumber - 1) + index + 1;
        }

        function formatOperationFn(index, row) {
            var str = "";
            <shiro:hasPermission name="unseefee:win:edit">
                var onClick2= "member_underwrite(this,'"+row.appno+"','"+row.polno+"','"+row.eurl+"','"+row.premium+"')";
                str += '<a class="remove m-l-sm text-primary" href="javascript:void(0)" onclick="'+onClick2+'" title="补承保" > <i class="glyphicon glyphicon-edit"></i>补承保</a>';
            </shiro:hasPermission>
                return str;
        }
        /*补承保操作*/
        function member_underwrite(obj, appno, polno, eurl, premium) {
            layer.confirm('确认要对该记录指向的订单做补承保操作吗？', {  btn: ['确定', '取消'] }, function () {
                g_ajax('${ctx_defaul}/ZH-API/GZZRX/callbackHelpTest'
                    ,{appno:appno, polno:polno, eurl:eurl, payamt:premium}
                    , function(json){
                    comm_back(json);
                });
            });
        }
        function comm_back(json){
            console.log(json.resultCode);
            if (json.resultCode == '0000') {
                $('#defaultTable').bootstrapTable('refresh');
                layer.msg("已提交业务，若承保成功，刷新列表将不再出现该数据条目！", {icon: 1, time: 2000});
            } else {
                layer.alert(json.errInfo, {icon: 2});
            }
        }

        function myQueryParams(params) { //limit offset order sort
            var obj = g_sobj($("#queryForm").form());
            for(var i in obj){
                if(obj[i]=="") eval("delete obj."+i);
            }
            return $.extend(obj, params);
        }


    </script>
</bcxinFooter>
</body>
</html>
