<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>供应商报表</title>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-sm-12">
            <div class="float-e-margins">
                <div class="ibox-title">
                    <h5>搜索查询</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link">
                            <i class="fa fa-chevron-up"></i>
                        </a>
                        <a class="close-link">
                            <i class="fa fa-times"></i>
                        </a>
                    </div>
                </div>
                <div class="ibox-content search-query">
                    <form action="${ctx}/supplier/report/feeListData" method="post" id="searchForm">

                        <div class="col-sm-6">
                            <div class="form-group" id="data_5">
                                <div class="input-daterange input-group">
                                    <input type="text" class="form-control"  id="begincreate_time" name="startDate"  placeholder="请选择日期..."/>
                                    <span class="input-group-addon">到</span>
                                    <input type="text" class="form-control"  id="endcreate_time" name="endDate"  placeholder="请选择日期..."/>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group">
                                <div class="input-group">
                                    <span class="input-group-btn">
                                        <button type="button" class="btn btn-primary" onclick="sumbit()">搜索</button>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>佣金列表</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                        <a class="close-link"><i class="fa fa-times"></i></a>
                    </div>
                </div>
                <div class="ibox-content">
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <label>采购数量：${num} &nbsp;&nbsp; 总佣金：${amount}元   </label>
                                    <table id="table"
                                           data-toggle="table"
                                           data-show-toggle="true"
                                           data-search="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="num"
                                           data-url="${ctx}/supplier/report/feeListData"
                                           data-query-params="queryParams"
                                           data-side-pagination="server"
                                           data-field="records"
                                           data-sort-order="desc"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-field="oid"  data-halign="center" data-align="center" data-field="oid"  >id</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="supplierName">供应商</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="num">采购数量</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="outPrice" data-formatter="setOutPrice">外报总价</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="settlementPrice" data-formatter="setSettlementPrice">结算总价</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="brokerage" data-formatter="setBrokerage">佣金</th>
                                            <th data-halign="center" data-align="center" data-sortable="true"    data-formatter="setStatusClass">操作</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id = "view" class="hidden">
    <a class="edit m-l-sm text-warning" href="javascript:void(0)" onclick="var id ='${company.id}'; member_show('查询明细','${ctx}/supplier/report/findFeeListDetatil/viewId','','','900',null)" title="查询明细">
        <i class="glyphicon glyphicon-zoom-in"></i>
    </a>
</div>


<bcxinFooter>
    <script type="text/javascript">
        function sumbit() {
            $("#table").bootstrapTable('refresh', {
                url: $("#searchForm").attr("action"),
                query: $("#searchForm").serializeObject()
            });
        }
        function  setStatusClass(value, row, index){
            var v =$("#view").html().replace("viewId",row.oid);
            v =v.replace("productType",row.productType);
            return v;
        }
        function setBrokerage(value, row, index) {
            return toDecimal(value);
        }
        function setSettlementPrice(value, row, index) {
            return toDecimal(value);
        }
        function setOutPrice(value, row, index) {
            return toDecimal(value);
        }
    </script>
</bcxinFooter>
</body>
</html>
