<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
    <title>提现详情页</title>
    <link rel="stylesheet" href="${ctxsta}/common/icheck/flat/green.css"/>
</head>

<body class="gray-bg">
<div class="wrapper add-member-content animated fadeInRight">
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">

                <div class="ibox-title">
                    <h5>提现信息</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                        <a class="close-link"><i class="fa fa-times"></i></a>
                    </div>
                </div>

                <div class="ibox-content">
                    <form id="syscompanyform" class="form-horizontal" method="POST">
                        <input type="text" name="companyType" class="form-control hide" value="3">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="col-sm-2 control-label">申请人名称:</label>
                                <div class="col-sm-4">
                                    <input type="text" name="applyName" class="form-control" value="${detailVO.applyName}" readonly="readonly">
                                </div>
                                <label class="col-sm-2 control-label">申请人角色:</label>
                                <div class="col-sm-4">
                                    <input type="text" name="applyRole" class="form-control" value="分销商" readonly="readonly">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="col-sm-2 control-label">申请时间:</label>
                                <div class="col-sm-4">
                                    <input type="text" name="applyTime" class="form-control" value="<fmt:formatDate type="both" dateStyle="medium" timeStyle="medium"  value="${detailVO.applyTime}" />" readonly="readonly">
                                </div>
                                <label class="col-sm-2 control-label">状态:</label>
                                <div class="col-sm-4">
                                        <input type="text" name="status" class="form-control" value="${fns:getDictLabel(detailVO.status,"advance_status","-")}" readonly="readonly">
                                </div>
                            </div>
                        </div>

                        <div class="ibox-title">
                            <h5>银行卡信息</h5>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="col-sm-2 control-label">开户银行:</label>
                                <div class="col-sm-4">
                                    <input type="text" name="bank" class="form-control" value="${detailVO.bank}" readonly="readonly">
                                </div>
                                <label class="col-sm-2 control-label">银行卡号:</label>
                                <div class="col-sm-4">
                                    <input type="text" name="bankCard" class="form-control" value="${detailVO.bankCard}" readonly="readonly">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="col-sm-2 control-label">户主姓名:</label>
                                <div class="col-sm-4">
                                    <input type="text" name="bankOwnName" class="form-control" value="${detailVO.bankOwnName}" readonly="readonly">
                                </div>
                                <label class="col-sm-2 control-label">银行预留联系电话:</label>
                                <div class="col-sm-4">
                                    <input type="text" name="bankPhone" class="form-control" value="${detailVO.bankPhone}" readonly="readonly">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="col-sm-2 control-label">开户行所在城市:</label>
                                <div class="col-sm-4">
                                    <input type="text" name="bankAddress" class="form-control" value="${detailVO.bankAddress}" readonly="readonly">
                                </div>
                            </div>
                        </div>


                        <div class="ibox-title">
                            <h5>提现订单</h5>
                        </div>

                        <div class="ibox-content">
                            <table class="table table-bordered">
                                <thead>
                                <tr>
                                    <th>订单编号</th>
                                    <th>产品名称</th>
                                    <th>犹豫期/结算日期</th>
                                    <th>下单时间</th>
                                    <th>可得佣金</th>
                                </tr>
                                </thead>
                                <tbody>
                                        <tr>
                                            <td>${detailVO.insOrderForm.tradeSerialNumber}</td>
                                            <td>${detailVO.insProduct.insuranceName}</td>
                                            <td>${detailVO.clearingTime}</td>
                                            <td><fmt:formatDate value="${detailVO.insOrderForm.startTime}" pattern="yyyy-MM-dd HH:mm" /></td>
                                            <td>${detailVO.brokerage}</td>
                                        </tr>
                                </tbody>
                            </table>
                        </div>
                        <%--<div class="ibox-title">
                            <h5>操作记录</h5>
                        </div>
                        <div class="ibox-content">
                            <table class="table table-bordered">
                                <thead>
                                <tr>
                                    <th>操作时间</th>
                                    <th>操作人员</th>
                                    <th>操作事项</th>
                                    <th>备注</th>
                                </tr>
                                </thead>
                                <tbody>
                                <c:choose>
                                    <c:when test="${fn:length(detailVO.handleList) <= 0}">
                                        <tr>
                                            <td colspan="4" style="text-align: center;">暂无相关数据</td>
                                        </tr>
                                    </c:when>
                                    <c:otherwise>
                                        <c:forEach items="${detailVO.handleList}" var="handleList">
                                            <tr>
                                                <td><fmt:formatDate type="both" dateStyle="medium" timeStyle="medium"  value="${handleList.handleTime}" /></td>
                                                <td>${handleList.handleName}</td>
                                                <td>${handleList.handleDetail}</td>
                                                <td>${handleList.handleRemark}</td>
                                            </tr>
                                        </c:forEach>
                                    </c:otherwise>
                                </c:choose>
                                </tbody>
                            </table>
                        </div>--%>
                        <div class="hr-line-dashed"></div>
                        <div class="form-group">
                            <div class="col-sm-4 col-sm-offset-4 add-submit">
                                <input type="hidden" class="form-control" name="id" id="id" value="${detailVO.id}">
                                <c:if test="${detailVO.status eq '2'}">
                                     <button class="btn btn-primary dictsubmit" type="button" onclick="submitStatus('${detailVO.id}','${detailVO.status}')">已提现</button>
                                     <button class="btn btn-primary dictsubmit" type="button" onclick="addRemark('${detailVO.id}')">添加备注</button>
                                </c:if>
                                <button class="btn btn-primary sysusersubmit" type="button" id="closeLayer" onclick="layer_close()">关闭</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <!-- iCheck -->
    <script src="${ctxsta}/common/icheck/icheck.min.js"></script>
    <link rel="stylesheet" href="${ctxsta}/common/bootstrap-fileinput-master/css/fileinput.css" type="text/css" />
    <script src="${ctxsta}/common/bootstrap-fileinput-master/js/fileinput.js"></script>
    <script src="${ctxsta}/common/bootstrap-fileinput-master/js/fileinput_locale_zh.js"></script>
    <!-- 自定义js -->
    <script type="text/javascript">
        $(document).ready(function() {
            $('input').iCheck({
                checkboxClass : 'icheckbox_flat-green',
                radioClass : 'iradio_flat-green'
            });
        });

        /**
         * 修改为提现状态
         * @param obj
         */
        function submitStatus(obj,status) {
            if(status==3){
                layer.msg("该比订单已经提现,不能重复提现", {icon: 2});
                return;
            }
            $.ajax({
                url:'${ctx}'+'/withdraw/cash/updateStatus/'+obj+'?status=3',
                type:'POST', //GET
                async:false,  //或false,是否异步
                dataType:'json', //返回的数据格式
                success:function(result){
                    layer.msg(result.message, {
                        shade: 0.3,
                        time: 1000
                    }, function () {
                        window.parent.location.reload();//刷新父页面
                    });
                },error:function(result){
                    top.layer.msg(result.message, {
                        icon: 2,
                        time: 1000
                    });
                },
            })
        }

        function addRemark(obj){
            layer.prompt({title: '添加备注', formType: 2}, function(text, index){
                layer.close(index);
                $.ajax({
                    url:'${ctx}'+'/withdraw/cash/insertHandle/'+obj+'?text='+text,
                    type:'POST', //GET
                    async:false,    //或false,是否异步
                    dataType:'json',    //返回的数据格式：json/xml/html/script/jsonp/text
                    success:function(result){
                        layer.msg(result.message, {
                            shade: 0.3,
                            time: 1000
                        }, function () {
                            window.parent.location.reload(); //刷新父页面
                        });
                    },
                    error:function(result){
                        layer.msg(result.message, {
                            icon: 2,
                            time: 1000
                        });
                    },
                })

            });
        }
    </script>
</bcxinFooter>
</body>
</html>

