<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
    <title>在保人员列表</title>
    <%@include file="/WEB-INF/include/head.jsp"%>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>在保人员列表</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                        <a class="close-link"><i class="fa fa-times"></i></a>
                    </div>
                </div>
                <div class="ibox-content" id="order_list">
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <form id="queryResultSetForm">
                                        <table>
                                            <tr>
                                                <td style="padding-left:0px;">
                                                    <div style="display:inline;padding-left:9px;">
                                                        关键字:
                                                        <input  class="easyui-textbox" name="keyword" data-options="prompt:'姓名/身份证/手机号'" placeholder="" style="width:275px;" />
                                                        <input type="hidden" name="ins_insurance_slip_id" value="${oid}" />
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="queryResultSetBtn" type="button" class="btn  btn-primary btn-sm" >
                                                            <i class="glyphicon glyphicon-search"></i> 搜索</button>
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="clearQueryResultSetForm" type="button" class="btn btn-primary btn-sm " >
                                                            <i class="glyphicon glyphicon-minus"></i> 清空</button>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                    <div id="toolbar" class="btn-group m-t-sm">
                                        <button type="button" class="btn btn-default"  title="导出在保人员列表" onclick="down_result_set()">
                                            <i class="glyphicon glyphicon-download-alt">导出人员</i>
                                        </button>
                                    </div>
                                    <table id="defaultResultSetTable"
                                           data-toggle="table"
                                    <%--data-show-refresh="true"--%>
                                           data-search="false"
                                           data-show-toggle="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="revise_time"
                                           data-url="${ctx}/ins/policy/underWarrantyList_table"
                                           data-method="post"
                                           data-content-type="application/x-www-form-urlencoded; charset=UTF-8"
                                           data-side-pagination="server"
                                           data-page-list="[10, 25, 50, 100, ALL]"
                                           data-query-params="myQueryResultSetParams"
                                           data-sort-order="desc"
                                           load-success.bs.table="onLoadSuccessFn"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="name">姓名</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="id_card">身份证</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="tel" >手机号</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="birthday">出生日期</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="sex">性别</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="career">职业</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#queryResultSetBtn").unbind('click').click(function(){  $('#defaultResultSetTable').bootstrapTable('refresh');   });  //查询按钮
            $("#clearQueryResultSetForm").unbind('click').click(function(){    $("#queryResultSetForm").form("clear");    });   //清空查询列表
        });

        function myQueryResultSetParams(params) { //limit offset order sort
            var obj = g_sobj($("#queryResultSetForm").form());
            for(var i in obj){
                if(obj[i]=="") eval("delete obj."+i);
            }
            return $.extend(obj, params);
        }
        /*人员导出操作*/
        function down_result_set(){
            var index = layer.confirm('是否导出当前保单的在保人员列表？',{btn: ['确定','取消'] //按钮
            }, function(){
                location.href='${ctx}/ins/policy/down_result_set/${oid}';
                layer.close(layer.index);
            });
        }
    </script>
</bcxinFooter>
</body>
</html>
