<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html lang="zh-cn">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title></title>
	<%@include file="/WEB-INF/include/head.jsp"%>
	<style>
		.bid-context table{
			width: 100%;

		}
		.bid-context table thead tr{
			background: #eee;
		}
		.bid-context table tr{
			line-height: 40px;
		}
		.bid-context table tr td{
			text-align: center;
			border: 1px solid #ddd;
		}
	</style>
</head>
<body>
<div class="container bid">
	<div class="content">
		<h3>基础信息</h3>
		<p class="clearfix"><span class="pull-right">订单状态：${fns:getDictLabel (orderVo.policy_status,"order_status","")}</span></p>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">订单号</li>
					<li class="no-bor">${orderVo.trade_serial_number}</li>
					<li class="no-bor">投保单号</li>
					<li class="no-bor">${orderVo.policy_serial_number}</li>
					<li class="no-bor">下单时间</li>
					<li class="no-bor">${orderVo.start_time}</li>
					<li class="no-bor">支付方式</li>
					<li class="no-bor">
						<c:set var="paymentMethods" value="${empty transactionList ? '' : transactionList[0].pay_type}"></c:set>
						${empty paymentMethods ? '-' : fns:getDictLabel (paymentMethods,"pay_type","")}
					</li>
					<li class="no-bor">最后支付时间</li>
					<li class="no-bor">
						<c:set var="endTimes" value="${empty transactionList ? '' : transactionList[transactionList.size()-1].end_time}"></c:set>
						<c:if test="${not empty endTimes }">
							<fmt:formatDate value="${endTimes}" type="both" pattern="yyyy-MM-dd HH:mm:ss"/>
						</c:if>
					</li>
					<li class="no-bor">支付流水号</li>
					<li class="no-bor">
						<c:forEach items="${transactionList}" var="list">
							${list.trade_serial_number}<br/>
						</c:forEach>
					</li>
					<li class="no-bor">下单帐号</li>
					<li class="no-bor">${orderVo.login_name}</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">产品信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">产品名称</li>
					<li class="no-bor" title="${orderVo.product_name}">${orderVo.product_name}</li>
					<li class="no-bor">保费（元）</li>
					<li class="no-bor">${orderVo.gross_premium}</li>
					<li class="no-bor">保险期限</li>
					<li class="no-bor" id="days"></li>
					<li class="no-bor"></li>
					<li class="no-bor"></li>
					<li class="no-bor">生效日期</li>
					<li class="wd80 no-bor">
						${orderVo.inception_date}
						至
						${orderVo.planned_end_date}
					</li>
					<li class="no-bor">司法管辖</li>
					<li class="wd80 no-bor">中华人民共和国司法管辖（港澳台除外）</li>
					<li class="no-bor">争议处理</li>
					<li class="wd80 no-bor">${ vo.dispute eq '0' ? '诉讼' : '仲裁，仲裁机构' }&nbsp;&nbsp;${vo.dispute eq '0' ? '': vo.arbitral_institution}</li>
				</ul>
				<%--<table>
					<thead>
					<tr>
						<td class="col-sm-6 col-xs-6">保障责任</td>
						<td class="col-sm-6 col-xs-6">保险金额</td>
					</tr>
					</thead>
					<tbody>
					<c:if test="${not empty irpVoList}">
						<c:forEach items="${ irpVoList }" var="irp">
							<tr>
								<td class="col-sm-6 col-xs-6">${irp.name}</td>
								<td class="col-sm-6 col-xs-6">${irp.fcy}${empty irp.compensation_days ? '元' : '元/天'}</td>
							</tr>
						</c:forEach>
					</c:if>
					</tbody>
				</table>--%>
				<table class="table ">
					<tbody>
					<tr>
						<td class="col-sm-4 col-xs-4">保障责任</td>
						<td class="col-sm-2 col-xs-2">
							<c:set var="irp_1" value="${ vo.responsibilityVoList[0] }"></c:set>
							<c:choose>
								<c:when test="${empty irp_1.insurance_amount_max && not empty irp_1.fcy}">
									保险金额
								</c:when>
								<c:when test="${empty irp_1.fcy && not empty irp_1.insurance_amount_max}">
									赔偿限额
								</c:when>
								<c:otherwise>
									保险金额
								</c:otherwise>
							</c:choose>
						</td>
						<td class="col-sm-2 col-xs-2">免赔额</td>
						<td class="col-sm-2 col-xs-2">赔付比例</td>
						<td class="col-sm-2 col-xs-2">免赔天数</td>
					</tr>
					<c:forEach items="${ vo.responsibilityVoList }" var="irp">
						<tr <c:choose>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '0' && irp.is_optional eq '2'}">
								hidden
							</c:when>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '1' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障一')}">
								hidden
							</c:when>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '2' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障二')}">
								hidden
							</c:when>
							<c:when test="${empty vo.is_contain_repo && irp.is_optional eq '2'}">
								hidden
							</c:when>
							<c:otherwise>

							</c:otherwise>
						</c:choose>>
							<td class="col-sm-4 col-xs-4" style="text-align:left; <c:if test="${irp.name eq '烈士褒扬金'}">color: red;</c:if>">${irp.name}<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="${irp.explain_product}"/></td>
							<td class="col-sm-2 col-xs-2" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
								<c:choose>
									<c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元/天
													</c:if>
												</c:if>
											</span>
									</c:when>
									<c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元/天
													</c:if>
												</c:if>
											</span>
									</c:when>
									<c:otherwise>
										<span>-</span>
									</c:otherwise>
								</c:choose>
							</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.deductible_days ? '-' : irp.deductible_days}</td>
						</tr>
					</c:forEach>
					</tbody>
				</table>
			</div>
		</div>
	</div>

	<div class="content">
		<h3 class="mb20">投/被保人信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">姓名</li>
					<li class="no-bor" title="${vo.roleSubjectList[0].name_cn}">${vo.roleSubjectList[0].name_cn}</li>
					<li class="no-bor">证件类型</li>
					<li class="no-bor">
						<c:forEach items="${typeList }" var="list">
							<c:if test="${list.value eq vo.roleSubjectList[0].id_type}">
								${list.name}
							</c:if>
						</c:forEach>
					</li>
					<li class="no-bor">证件号码</li>
					<li class="no-bor">${vo.roleSubjectList[0].organization_code}</li>
					<li class="no-bor">出生日期</li>
					<li class="no-bor">${vo.roleSubjectList[0].birth_date}</li>
					<li class="no-bor">性别</li>
					<li class="no-bor">${empty vo.roleSubjectList[0].sex ? '':vo.roleSubjectList[0].sex eq '1'?'男':'女'}</li>
					<li class="no-bor">手机号码</li>
					<li class="no-bor">${vo.roleSubjectList[0].mobile}</li>
					<li class="no-bor">健康状况</li>
					<li class="no-bor">${empty vo.roleSubjectList[0].health ? '':
							vo.roleSubjectList[0].health eq '01'?'健康或良好':
									vo.roleSubjectList[0].health eq '02'?'一般或较弱':
											vo.roleSubjectList[0].health eq '03'?'有慢性病':
													vo.roleSubjectList[0].health eq '04'?'心血管病':
															vo.roleSubjectList[0].health eq '05'?'脑血管病':
																	vo.roleSubjectList[0].health eq '06'?'慢性呼吸系统病':
																			vo.roleSubjectList[0].health eq '07'?'慢性消化系统病':
																					vo.roleSubjectList[0].health eq '08'?'慢性肾炎':
																							vo.roleSubjectList[0].health eq '09'?'结核病':
																									vo.roleSubjectList[0].health eq '10'?'糖尿病':
																											vo.roleSubjectList[0].health eq '11'?'神经或精神疾病':
																													vo.roleSubjectList[0].health eq '12'?'癌症':
																															vo.roleSubjectList[0].health eq '13'?'其他慢性病':
																																	vo.roleSubjectList[0].health eq '14'?'残疾':
																																			vo.roleSubjectList[0].health eq '15'?'视力残疾':
																																					vo.roleSubjectList[0].health eq '16'?'听力残疾':
																																							vo.roleSubjectList[0].health eq '17'?'语言残疾':
																																									vo.roleSubjectList[0].health eq '18'?'肢体残疾':
																																											vo.roleSubjectList[0].health eq '19'?'智力残疾':
																																													vo.roleSubjectList[0].health eq '20'?'精神残疾':
																																															vo.roleSubjectList[0].health eq '21'?'多重残疾':
																																																	vo.roleSubjectList[0].health eq '22'?'其他残疾':
																																																			'其他'}</li>
					<li class="no-bor">是否参加医疗</li>
					<li class="no-bor">${empty vo.roleSubjectList[0].health_flag ? '':vo.roleSubjectList[0].health_flag eq '1'?'是':'否'}</li>
					<li class="no-bor">电子邮箱</li>
					<li class="no-bor">${vo.roleSubjectList[0].email}</li>
					<li class="no-bor">联系地址</li>
					<li class="no-bor">${reg_role}${vo.roleSubjectList[0].reg_address}</li>
				</ul>
			</div>
		</div>
	</div>

	<!-- 票单信息 start -->
	<div class="ibox-title">
		<h5>
			单证信息
		</h5>
	</div>
	<div class="ibox-content">
		<div class="hr-line-dashed"></div>
		<div class="form-group">
			<div class="col-sm-12">
				<p>*本产品仅提供电子保单和电子发票（普票）。</p>
				<p>*投保成功后电子保单及电子发票将发送至投/被保险人邮箱。</p>
			</div>
		</div>
	</div>
	<c:if test="${ not empty orderVo.external_reference && not empty orderVo.insure_path}">
		<div class="ibox-title">
			<h5>
				保单信息
			</h5>
		</div>
		<div class="ibox-content">
			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">电子保单：</label>
				<div class="col-sm-10">
					<a target="_blank" href="${orderVo.insure_path}">查看</a>
				</div>
			</div>
		</div>
	</c:if>
	<c:if test="${ not empty orderVo.remarks}">
		<div class="ibox-title">
			<h5>
				其它
			</h5>
		</div>
		<div class="ibox-content">
			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">备注:</label>
				<div class="col-sm-10">
						${ orderVo.remarks}
				</div>
			</div>
		</div>
	</c:if>
	<div class="operation">
		<div class="row oper-deta">
			<div class="col-xs-12">
				<h3>操作记录</h3>
				<ul class="detail">
					<li class="bc">操作时间</li>
					<li class="bc">操作人员</li>
					<li class="bc">操作事项</li>
					<li class="bc">备注</li>
					<c:forEach items="${logList}" var="list">
						<li><fmt:formatDate value="${list.createTime}" pattern="yyyy/MM/dd HH:mm:ss" /></li>
						<li>${not empty list.company_id ? list.company_id : list.createBy.id}</li>
						<li>${list.title}</li>
						<li>${not empty list.company_id ? 'BLB' : 'YWZC'}</li>
					</c:forEach>
				</ul>
			</div>
		</div>
	</div>
</div>
</div>
<bcxinFooter>
	<script type="text/javascript" src="${ctxsta}/admin/product/js/jquery-1.11.3.js"></script>
	<script>
        $(function(){
            function lineHeight(name){
                var height=parseFloat($("."+name+">li:nth-child(2)").css("height"));
                $("."+name+">li:first-child").css("line-height",height+"px").css("padding","0");
            }
            lineHeight("big");
            lineHeight("img-look");
            lineHeight("addr");
            lineHeight("day");
            btnCount_Click();
        })
        function  btnCount_Click(){//d1失效日期，d2生效日期
            var d1 = '${orderVo.planned_end_date}';
            var d2 = '${orderVo.inception_date}';
            var days = '';
            if(d1 != '' && d2 != ''){
                days = DateDiff(d1,d2)+'天';
            }
            $("#days").html(days);
        }

        //计算天数差的函数，通用
        function  DateDiff(sDate1,  sDate2){    //sDate1和sDate2是2006-12-18格式
            var  aDate,  oDate1,  oDate2,  iDays
            aDate  =  sDate1.split("-")
            oDate1  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])    //转换为12-18-2006格式
            aDate  =  sDate2.split("-")
            oDate2  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])
            iDays  =  parseInt(Math.abs(oDate1  -  oDate2)  /  1000  /  60  /  60  /24) + 1    //把相差的毫秒数转换为天数
            return  iDays
        }
	</script>
</bcxinFooter>
</body>
</html>
