<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>汇总子账单</title>
    <%@include file="/WEB-INF/include/head.jsp" %>
    <style>
        .bid-context table {
            width: 100%;

        }
        .buttonDiv
        {
            font-size:12px;
            text-align:center;
            padding:30px;
            vertical-align:middle ;
            line-height:22px;
            margin: 0 auto;

        }
        .bid-context table thead tr {
            background: #eee;
        }

        .bid-context table tr {
            line-height: 40px;
        }

        .bid-context table tr td {
            text-align: center;
            border: 1px solid #ddd;
        }
        .div1 {
            position: relative;
            left: 90px;
        }
        .div2 {
            width: 100px;
            height: 36px;
            background: #2178fc;
            color: #fff;
            text-align: center;
            line-height: 36px;
        }

        .upload_file {
            width: 200px;/*因为file-input在部分浏览器中会自带一个输入框，需要双击才可以点击上传,放大后将其定位到div外面就好啦*/
            height: 36px;
            position: absolute;
            left: 0px;
            top: 0;
            z-index:1;
            -moz-opacity: 0;
            -ms-opacity: 0;
            -webkit-opacity: 0;
            opacity: 0;  /*css属性——opcity不透明度，取值0-1*/
            filter: alpha(opacity=0); /*兼容IE8及以下--filter属性是IE特有的，它还有很多其它滤镜效果，而filter: alpha(opacity=0); 兼容IE8及以下的IE浏览器(如果你的电脑IE是8以下的版本，使用某些效果是可能会有一个允许ActiveX的提示,注意点一下就ok啦)*/
            cursor: pointer;
        }
    </style>
</head>

<body>
<!-- 基础信息 start -->
<div class="container bid">
    <div class="content">
        <h3>汇总账单信息</h3>
        <div class="row bid-context">
            <div class="col-sm-12"  >
                <ul class="bid-ul">
                    <li class="no-bor">保单号</li>
                    <li class="no-bor" title="${insPreservationPayVo.external_reference}">${insPreservationPayVo.external_reference}</li>
                    <li class="no-bor">投保人</li>
                    <li class="no-bor"> ${insPreservationPayVo.app_role_name}</li>
                    <li class="no-bor">保险公司</li>
                    <li class="no-bor">${insPreservationPayVo.company_name}</li>
                    <li class="no-bor">账单时间</li>
                    <li class="no-bor" > ${insPreservationPayVo.star_pay_time}至${insPreservationPayVo.end_pay_time}</li>

                </ul>

            </div>
        </div>
    </div>
</div>

<div class="hr-line-dashed"></div>
<!-- 基础信息 end -->
<!-- 人员信息 start -->
<div class="container bid">
    <div class="content">
        <h3>子帐单信息</h3>
        <div class="col-sm-12" style="margin-top: 10px">
            <form id="queryForm">
                <table>
                    <tr>
                        <td style="padding-left:0px;">
                            <div style="display:inline;padding-left:9px;">
                                关键字:
                                <input  class="easyui-textbox" name="keyword" id="keyword" data-options="prompt:'账单号/投保人/保单号/保全单数'" placeholder="" style="width:214px;" />
                                <input type="hidden" id="parentPayId" name="parentPayId" value="${parentPayId}"/>
                                <input type="hidden" id="is_part" name="is_part" value="${is_part}"/>
                            </div>
                            <div style="display:inline;padding-left:18px;">
                                账单时间: 从 <input class="easyui-datebox" data-options="editable:false" name="star_time" id="star_pay_time" style="width:125px;">
                                至 <input class="easyui-datebox" data-options="editable:false" name="end_time" id="end_pay_time" style="width:125px;">
                            </div>
                            <div style="display:inline;padding-left:18px;">
                                状态:
                                <select  class="easyui-combobox" data-options="panelWidth:100,panelHeight:128,editable:false" name="pay_status" id="pay_status" style="width:80px;">
                                    <option value="">全部</option>
                                    <option value="1">待支付</option>
                                    <option value="5">支付中</option>
                                    <option value="3">已支付</option>
                                </select>
                            </div>


                            <div style="display:inline;padding-left:18px;">
                                <button id="queryBtn" type="button" class="btn  btn-primary btn-sm" >
                                    <i class="glyphicon glyphicon-search"></i> 搜索</button>
                            </div>
                            <div style="display:inline;">
                                <button id="clearQueryForm" type="button" class="btn btn-primary btn-sm " >
                                    <i class="glyphicon glyphicon-minus"></i> 清空</button>
                            </div>
                        </td>
                    </tr>
                </table>
            </form>
            <div id="toolbar" class="btn-group">
                <button type="button" class="btn btn-warning" onclick="exportExcel()" style="width: 70px;height: 30px;">
                    <i class="glyphicon glyphicon-upload"></i><span> 导出</span>
                </button>
                <c:if test="${isPart eq '0' && insPreservationPayVo.pay_status != 3}">
                <button type="button" class="btn btn-warning" onclick="uploadSubmit()" style="width: 70px;height: 30px;">
                    <i class="glyphicon glyphicon-download"></i><span> 导入</span>
                </button>
                <button type="button" class="btn btn-warning" onclick="createPartBill()" style="height: 30px;">
                    <span>生成部分账单</span>
                </button>
                </c:if>
            </div>
            <table id="defaultTable"
                   data-toggle="table"
                   data-show-refresh="true"
                   data-search="false"
                   data-striped="true"
                   data-pagination="true"
                   data-sort-name="ins_preservation_pay_id"
                   data-url="${ctxapi}/myApply/getBillListForPage"
                   data-method="post"
                   data-content-type="application/x-www-form-urlencoded; charset=UTF-8"
                   data-side-pagination="server"
                   data-page-list="[10, 25, 50, 100, ALL]"
                   data-query-params="myQueryParams"
                   data-sort-order="desc"
                   load-success.bs.table="onLoadSuccessFn"
                   data-toolbar="#toolbar">
                <thead>
                <tr>
                    <th data-halign="center" data-align="center" data-sortable="false" data-formatter="checkboxFn"> </th>
                    <th data-halign="center" data-align="center" data-sortable="true" data-field="external_reference">保单号</th>
                    <th data-halign="center" data-align="center" data-sortable="true" data-field="company_name" >保险公司</th>
                    <th data-halign="center" data-align="center" data-sortable="true" data-field="insurance_name" >保险产品</th>
                    <th data-halign="center" data-align="center" data-sortable="true" data-field="app_role_name">投保人</th>
                    <th data-halign="center" data-align="center" data-sortable="true" data-field="pay_status" data-formatter="formatStatsFn">账单状态 </th>
                    <th data-halign="center" data-align="center" data-sortable="true" data-field="record_count" data-formatter="formatOperationFn">批改单量 </th>
                    <th data-halign="center" data-align="center" data-sortable="true" data-field="add_count">增员 </th>
                    <th data-halign="center" data-align="center" data-sortable="true" data-field="minus_count">减员 </th>
                    <th data-halign="center" data-align="center" data-sortable="true" data-field="replace_count">替换 </th>
                    <th data-halign="center" data-align="center" data-sortable="true" data-field="predict_total_amount">预缴金额 </th>
                    <th data-halign="center" data-align="center" data-sortable="false" data-field="fact_total_amount">实缴金额 </th>
                    <th data-halign="center" data-align="center" data-sortable="true" data-field="star_pay_time">账单开始时间 </th>
                    <th data-halign="center" data-align="center" data-sortable="true" data-field="end_pay_time" >账单结束时间 </th>
                </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
<form id="declinature" class="form-horizontal" action="${ctxapi}/myApply/applyAuditFail2" method="POST">
    <input type="hidden" name="status"id="status" />
    <input type="hidden" name="remark" id="remark"/>
    <input type="hidden" name="detail_id" id="detail_id" />
    <%--<input type="hidden" name="sup_id" value="${sup_id}">--%>
</form>
<div class="hr-line-dashed"></div>
<div class="container bid">
    <c:if test="${insPreservationPayVo.pay_status == 3}">
        <div class="content">
            <h3>缴费处理<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="
        1、上传缴费通知单后提交走审批流程；
        2、上传缴费凭证后提交缴费记录状态变更为“已支付”（不用走流程）；
        3、缴费通知单、缴费凭证选其一上传即可。"></i></h3>
            <div class="row bid-context">
                <div class="col-sm-12">
                    <ul class="bid-ul">
                        <li class="no-bor">缴费状态</li>
                        <li class="no-bor">${fns:getDictLabel (insPreservationPayVo.pay_status,"payStatus","")}</li>
                        <li class="no-bor">预计保全结算费用</li>
                        <li class="no-bor">${insPreservationPayVo.predict_total_amount} 元</li>
                        <li class="no-bor">缴费通知单上传</li>

                        <li class="no-bor" >
                            <a  class="easyui-linkbutton" plain="true" id="showPicture"  onclick="loadCanvas('${insPreservationPayVo.pay_inform_path}')" iconCls="icon-search"></a>
                        </li>

                        <li class="no-bor">保全结算费用</li>
                        <li class="no-bor">${insPreservationPayVo.fact_total_amount} 元</li>
                        <li class="no-bor">结算期间</li>
                        <li class="no-bor">${insPreservationPayVo.star_pay_time} 至 ${insPreservationPayVo.end_pay_time} </li>
                        <li class="no-bor">缴费凭证</li>
                        <li class="no-bor">
                            <a  class="easyui-linkbutton" plain="true" id="showJFPicture" onclick="loadCanvas('${insPreservationPayVo.pay_order_path}')" iconCls="icon-search"></a>
                        </li>
                        <li class="no-bor">发票上传<c:if test="${not empty insPreservationPayVo.fp_url}"><a class="easyui-linkbutton" plain="true" id="showFPPicture" onclick="loadCanvas('${insPreservationPayVo.fp_url}')" iconCls="icon-search"></a></c:if> </li>
                        <li class="no-bor">
                            <form id="uploadFPForm">
                                <div class="div1">
                                    <div class="div2">电子发票上传</div>
                                    <input type="hidden" id="uploadFP" value="">
                                    <input type="file" class="upload_file" id="uploadFP_file" name="upload_file"  onchange="uploadFPFilePay('uploadFPForm');">
                                    <input name="preserverFPAddress"  id="preserverFPAddress" type="hidden" value="${insPreservationPayVo.fp_url}">
                                </div>
                            </form>
                        </li>
                    </ul>

                </div>
            </div>
        </div>
    </c:if>
    <c:if test="${insPreservationPayVo.pay_status != 3}">
        <div class="content">
            <h3>缴费处理<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="
        1、上传缴费通知单后提交走审批流程；
        2、上传缴费凭证后提交缴费记录状态变更为“已支付”（不用走流程）；
        3、缴费通知单、缴费凭证选其一上传即可。"></i></h3>
            <div class="row bid-context">
                <div class="col-sm-12">
                    <ul class="bid-ul">
                        <li class="no-bor">缴费状态</li>
                        <li class="no-bor">${fns:getDictLabel (insPreservationPayVo.pay_status,"payStatus","")}</li>
                        <li class="no-bor">账单预缴费用</li>
                        <li class="no-bor">${insPreservationPayVo.predict_total_amount} 元</li>
                        <c:if test="${insPreservationPayVo.pay_status != 2}">
                            <li class="no-bor">缴费通知单上传<c:if test="${not empty insPreservationPayVo.pay_inform_path}"><a class="easyui-linkbutton" plain="true" id="showPicture"  onclick="loadCanvas('${insPreservationPayVo.pay_inform_path}')" iconCls="icon-search"></a></c:if> </li>

                            <li class="no-bor" >
                                <form id="uploadForm">
                                    <div class="div1">
                                        <div class="div2">上传缴费通知单</div>
                                        <input type="hidden" id="upload" value="">
                                        <input type="file" class="upload_file" id="upload_file" name="upload_file"  onchange="uploadFilePay('uploadForm');">
                                        <input name="preserverAddress"  id="preserverAddress" type="hidden" value="${insPreservationPayVo.pay_inform_path}">
                                    </div>
                                </form>
                            </li>
                        </c:if>
                        <c:if test="${insPreservationPayVo.pay_status == 2}">
                            <li class="no-bor">缴费通知单上传</li>

                            <li class="no-bor" >
                                <a  class="easyui-linkbutton" plain="true" id="showPicture"  onclick="loadCanvas('${insPreservationPayVo.pay_inform_path}')" iconCls="icon-search"></a>
                            </li>
                        </c:if>
                        <li class="no-bor">账单实缴费用</li>
                        <li class="no-bor"><input class="easyui-textbox" value="${insPreservationPayVo.fact_total_amount}" name="preserverCost" id="preserverCost"
                                                  style="width: 83px;line-height: normal"/> 元</li>
                        <li class="no-bor">结算期间</li>
                        <li class="no-bor">${insPreservationPayVo.star_pay_time} 至 ${insPreservationPayVo.end_pay_time} </li>
                        <li class="no-bor">缴费凭证<c:if test="${not empty insPreservationPayVo.pay_order_path}"><a class="easyui-linkbutton" plain="true" id="showJFPicture" onclick="loadCanvas('${insPreservationPayVo.pay_order_path}')" iconCls="icon-search"></a></c:if> </li>
                        <li class="no-bor">
                            <form id="uploadJFForm">
                                <div class="div1">
                                    <div class="div2">上传缴费凭证</div>
                                    <input type="hidden" id="uploadJF" value="">
                                    <input type="file" class="upload_file" id="uploadJF_file" name="upload_file"  onchange="uploadJFFilePay('uploadJFForm');">
                                    <input name="preserverJFAddress"  id="preserverJFAddress" type="hidden" value="${insPreservationPayVo.pay_order_path}">
                                </div>
                            </form>
                        </li>
                    </ul>

                </div>
            </div>
        </div>
    </c:if>
</div>




<div class="buttonDiv" style="align: center">
    <button id="checkSubmit" type="button" class="btn  btn-primary btn-sm" onclick="checkSubmit()"  >提交 </button>
    <button id="checkPay" type="button" class="btn  btn-primary btn-sm"  onclick="checkPay()"  style="background-color: red" > 确认支付</button>
    <button id="checkReturn" type="button" class="btn  btn-primary btn-sm" onclick="checkReturn()" style="background-color: grey" >关闭 </button>
</div>


<bcxinFooter>

    <script type="text/javascript">
        $(document).ready(function () {
            //查询按钮
            $("#queryBtn").unbind('click').click(function () {
                $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});
            });

            //清空查询列表
            $("#clearQueryForm").unbind('click').click(function () {
                $("#queryForm").form("clear");
            });
            updataButton();

        });
        function updataButton() {
            var status=${insPreservationPayVo.pay_status};
            if (status==1){
                $('#checkSubmit').show();
                $('#checkPay').hide();
            }else if (status==2){
                $('#checkSubmit').hide();
                $('#checkPay').show();
            }else if (status==5){
                $('#checkSubmit').hide();
                $('#checkPay').show();
            }else{
                $('#checkSubmit').hide();
                $('#checkPay').hide();
            }
        }
        function refresh() {
            $('#defaultTable').bootstrapTable('refresh');
        }

        function exportExcel(){
            var start_time = $("#star_pay_time").val();
            var end_time = $("#end_pay_time").val();
            var keyword = $("#keyword").val();
            var pay_status = $("#pay_status").val();
            var parentPayId = $("#parentPayId").val();

            var index = layer.confirm('该操作将根据搜索条件导出数据，是否继续？',{btn: ['导出','取消']}, function(){
                location.href='${ctxapi}/myApply/downChildBillPay?keyword='+keyword+'&parentPayId='+parentPayId+'&pay_status='+pay_status+'&start_time='+start_time+'&end_time='+end_time;
                layer.close(layer.index);
            });
        }
        function createPartBill(){
            var checkboxes = document.querySelectorAll('input[name="billId"]:checked'),
                values = [];

            checkboxes.forEach((checkbox) => {
                values.push(checkbox.value);
            });
            if(values.length == 0){
                layer.msg('请勾选账单');
                return false;
            }
            var index = layer.confirm('是否根据已勾选记录生成部分账单汇总？',{btn: ['生成','取消']}, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctxapi}/myApply/createPartBill',
                    data:{'isSummaryBill':'0','payIds':values.join(',')},
                    success:function(result){
                        layer.close(index);
                        if(result.status=='200'){
                            layer.msg(result.msg,{icon:1,time:1000});
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        function uploadSubmit(){
            var str = "<div style='width: 300px;'>" +
                "<p style='padding-bottom: 5px;'><textarea class=\"form-control\" rows=6 id=\"pdNo\" placeholder=\"请输入保单号（多个“,”隔开）\" style=\"width: 100%\"></textarea></p>" +
                "</div>";
            var index = layer.confirm(str,{btn: ['提交','取消'], title: "生成部分账单"}, function(){
                var pdNo = $('#pdNo').val();
                if(pdNo == undefined){
                    layer.msg("请输入保单号！", {icon: 2, time: 2000});
                    return;
                }
                pdNo = pdNo.replace('，',',').replace(' ','');
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctxapi}/myApply/createPartBillByNo',
                    data:{'isSummaryBill':'0','payNos':pdNo},
                    success:function(result){
                        if(result.status=='200'){
                            layer.msg(result.msg,{icon:1,time:1000});
                            layer.close(index);
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        function loadCanvas(_imgPath){
            if(_imgPath==""||_imgPath==null){
                layer.msg("没有找到图片地址，请核实或者上传");
            }else{
                var content = '';
                var imgs = _imgPath.split("||");
                for(var i=0;i<imgs.length;i++){
                    content += '<a href="'+imgs[i]+'" target="_blank"><img src="'+imgs[i]+'" width="100px" style="margin: 10px;"></a>';
                }
                layer.open({
                    type: 1,
                    title: " ",
                    closeBtn: 1,
                    area: '492px',
                    skin: 'layui-layer-nobg', //没有背景色
                    shadeClose: true,
                    content: content
                });
            }

        }
        function uploadFilePay(_form){
            var formData = new FormData(document.forms.namedItem(_form));
            $.ajax({
                type: 'POST',
                url:'${ctxapi}/myApply/uploadFile/${insPreservationPayVo.oid}/2',
                dataType:"json",
                data: formData,
                processData: false,
                contentType: false,
                success: function(result) {
                    if(result.success) {
                        $("#showPicture").attr('onClick','loadCanvas(\''+result.msg+'\')');
                        $("#upload").val(result.msg);
                        $("#preserverAddress").val(result.msg);

                        layer.msg("上传图片成功", {time:1000 });
                        $("#showPicture").show;

                    }else {
                        layer.msg(result.msg);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg(textStatus);
                }
            });
        }
        function uploadJFFilePay(_form){
            var formData = new FormData(document.forms.namedItem(_form));
            $.ajax({
                type: 'POST',
                url:'${ctxapi}/myApply/uploadFile/${insPreservationPayVo.oid}/3',
                dataType:"json",
                data: formData,
                processData: false,
                contentType: false,
                success: function(result) {
                    if(result.success) {
                        var path = $("#preserverJFAddress").val();
                        if(path == ''){
                            path = result.msg;
                        }else{
                            path += "||" + result.msg;
                        }
                        $("#showJFPicture").attr('onClick','loadCanvas(\''+path+'\')');
                        $("#uploadJF").val(result.msg);
                        $("#preserverJFAddress").val(path);

                        layer.msg("上传图片成功", {time:1000 });
                        $("#showJFPicture").show();

                    }else {
                        layer.msg(result.msg);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg(textStatus);
                }
            });
        }
        function uploadFPFilePay(_form){
            var formData = new FormData(document.forms.namedItem(_form));
            $.ajax({
                type: 'POST',
                url:'${ctxapi}/myApply/uploadFile/${insPreservationPayVo.oid}/4',
                dataType:"json",
                data: formData,
                processData: false,
                contentType: false,
                success: function(result) {
                    if(result.success) {
                        var path = $("#preserverFPAddress").val();
                        if(path == ''){
                            path = result.msg;
                        }else{
                            path += "||" + result.msg;
                        }
                        $("#showFPPicture").attr('onClick','loadCanvas(\''+path+'\')');
                        $("#uploadFP").val(result.msg);
                        $("#preserverFPAddress").val(path);

                        layer.msg("上传成功", {time:1000 });
                        $("#showFPPicture").show();

                    }else {
                        layer.msg(result.msg);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg(textStatus);
                }
            });
        }
        function formatStatsFn(value, row) {
            if (row.pay_status == 1) return "<span style='color:green'>待支付<span>";
            if (row.pay_status == 5) return "<span style='color:blue'>支付中<span>";
            if (row.pay_status == 3) return  "<span style='color:darkgray'>已支付<span>";
            return "";
        }

        function checkboxFn(value, row) {
            if (row.is_part == 0 && row.pay_status != 3) return '<input type="checkbox" name="billId" value="'+row.oid+'">';
            return "";
        }
        function formatOperationFn(value, row) {
            var str = "";
            var onClick2 = "member_record_list('"+row.oid+"');";
            str += '<a class="like m-l-sm text-info" href="javascript:void(0)" onclick="'+onClick2+'" title="保全详情" >'+row.record_count+'</a>';
            return str;
        }
        function member_record_list( id) {
            member_show('保全详情','${ctxapi}/myApply/payDetailByID/'+id,'',500,1000,null);

        }


        function checkReturn(){
            parent.closeLayerOpen();
        }
        function checkSubmit(){
            var fact_total_amount=$("#preserverCost").val();
            var pay_inform_path=$("#preserverAddress").val();
            var pay_order_path=$("#preserverJFAddress").val();
            var pay_status = '1';
            if(pay_inform_path == ''){
                layer.msg("请上传缴费凭证");
                return;
            }
            if(pay_order_path != ''){
                pay_status = '5';
            }
            g_ajax('${ctxapi}/myApply/updataPayStatus',{pay_id:'${insPreservationPayVo.oid}',fact_total_amount:fact_total_amount ,pay_inform_path: pay_inform_path ,pay_order_path: pay_order_path,pay_status:pay_status}, function(result){
                layer.msg(result.msg, {time:1000});
                if(result.success){
                    setTimeout("reloadParent()",1200);

                        }else{
                    layer.msg(result.msg);
                        }
                    });
        }
        function reloadParent() {
            parent.refresh();
            parent.closeLayerOpen();
        }
        function checkPay(){
            var fact_total_amount=$("#preserverCost").val();
            var pay_inform_path=$("#preserverAddress").val();
            var pay_order_path=$("#preserverJFAddress").val();
            g_ajax('${ctxapi}/myApply/updataPayStatus',{pay_id:'${insPreservationPayVo.oid}',fact_total_amount:fact_total_amount ,pay_inform_path: pay_inform_path ,pay_order_path: pay_order_path,pay_status:'3'}, function(result){

                if(result.success){
                    parent.refresh();
                    parent.closeLayerOpen();
                }else{
                    layer.msg(result.msg);
                }
            });
        }
        function comm_back(json) {
            if (json.success == true) {
                $('#defaultTable').bootstrapTable('refresh');
                layer.msg(json.msg, {icon: 1, time: 1000});
            } else {
                layer.alert(json.msg, {icon: 2});
            }
        }
        function myQueryParams(params) { //limit offset order sort
            console.log("参数是：" + params)
            var obj = g_sobj($("#queryForm").form());
            for (var i in obj) {
                if (obj[i] == "") eval("delete obj." + i);
            }
            return $.extend(obj, params);
        }


    </script>
</bcxinFooter>
</body>
</html>
