package com.bcxin.ins.models.web;

import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.common.mapper.JsonMapper;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysMenu;
import com.bcxin.ins.core.entity.SysRole;
import com.bcxin.ins.core.entity.SysRoleMenu;
import com.bcxin.ins.core.service.SysCompanyService;
import com.bcxin.ins.core.service.SysMenuService;
import com.bcxin.ins.core.service.SysRoleMenuService;
import com.bcxin.ins.core.service.SysRoleService;
import com.bcxin.ins.spring.util.ServletUtils;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.mybatisplus.plugins.Page;
import com.google.common.collect.Maps;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

/**
* 类名称：SysRoleController   
* 类描述：角色控制器  
* 创建人：liujinju   
* @version
 */
@Controller
@RequestMapping("${systemPath}/sysrole")
public class SysRoleController extends BaseController {
	@Autowired
	private SysRoleService sysRoleService;
	@Autowired
	private SysRoleMenuService sysRoleMenuService;
	@Autowired
	private SysMenuService sysMenuService;
	@Autowired
	private SysCompanyService sysCompanyService;
	/** 角色管理页面 */
	private static final String SYSTEM_ROLE_LIST = getViewPath("/admin/system/system_role_list");
	private static final String SYSTEM_ROLE_ADD = getViewPath("/admin/system/system_role_add");
	/** 角色权限分配 */
	private static final String SYSTEM_ROLE_ADD_AUTH = getViewPath("/admin/system/system_role_add_auth");
	/**
	 * 进入角色管理页面
	 * @return ModelAndView
	 */
	@RequiresPermissions("sysuser:role:view")
	@RequestMapping("/list")
	public String showRoleList(Model model, Page page){
		//查询所有的角色
		List<SysRole> roleList = sysRoleService.selectRoleList();
		model.addAttribute("roleList", roleList);
		List<SysRole> sysRoles = sysRoleService.selectRoleAndNumber();
		model.addAttribute("sysRoles", sysRoles);
		return SYSTEM_ROLE_LIST;
	}
	/**
	* @Description: 添加角色
	* @param model
	* @return
	* @throws 
	*/
	@RequiresPermissions("sysuser:role:add")
	@RequestMapping(value = "/list/add")
	public String add(Model model) {	
		List<SysMenu> menuList = sysMenuService.findList();//所有菜单
		if(menuList!=null){
			model.addAttribute("jsonMenu", JsonMapper.toJsonString(menuList));
			logger.info(JsonMapper.toJsonString(menuList));
		}
		return SYSTEM_ROLE_ADD;
	}
	/**
	* @Description: 编辑角色
	* @param model
	* @param roleId
	* @return
	* @throws 
	*/
	@RequiresPermissions("sysuser:role:edit")
	@RequestMapping(value = "/list/{roleId}/edit")
	public String edit(Model model, @PathVariable Long roleId){
		SysRole sysRole = sysRoleService.get(roleId);
		model.addAttribute("sysRole", sysRole);//角色信息
/*		List<SysCompany> companyList = sysCompanyService.getCompanyList(new SysCompany());
		model.addAttribute("companyList", companyList);*/
		return SYSTEM_ROLE_ADD;
	}

	@RequiresPermissions("sysuser:role:auth")
	@RequestMapping(value = "/list/{roleId}/auth")
	public String editAuth(Model model, @PathVariable Long roleId){
		SysRole sysRole = sysRoleService.get(roleId);
		model.addAttribute("sysRole", sysRole);//角色信息
		List<SysMenu> menuList = sysMenuService.findList();
		model.addAttribute("menuList", menuList);
		model.addAttribute("id", roleId);
/*		List<SysCompany> companyList = sysCompanyService.getCompanyList(new SysCompany());
		model.addAttribute("companyList", companyList);*/
		return SYSTEM_ROLE_ADD_AUTH;
	}
	
	/**
	* @Description: 创建或修改角色 
	* @param  sysRole
	* @return
	* @throws 
	*/
	@RequiresPermissions({"sysuser:role:add","sysuser:role:edit"})
	@RequestMapping(value = "/list/save")
	@ResponseBody
	public AjaxResult save(SysRole sysRole){
		String menuIds = ServletUtils.getRequest().getParameter("menuIds");
		String companyIds = ServletUtils.getRequest().getParameter("companyIds");
		if(StrUtil.isBlank(menuIds)&&sysRole.getId()!=null){
			return fail(false, "请选择用户权限");
		}
		if(sysRole.getDataScope().equals(SysRole.DATA_SCOPE_CUSTOM)&&StrUtil.isBlank(companyIds)){
			return fail(false, "请选择数据范围");
		}
		sysRoleService.save(sysRole);
		return success(true, "保存角色成功");
	}



	/**
	 * 删除角色
	 * @param roleId 角色ID
	 * @return Map<String,Object>
	 */
	@RequiresPermissions("sysuser:role:delete")
	@RequestMapping("/list/{roleId}/delete")
	@ResponseBody
	public Map<String,Object> deleteRole(@PathVariable("roleId") Long roleId){
		Map<String,Object> json = Maps.newHashMap();
		if(roleId>0){
			sysRoleService.deleteById(roleId);
			SysRoleMenu sysRoleMenu = new SysRoleMenu();
			sysRoleMenu.setRoleId(roleId);
			sysRoleMenuService.delete(new EntityWrapper<SysRoleMenu>().addFilter("role_id={0}",roleId));
			json = this.setJson(true, "角色删除成功", null);
		}else{
			json = this.setJson(false, "请选择要删除的角色!", null);
		}
		return json;
	}

	/**
	 * POST 启用/禁止
	 * @param
	 * @return
	 */
	@RequiresPermissions("sysuser:role:audit")
	@RequestMapping(value = "/list/audit", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult audit() {
		Long roleId = Long.parseLong(getParameter("roleId"));
		Integer status = Integer.valueOf(getParameter("status"));
		SysRole sysRole = new SysRole();
		sysRole.setId(roleId);
		sysRole.setStatus(status);
		sysRoleService.updateById(sysRole);
		return success(true);
	}
	
}
