package com.bcxin.ins.models.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Date;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.entity.SysLog;
import com.bcxin.ins.core.service.MySysInsCompanyService;
import com.bcxin.ins.core.service.SysLogService;
import com.bcxin.ins.core.util.DateUtil;
import com.bcxin.ins.models.pro.service.*;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;


@Component
@Lazy(false)
public class WebQuartz {

	private static final Logger log = LoggerFactory.getLogger(WebQuartz.class);

	@Autowired
	MyProService proS;
	@Autowired
	MySysInsCompanyService insS;
	@Autowired
	SysLogService logS;

	@Autowired
	private ProResponsibilityService myProResponsibilityService;
	
	@Scheduled(cron = "0 0 1 * * ? ") // 每天凌晨1点，更新数据
//	@Scheduled(cron = "0/5 * * * * ? ") // 每5秒，测试
//	@Scheduled(cron = "0/3 * * * * ? ") // 每3秒，测试
	public void job1() {
		log.info("WebQuartz>>>>>>>>>>>>每天凌晨1点，保险公司同步开启");
		Map<Object,Object> p = Maps.newHashMap();
		p.put("startDate", DateUtil.getStringDate(DateUtil.getLastHour(25)));
		R r = insS.sync(p);
		log.info("WebQuartz>>>>>>>>>>>>每天凌晨1点，保险公司同步结束");
		logS.save(getLog(r,"保险公司同步"));
	}

	@Scheduled(cron = "0 0 1 * * ? ") // 每天凌晨1点，更新数据
	public void job2() {
		log.info("WebQuartz>>>>>>>>>>>>每天凌晨1点，产品分类设置同步开启");
		Map<Object,Object> p = Maps.newHashMap();
		p.put("startDate",DateUtil.getStringDate(DateUtil.getLastHour(25)));
		R r = proS.categorySync(p);
		log.info("WebQuartz>>>>>>>>>>>>每天凌晨1点，产品分类设置同步结束");
		logS.save(getLog(r,"产品分类设置同步"));
	}
	@Scheduled(cron = "0 0 1 * * ? ") // 每天凌晨1点，更新数据
	public void job3() {
		log.info("WebQuartz>>>>>>>>>>>>每天凌晨1点，产品列表同步开启");
		Map<Object,Object> p = Maps.newHashMap();
		p.put("startDate",DateUtil.getStringDate(DateUtil.getLastHour(25)));
		R r = proS.proSync(p);
		log.info("WebQuartz>>>>>>>>>>>>每天凌晨1点，产品列表同步结束");
		logS.save(getLog(r,"产品列表同步"));
	}

	private SysLog getLog(R r, String title) {
		SysLog sysLog = new SysLog();
		sysLog.setCreateTime(new Date());
		sysLog.setTitle(title);
		sysLog.setParams(JSON.toJSONString(r));
		return sysLog;
	}

	private static void deleteDir(File dir) throws IOException {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            //递归删除目录中的子目录下
            for (int i=0; i<children.length; i++) {
                deleteDir(new File(dir, children[i]));
            }
        }
        // 目录此时为空，可以删除
        Files.delete(dir.toPath());
    }
	
	public static void main(String[] args) {
//    	WebQuartz init = new WebQuartz();
//    	String str = init.getClass().getClassLoader().getResource("").getPath();
    	System.out.println(DateUtil.getStringDate(new Date()));
    	System.out.println(DateUtil.getStringDate(DateUtil.getLastHour(25)));

	}
}
