package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.*;
import com.bcxin.ins.models.order.policy.dao.InsCommonExportDao;
import com.bcxin.ins.models.order.policy.service.*;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.CommonExportVo_1;
import com.bcxin.ins.vo.CommonExportVo_2;
import com.bcxin.ins.vo.CommonExportVo_3;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;



/**
 * <b>企业短期特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsCommonExportServiceImpl extends ServiceImpl<InsCommonExportDao, SpecialCreditSt> implements InsCommonExportService {

	@Autowired
	private InsCommonExportDao dao;
	@Autowired
	private InsServiceDescriptionService insServiceDescriptionService;

	@Autowired
	private InsTurnoverService insTurnoverService;
	
	@Autowired
	private InsBadDebtService insBadDebtService;
	
	@Autowired
	private InsTopBuyersService insTopBuyersService;//list
	
	@Autowired
	private InsArDebtorsService insArDebtorsService;//list
	
	@Autowired
	private InsCreditManagementService insCreditManagementService;
	@Autowired
	private InsForecastedDetailService insForecastedDetailService;
	@Autowired
	private InsRecentYearsSellService insRecentYearsSellService;
	@Autowired
	private InsPastBadDetailService insPastBadDetailService;
	@Autowired
	private InsBadAnalysisService insBadAnalysisService;
	@Autowired
	private InsOverdueDetailService insOverdueDetailService;
	@Autowired
	private InsDebtAgesService insDebtAgesService;
	@Autowired
	private InsManagerDetailService insManagerDetailService;
	
	/**
	 * <b>企业短期出口特殊字段表信息 </b> TODO 联动关联表已封装，待测试
	 * 
	 * @param oid InsCommonExportID
	 * @author ZXF 
	 * @date 2017年1月5日 下午4:50:12
	 * @注意事项 </b>
	 * <b>
	 */
	public SpecialCreditSt getInsCommonExportBusiness(Long oid){
		SpecialCreditSt insCommonExport = dao.selectById(oid);
		if(insCommonExport != null){
			setServiceDescription(insCommonExport);
			setInsTurnover(insCommonExport);
			setInsBadDebt(insCommonExport);
			setInsCreditManagement(insCommonExport);
			setTopBuyers(insCommonExport);
			setInsArDebtors(insCommonExport);
		}
		return insCommonExport;
	}
	
	/**
	 * <b>初始化企业短期出口特殊字段表信息 </b>
	 * 
	 * @author ZXF
	 * @date 2017年1月5日 下午4:50:12
	 * @注意事项 </b>
	 * <b>
	 */
	public SpecialCreditSt initInsCommonExport(){
		SpecialCreditSt insCommonExport = new SpecialCreditSt();
		insCommonExport.setService_description(insServiceDescriptionService.initInsServiceDescription());
		insCommonExport.setTurnover(insTurnoverService.initInsTurnover());
		insCommonExport.setBad_debt(insBadDebtService.initInsBadDebt());
		insCommonExport.setCredit_management(insCreditManagementService.initInsCreditManagement());
		dao.insert(insCommonExport);
		return insCommonExport;
	}
	
	/**
	 * <b>业务描述信息 </b> 
	 * 
	 * @param insCommonExport 短期出口险特殊字段表
	 * @author ZXF 
	 * @date 2017年1月5日 下午4:50:12
	 * @注意事项 </b>
	 * <b>
	 */
	private void setServiceDescription(SpecialCreditSt insCommonExport){
		StServiceDescription result = insCommonExport.getService_description();
		if(result != null){
			insCommonExport.setService_description(insServiceDescriptionService.selectById(result.getSt_service_description_id()));
		}
	}
	
	/**
	 * <b>销售额信息 </b> 
	 * 
	 * @param insCommonExport 短期出口险特殊字段表
	 * @author ZXF 
	 * @date 2017年1月5日 下午4:50:49
	 * @注意事项 </b>
	 * <b>
	 */
	private void setInsTurnover(SpecialCreditSt insCommonExport){
		StTurnover result = insCommonExport.getTurnover();
		if(result != null){
			insCommonExport.setTurnover(insTurnoverService.packagingInsTurnover(result.getSt_turnover_id()));
		}
	}
	
	/**
	 * <b>账龄及坏账分析信息 </b> 
	 * 
	 * @param insCommonExport
	 * @author ZXF 
	 * @date 2017年1月5日 下午4:51:19
	 * @注意事项 </b>
	 * <b>
	 */
	private void setInsBadDebt(SpecialCreditSt insCommonExport){
		StBadDebt result = insCommonExport.getBad_debt();
		if(result != null){
			insCommonExport.setBad_debt(insBadDebtService.packagingInsBadDebt(result.getSt_bad_debt_id()));
		}
	}
	
	/**
	 * <b>公司信用管理 </b> 
	 * 
	 * @param insCommonExport
	 * @author ZXF 
	 * @date 2017年1月5日 下午4:51:31
	 * @注意事项 </b>
	 * <b>
	 */
	private void setInsCreditManagement(SpecialCreditSt insCommonExport){
		StCreditManagement result = insCommonExport.getCredit_management();
		if(result != null){
			insCommonExport.setCredit_management(insCreditManagementService.packagingInsCreditManagement(result.getSt_credit_management_id()));
		}
	}
	
	/**
	 * <b>前十大买家集合 </b> 
	 * 
	 * @param insCommonExport
	 * @author ZXF 
	 * @date 2017年1月5日 下午4:51:42
	 * @注意事项 </b>
	 * <b>
	 */
	private void setTopBuyers(SpecialCreditSt insCommonExport){
		List<StTopBuyers> insTopBuyersList = insTopBuyersService.selectInsTopBuyersBySpecialID(insCommonExport.getSpecial_credit_st_id());
		if(insTopBuyersList.size() > ConstProp.INT_NUMBER_ZERO){
			insCommonExport.setTopBuyers(insTopBuyersList);
		}
	}
	
	/**
	 * <b>应收账款余额分布集合 </b> 
	 * 
	 * @param insCommonExport
	 * @author ZXF 
	 * @date 2017年1月5日 下午4:52:02
	 * @注意事项 </b>
	 * <b>
	 */
	private void setInsArDebtors(SpecialCreditSt insCommonExport){
		List<StArDebtors> insArDebtorsList = insArDebtorsService.selectInsArDebtorsByInsCommonExport(insCommonExport.getSpecial_credit_st_id());
		if(insArDebtorsList.size() > ConstProp.INT_NUMBER_ZERO){
			insCommonExport.setInsArDebtors(insArDebtorsList);
		}
	}
	
	
	/**
	 * <b>获取CommonExportVo_1根据企业短期出口id查询企业短期信息插入到CommonExportVo_1 </b> 
	 * 
	 * @param vo 企业短期出口辅助表
	 * @param ceID 企业短期出口id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void getCommonExportVo_1BySpecial_id(CommonExportVo_1 vo, Long ceID){
		SpecialCreditSt insCommonExport = getInsCommonExportBusiness(ceID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insCommonExport), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insServiceDescriptionService.accordingToInsServiceDescriptionIntoCommonExportVo_1(vo, insCommonExport.getService_description());
		StTurnover turnover = insCommonExport.getTurnover();
		insTurnoverService.accordingToInsTurnoverIntoCommonExportVo_1(vo, turnover);
		vo.setForecastedDetailList(insForecastedDetailService.packagingForecastedDetailVoListByInsForecastedDetailList(turnover.getForecastedDetailList()));
		vo.setRecentYearsSellList(insRecentYearsSellService.packagingRecentYearsSellVoListByInsRecentYearsSellList(turnover.getRecentYearsSellList()));
		/*InsBadDebt badDebt = insCommonExport.getBadDebt();
		List<InsTopBuyers> topBuyersList = insCommonExport.getTopBuyers();
		List<InsArDebtors> arDebtorsList = insCommonExport.getInsArDebtors();*/
		
	}
	
	/**
	 * <b>获取CommonExportVo_2根据企业短期出口id查询企业短期信息插入到CommonExportVo_2 </b> 
	 * 
	 * @param vo 企业短期出口辅助表
	 * @param ceID 企业短期出口id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void getCommonExportVo_2BySpecial_id(CommonExportVo_2 vo, Long ceID){
		SpecialCreditSt insCommonExport = getInsCommonExportBusiness(ceID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insCommonExport), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setDebtAgesList(insDebtAgesService.getDebtAgesVoListByInsDebtAgesList(insCommonExport.getBad_debt().getInsDebtAges()));
		
		vo.setOverdueDetailList(insOverdueDetailService.getOverdueDetailVoListByInsOverdueDetailList(insCommonExport.getBad_debt().getInsOverdueDetail()));
		
		vo.setBadAnalysisList(insBadAnalysisService.getBadAnalysisVoListByInsBadAnalysisList(insCommonExport.getBad_debt().getInsBadAnalysis()));
		
		insBadDebtService.accordingToInsBadDebtIntoBadDebtVo(vo, insCommonExport.getBad_debt());
		
		vo.setPastBadDetailList(insPastBadDetailService.getPastBadDetailVoListByInsPastBadDetailList(insCommonExport.getBad_debt().getInsPastBadDetail()));
		
		vo.setTopBuyersList(insTopBuyersService.getTopBuyersVoListBySpecialID(insCommonExport.getSpecial_credit_st_id()));
		
		vo.setArDebtorsList(insArDebtorsService.getArDebtorsVoListByCommon_export_id(insCommonExport.getSpecial_credit_st_id()));
	}

	/**
	 * <b>获取CommonExportVo_3根据企业短期出口id查询企业短期信息插入到CommonExportVo_3 </b> 
	 * 
	 * @param vo 企业短期出口辅助表
	 * @param ceID 企业短期出口id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getCommonExportVo_3BySpecial_id(CommonExportVo_3 vo, Long ceID) {
		SpecialCreditSt insCommonExport = getInsCommonExportBusiness(ceID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insCommonExport), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insCreditManagementService.accordingToInsCreditManagementIntoCommonExportVo_3(vo, insCommonExport.getCredit_management());
		vo.setManagerDetailList(insManagerDetailService.getManagerDetailVoListByInsManagerDetailList(insCommonExport.getCredit_management().getInsManagerDetail()));
		//TODO 投保单寄送信息未完善
	}

	/**
	 * <b>根据Vo及企业短期出口ID更新CommonExportVo_1数据 </b> 
	 * 
	 * @param vo
	 * @param special_id 企业短期出口id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheCommonExportVo_1SetUpInsCommonExport(
			CommonExportVo_1 vo, Long special_id) {
		SpecialCreditSt insCommonExport = getInsCommonExportBusiness(special_id);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insCommonExport);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insServiceDescriptionService.accordingToTheCommonExportVo_1SetUpInsServiceDescription(vo, insCommonExport.getService_description().getSt_service_description_id());
		insTurnoverService.accordingToTheCommonExportVo_1SetUpInsTurnover(vo, insCommonExport.getTurnover().getSt_turnover_id());
		/** 预计未来一年内所须投保的信用销售总额（按国别分类） */
		insForecastedDetailService.setForecastedDetailByForecastedDetailVo(vo.getForecastedDetailList(), insCommonExport.getTurnover().getSt_turnover_id());
		/** 最近三年销售记录表 */
		insRecentYearsSellService.setRecentYearsSellByRecentYearsSellVo(vo.getRecentYearsSellList(), insCommonExport.getTurnover().getSt_turnover_id());
		
		dao.updateById(insCommonExport);
		
	}

	/**
	 * <b>根据Vo及企业短期出口ID更新CommonExportVo_2数据 </b> 
	 * 
	 * @param vo
	 * @param special_id 企业短期出口id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheCommonExportVo_2SetUpInsCommonExport(
			CommonExportVo_2 vo, Long special_id) {
		SpecialCreditSt insCommonExport = getInsCommonExportBusiness(special_id);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insCommonExport);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		insDebtAgesService.setDebtAgesByDebtAgesVo(vo.getDebtAgesList(), insCommonExport.getBad_debt().getSt_bad_debt_id());
		
		insOverdueDetailService.setOverdueDetailByOverdueDetailVo(vo.getOverdueDetailList(), insCommonExport.getBad_debt().getSt_bad_debt_id());
		
		insBadAnalysisService.setBadAnalysisByBadAnalysisVo(vo.getBadAnalysisList(), insCommonExport.getBad_debt().getSt_bad_debt_id());
		
		insBadDebtService.accordingToTheCommonExportVo_2SetUpInsBadDebt(vo, insCommonExport.getBad_debt().getSt_bad_debt_id());
		
		insPastBadDetailService.setPastBadDetailByPastBadDetailVo(vo.getPastBadDetailList(), insCommonExport.getBad_debt().getSt_bad_debt_id());
		
		insTopBuyersService.setTopBuyersByTopBuyersVo(vo.getTopBuyersList(), insCommonExport.getSpecial_credit_st_id());
		
		insArDebtorsService.setArDebtorsByArDebtorsVo(vo.getArDebtorsList(), insCommonExport.getSpecial_credit_st_id());
		
		dao.updateById(insCommonExport);
		
	}

	/**
	 * <b>根据Vo及企业短期出口ID更新CommonExportVo_3数据 </b> 
	 * 
	 * @param vo
	 * @param special_id 企业短期出口id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheCommonExportVo_3SetUpInsCommonExport(
			CommonExportVo_3 vo, Long special_id) {
		SpecialCreditSt insCommonExport = getInsCommonExportBusiness(special_id);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insCommonExport);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insCreditManagementService.accordingToTheCommonExportVo_3SetUpInsCreditManagement(vo, insCommonExport.getCredit_management().getSt_credit_management_id());
		insManagerDetailService.setManagerDetailByManagerDetailVo(vo.getManagerDetailList(), insCommonExport.getCredit_management().getSt_credit_management_id());
		dao.updateById(insCommonExport);
		
	}


}
