package com.bcxin.ins.models.order.policy.service;

import com.bcxin.ins.entity.policy_core.InsShipReceive;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.mybatisplus.service.IService;

import java.util.List;


public interface ShipReceiveService extends IService<InsShipReceive> {
	
	/** 根据ID获取应收
	 * 	没取到返回null
	 * */
	public InsShipReceive getShipReceiveById(Long id);

	/** 根据出运ID获取应收
	 * 	没取到返回null
	 * */
	public InsShipReceive getShipReceiveByShipDeclareId(Long shipDeclareId);

	/**
	 * 获取应收首页可以用于应收的OrderFormVo；
	 * 根据应收表的外键获取到对应的orderForm
	 * @return
	 */
	public List<OrderFormVo> getReceiveIndexList(Long userId, DwzPage page);
	
}
