package com.bcxin.ins.models.order.policy.dao;

import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.OrderFormDetailsVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.OrderStatusCountVo;
import com.bcxin.ins.vo.excel.PolicyExcelVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import com.bcxin.mybatisplus.plugins.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
 * <b>投保单主表数据访问 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:43:31
 * @注意事项 </b>
 * <b>
 */
@MyBatisDao
public interface InsInsuranceSlipDao extends BaseMapper<InsInsuranceSlip> {

	public InsInsuranceSlip selectById(@Param("id") Long id);

	InsInsuranceSlip selectByTradeSerialNumber(@Param("tradeSerialNumber") String tradeSerialNumber);

	/**
	 * <b>根据前台用户id跟订单状态查询订单并进行分页 </b>
	 *
	 * @param userId
	 * @param status
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatus(Page<InsInsuranceSlip> page, @Param("userId") Long userId, @Param("status") String status);

	/**
	 * <b>根据前台用户id跟订单状态列表查询订单并进行分页 </b>
	 *
	 * @param userId
	 * @param statusList
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatusList(Page<InsInsuranceSlip> pageHelper,@Param("userId") Long userId, @Param("statusList") List<String> statusList);

	/**
	 * <b>根据前台用户id查找对应订单所有状态的总条目 </b>
	 *
	 * @param
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午9:59:47
	 * @注意事项 </b>
	 * <b>
	 */
	OrderStatusCountVo selectOrderStatusCountVoByUserID(@Param("userId") Long userId);

	/**
	 * <b>查询所有订单</b>
	 *
	 * @param sql
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月12日 上午9:53:46
	 * @注意事项 </b>
	 * <b>
	 */
	List<InsInsuranceSlip> findAllInsOrderList(String sql);



	/**
	 * <b>查询所有订单 </b>
	 *
	 * @param
	 * @return
	 * @author liyongqiang
	 * @date 2017年2月9日 下午1:32:57
	 * @注意事项 </b>
	 * <b>
	 */
	List<OrderFormVo> findInsOrderForm();

	/**
	 * <b>查询所有有效但未同步到支撑的订单 </b>
	 *
	 * @param
	 * @return
	 * @author zxf
	 * @date 2017年7月5日 下午16:32:57
	 * @注意事项 </b>
	 * <b>
	 */
	List<OrderFormVo> findInsOrderFormByUnSync();

	/**
	 * <b>查询所有订单 </b>
	 *
	 * @param
	 * @return
	 * @author liyongqiang
	 * @date 2017年2月9日 下午1:32:57
	 * @注意事项 </b>
	 * <b>
	 */
	List<Map<Object,Object>> findInsOrderFormByKeyword(Map<Object,Object> p);
	int findInsOrderFormByKeywordCnt(Map<Object,Object> p);

	/**
	 * <b>根据供应商查询所有订单 </b>
	 *
	 * @param
	 * @return
	 * @author liyongqiang
	 * @date 2017年2月9日 下午1:32:57
	 * @注意事项 </b>
	 * <b>
	 */
	List<OrderFormVo> findInsOrderFormBySup(@Param("sup_id") String sup_id);


	List<OrderFormVo> getLawsuitList();


	/**
	 * 通过订单Id查询诉讼详情---用于核保
	 * @param id
	 * @return
	 */
	OrderFormDetailsVo selectByInsOrderFormVo(Long id);

	/**
	 * <b>根据订单id查找对应OrderFormVo信息 </b>
	 *
	 * @param id
	 * @param userId
	 * @param statusList
	 * @param status
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午9:59:47
	 * @注意事项 </b>
	 * <b>
	 */
	List<OrderFormVo> findOrderFormVoByID(@Param("id") Long id,@Param("userId") Long userId, @Param("statusList") List<String> statusList, @Param("status") String status);

	OrderFormVo getOrderFormVoByID(@Param("order_id") Long order_id);

	/**
	 * <b> 查询所有在保保单信息 </b>
	 * @author ZXF
	 * @create 2020/09/18 0018 10:26
	 * @version
	 * @注意事项 </b>
	 */
	List<PolicyExcelVo> downAllPolicy();


}
