package com.bcxin.tenant.domain.readers.criterias;

import com.bcxin.Infrastructures.CriteriaAbstract;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import lombok.Getter;

import java.util.Collection;

@Getter
public class OrganizationCriteria extends CriteriaAbstract {
    private final Collection<ApprovedStatus> statuses;
    private final String name;

    public OrganizationCriteria(String name, Collection<ApprovedStatus> statuses, int pageIndex, int pageSize) {
        super(pageIndex, pageSize);
        this.statuses = statuses;
        this.name = name;
    }

    public static OrganizationCriteria create(String name,Collection<ApprovedStatus> statuses,int pageIndex, int pageSize) {
        return new OrganizationCriteria(name, statuses, pageIndex, pageSize);
    }
}
