package com.bcxin.tenant.domain.exceptions;

import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.Infrastructures.exceptions.UnexpectedTenantException;
import com.bcxin.tenant.domain.DomainConstraint;

public final class TenantExceptionConverter {
    public static TenantExceptionAbstract cast(Exception ex) {
        if (DomainConstraint.isUniqueConstraintIssue(ex)) {
            return new ConflictTenantException(ex.getMessage(), ex);
        } else {
            if (ex instanceof TenantExceptionAbstract) {
                return (TenantExceptionAbstract) ex;
            }

            return new UnexpectedTenantException(ex.getMessage(), ex);
        }
    }
}
