package com.bcxin.tenant.domain.entities.valueTypes;

import com.bcxin.Infrastructures.entities.ValueType;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;

@Embeddable
@Getter
@Setter(AccessLevel.PROTECTED)
public class LocationValueType extends ValueType {
    /**
     * 省份编码
     */
    @Column(length = 50, name = "provider")
    private ItemValueType province;

    /**
     * 城市编码
     */
    @Column(length = 50, name = "city")
    private ItemValueType city;

    /**
     * 区域编码
     */
    @Column(length = 50, name = "district")
    private ItemValueType district;

    /**
     * 详细地址
     */
    @Column(length = 200)
    private String address;

    protected LocationValueType(ItemValueType province, ItemValueType city, ItemValueType district, String address) {
        this.setProvince(province);
        this.setCity(city);
        this.setDistrict(district);
        this.setAddress(address);
    }

    protected LocationValueType() {

    }

    public static LocationValueType create(ItemValueType province, ItemValueType city, ItemValueType district, String address) {
        LocationValueType locationValueType = new LocationValueType(province, city, district,address);

        return locationValueType;
    }

    @Transient
    public String getShortLocation() {
        StringBuilder sb = new StringBuilder();
        if (this.getProvince() != null) {
            sb.append(this.getProvince().getName());
        }

        if (this.getCity() != null) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getCity().getName());
        }

        if (this.getDistrict() != null) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getDistrict().getName());
        }

        return sb.toString();
    }
}
