package com.bcxin.tenant.domain.entities;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

/**
 * @description 个税
 */
@Entity
@Data
@Table(name="salary_tax")
public class SalaryTax implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)//主键生成策略
    @Column(name="id")
    private Integer id;

    /**
    * 姓名 
    */
    @Column(name="name")
    private String name;

    /**
    * 证件号
    */
    @Column(name="certi_no")
    private String certiNo;
    /**
     * 员工号
     */
    @Column(name="employee_no")
    private String employeeNo;
    
    /**
     * 部门
     */
    @Column(name="dept")
    private String dept;


    /**
    * 应发工资
    */
    @Column(name="should_salary")
    private BigDecimal shouldSalary;
    /**
     * 个人社保合计
     */
    @Column(name="social_security")
    private BigDecimal socialSecurity;
    /**
     * 个人公积金合计
     */
    @Column(name="public_funds")
    private BigDecimal publicFunds;
    /**
     * 个税
     */
    @Column(name="tax")
    private BigDecimal tax;
    /**
     * 薪资组ID
     */
    @Column(name="group_Id")
    private Long groupId;
    /**
     * 月份
     */
    @Column(name="month")
    private String month;
    /**
     * 组织ID
     */
    @Column(name="org_id")
    private String orgId;

    /**
    * 创建时间
    */
    @Column(name="create_time", insertable = false)
    private Date createTime;

    public SalaryTax() {
    }

}