package com.bcxin.tenant.domain.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import lombok.Data;

/**
 * @description 薪资项分组
 * @author 
 */
@Entity
@Data
@Table(name="salary_item_group")
public class SalaryItemGroup implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)//主键生成策略
    /**
    * id
    */
    @Column(name="id")
    private Integer id;

    /**
    * 组名
    */
    @Column(name="name")
    private String name;
    
    /**
    *  是否显示 0 不显示 1 显示
    */
    @Column(name="state")
    private Integer state=1;
    
    /**
    *  是否可以删除 0 可以 1 不可以
    */
    @Column(name="sys_")
    private Integer sys_;
    
    @OneToMany(mappedBy = "itemGroup")
    private List<SalaryItem> salaryItems;
    
  

    public SalaryItemGroup() {
    }
}
