package com.bcxin.tenant.domain.entities;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

/**
 * @description 工资项
 */
@Entity
@Data
@Table(name="salary_item")
public class SalaryItem implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)//主键生成策略
    /**
    * id
    */
    @Column(name="id")
    private Long id;

    /**
    * 项目名称 
    */
    @Column(name="item")
    private String item;

    /**
    * 项目值 
    */
    @Column(name="item_value")
    private String itemValue;

   
    /**
    * 数据类型 1 数字 2 文本
    */
    @Column(name="data_type")
    private int dataType;

    /**
    * 所属项目组 
    */
    @Column(name="item_group")
    private String itemGroup;

    /**
    * 列表状态 0 不显示 1 显示
    */
    @Column(name="list_state")
    private int listState;
    
    /**
    * 工资单显示 0 不显示 1 显示
    */
    @Column(name="payroll_show")
    private int payrollShow;

    
    /**
    *    税前应发 税前应扣  税前其他 
    */
    @Column(name="tax_front_back")
    private String taxFrontBack;

    /**
    *  字段配置规则 
    */
    @Column(name="rule")
    private String rule;
    
    /**
    *  类别
    */
    @Column(name="category")
    private String category;
    
    /**
    * 0 正常 1 删除
    */
    @Column(name="deleted")
    private int deleted;


    /**
           *创建时间
    */
    @Column(name="create_time",insertable=false)
    private Date createTime;

    /**
    * 修改时间
    */
    @Column(name="update_time",updatable=false)
    private Date updateTime;
    
    /**
           *     排序
    */
    @Column(name="sort")
    private Integer sort;
    /**
     *     显示上期工资 0 不显示 1 显示
*/
    @Column(name="show_last_salary")
    private Integer showLastSalary;
    /**
     * 差异金额
     */
    @Column(name="diff_money")
    private BigDecimal diffMoney=new BigDecimal("0.00");
    /**
     * 类型
     */
    @Column(name="type")
    private String type;

    public SalaryItem() {
    }

}