package com.bcxin.tenant.domain.entities;

import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

import com.bcxin.Infrastructures.components.models.ExcelModelAbstract;

import lombok.Data;
/**
 * 批量导入工资模板
 *
 */
@Entity
@Data
public class SalaryImportRecord extends ExcelModelAbstract{
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)//主键生成策略
    private Long id;
    //姓名（*）
    private String name;
    //员工编号
    private String employeeNo;
    // 证件类型
    private String certiType;
    // 证件号码
    private String certiNo;
    // 银行卡
    private String bankNo;
    //开户银行
    private String bank;
    //开户地（省）
    private String province;
    //开户地（市）
    private String city;
    //手机号
    private String phone;
    //邮箱地址
    private String email;
    
    //所属部门
    private String dept;
    //所属级别
    private String level;
    //系数
    private String ratio;
    //备注
    private String  remark;
    //说明
    private String notes;
    //实发金额（*）
    private BigDecimal actualSalary;
    
    /**应发项*/
    //基本工资
    private BigDecimal basicSalary;
    // 交通补助
    private BigDecimal trafficSubsidy;
    //餐费补贴
    private BigDecimal mealSubsidy;
    //住房补贴
    private BigDecimal houseSubsidy;
    //司龄工资
    private BigDecimal ageSalary;
    
    /**应扣项*/
    //个税
    private BigDecimal tax;
    //社保
    private BigDecimal socialSecurity;
    //公积金扣款
    private BigDecimal fund;
    
    /**企业社保公积金项*/
    //企业基本养老保险
    private BigDecimal oldIns;
    //企业基本医疗保险
    private BigDecimal medicalIns;
    //企业失业保险
    private BigDecimal workIns;
    //企业工伤保险
    private BigDecimal injuryIns;
    //企业生育保险
    private BigDecimal birthIns;
    //企业公积金
    private BigDecimal entFund;
    /**个税扣缴项*/
    //累计子女教育
    private BigDecimal childEdu;
    //累计住房租金
    private BigDecimal houseRent;
    //累计住房贷款利息
    private BigDecimal houseIoan;
    //累计赡养老人
    private BigDecimal careOlder;
    //累计继续教育
    private BigDecimal reEdu;
    //个税差额扣除
    private BigDecimal taxDeduct;
    //累计应纳税所得额
    private BigDecimal getShouldTax;
    //累计应纳税额
    private BigDecimal shouldTax;
    //累计减免税额
    private BigDecimal totalDeduct;
    //累计应扣缴税额
    private BigDecimal totalShouldDeduct;
    //累计已缴税额
    private BigDecimal totalPayed;
    
    /**出勤统计（天)*/
    // 请年假
    private Integer yearVacationDay;
    //病假
    private Integer illVacationDay;
    //请事假
    private Integer eventVacationDay;
    //旷工
    private Integer absentDay;
    //调休
    private Integer exchangeDay;
    //出勤
    private Integer workDay;
    
    // 加班统计（小时）
    
    //工作
    private Integer overtimeWorkHour;
    //非节假日
    private Integer overtimeNonHoliHour;
    //节假日
    private Integer overtimeHoliHour;
    
    // 其他项目
    private String other1;
    // 其他项目
    private String other2;
    
    @Column(insertable = false)
    private Date createTime;
    
    
    @Column(name = "deleted")
    private int deleted;
}
