package com.bcxin.tenant.domain.entities;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

@Entity
@Data
@Table(name="salary_config")
public class SalaryConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    /**
    * id
    */
    @Column(name="id")
    @GeneratedValue(strategy=GenerationType.IDENTITY)//主键生成策略
    private Long id;


    /**
    * 键名称 
    */
    @Column(name="name")
    private String name;

    /**
    * 值 
    */
    @Column(name="value")
    private String value;

    /**
    * 类型 1 数值 2 文本 
    */
    @Column(name="type")
    private String type;

    /**
    * 补充字段 
    */
    @Column(name="extra")
    private String extra;

    /**
    * 备注 
    */
    @Column(name="remark")
    private String remark;

    /**
    * 状态 0 删除 1正常
    */
    @Column(name="state")
    private Integer state;

    /**
    * 添加时间
    */
    @Column(name="create_time",insertable=false)
    private Date createTime;

    /**
    * 更新时间
    */
    @Column(name="update_time")
    private Date updateTime;

    public SalaryConfig() {
    }

}
