package com.bcxin.tenant.domain.entities;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

@Entity
@Data
@Table(name="salary_cal_record")
public class SalaryCalRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)//主键生成策略
    /**
    * id
    */
    @Column(name="id")
    private Long id;

    /**
    * 员工号  
    */
    @Column(name="employee_no")
    private String employeeNo;

    /**
    * 姓名  
    */
    @Column(name="name")
    private String name;

    /**
    * 所属薪资组id
    */
    @Column(name="group_id")
    private Long groupId;

    /**
    * 应发工资
    */
    @Column(name="should_salary")
    private BigDecimal shouldSalary;

    /**
    * 创建时间
    */
    @Column(name="create_time")
    private Date createTime;

    /**
    * 更新时间
    */
    @Column(name="update_time")
    private Date updateTime;

    /**
    * 部门  
    */
    @Column(name="dept")
    private String dept;

    /**
    * 岗位  
    */
    @Column(name="post")
    private String post;
    
    
    /**
    * 月份
    */
    @Column(name="month")
    private String month;

    public SalaryCalRecord() {
    }

}