package com.bcxin.tenant.domain.entities;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

/**
 * @description 考勤
 */
@Entity
@Data
@Table(name="salary_attendance")
public class SalaryAttendance implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)//主键生成策略
    /**
    * id
    */
    @Column(name="id")
    private Integer id;

    /**
    * 姓名 
    */
    @Column(name="name")
    private String name;

    /**
    * 员工号 
    */
    @Column(name="employee_no")
    private String employeeNo;
    /**
     * 部门
     */
    @Column(name="dept")
    private String dept;

    /**
    * 入离职缺勤天数
    */
    @Column(name="lost_day")
    private Integer lostDay;

    /**
    * 实际出勤天数
    */
    @Column(name="actual_day")
    private Integer actualDay;
    /**
     *  应出勤天数
     */
    @Column(name="should_day")
    private Integer shouldDay;
    /**
     * 薪资组ID
     */
    @Column(name="group_Id")
    private Long groupId;
    /**
     * 月份
     */
    @Column(name="month")
    private String month;
    /**
     * 组织ID
     */
    @Column(name="org_id")
    private String orgId;

    /**
    * 创建时间
    */
    @Column(name="create_time", insertable = false)
    private Date createTime;

    public SalaryAttendance() {
    }

}