package com.bcxin.tenant.domain;

import com.bcxin.Infrastructures.utils.ExceptionUtil;

import java.util.ArrayList;
import java.util.Collection;

public final class DomainConstraint {
    public static final String UNIQUE_ORGANIZATION_NAME = "unique_organization_name";

    public static final String UNIQUE_TENANT_USER_TELEPHONE = "unique_tenant_user_telephone";

    public static final String UNIQUE_DOMAIN_USER_LOGIN_NO = "unique_domain_id_loginno";

    public static final String UNIQUE_ORGANIZATION_ID_DEPARTMENT_NAME="unique_organization_id_department_name";

    public static final String UNIQUE_ORGANIZATION_EMPLOYEE_STATUS="unique_organization_employee_status";

    public static final String UNIQUE_TENANT_USER_CREDENTIAL_NUMBER = "unique_tenant_user_credential_number";

    public static final String PK_INDEX_FOR_MPP_DB_BUSINESS="tenant_unique_data_constraints.PRIMARY";

    public static final String PK_UNIQUE_DATA_CONSTRAINT_COMBINE_ID_PREFIX="PK_UNIQUE_DATA_";

    public static final String UNIQUE_DEPARTMENT_EMPLOYEE_RELATION_DEPARTMENT_EMPLOYEE = "unique_department_employee_relation_department_id_employee_id";

    public static final String UNIQUE_TENANT_EMPLOYEE_RELATIONS_TENANT_USER_ID_ORGANIZATION_ID="unique_tenant_employee_relations_tenant_user_id_organization_id";

    private static final Collection<String> unique_issues = new ArrayList<>();
    static
    {
        unique_issues.add(UNIQUE_ORGANIZATION_NAME);
        unique_issues.add(UNIQUE_TENANT_USER_TELEPHONE);
        unique_issues.add(UNIQUE_ORGANIZATION_ID_DEPARTMENT_NAME);
        unique_issues.add(UNIQUE_TENANT_EMPLOYEE_RELATIONS_TENANT_USER_ID_ORGANIZATION_ID);
        unique_issues.add(PK_INDEX_FOR_MPP_DB_BUSINESS);
        unique_issues.add(UNIQUE_TENANT_USER_CREDENTIAL_NUMBER);
        unique_issues.add(UNIQUE_ORGANIZATION_EMPLOYEE_STATUS);
        unique_issues.add(UNIQUE_DOMAIN_USER_LOGIN_NO);
    }
    public static boolean isUniqueConstraintIssue(Exception ex) {
        String detailMsg = ExceptionUtil.getStackMessage(ex);
        return unique_issues.stream().anyMatch(ii -> detailMsg.contains(ii) ||
                detailMsg.contains(PK_UNIQUE_DATA_CONSTRAINT_COMBINE_ID_PREFIX));
    }
}
