package com.bcxin.registration.nacos;
import com.zaxxer.hikari.HikariDataSource;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;

@Data
@Component
@ConfigurationProperties("spring.datasource")
public class NacosDataSourceConfig {
    private String driverClassName;
    private String url;
    private String userName;
    private String password;

    @Primary
    @Bean("dataSource")
    public DataSource dataSource() {
        System.err.println(String.format("NacosDataSourceConfig:%s", this.url));
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setJdbcUrl(this.url);
        dataSource.setUsername(userName);
        dataSource.setPassword(password);
        dataSource.setDriverClassName(driverClassName);

        return dataSource;
    }
}
