/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.infrastructure.offices.impls;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.bcxin.Infrastructures.components.ExcelProvider;
import com.bcxin.Infrastructures.components.models.ExcelModelAbstract;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.infrastructure.offices.impls.ExcelDataAnalysisEventListener;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.stereotype.Component;

@Component
public class ExcelProviderImpl
implements ExcelProvider {
    public Collection<Map<Integer, String>> read(InputStream reader, Map<String, Object> attributes) {
        ExcelReaderBuilder builder = EasyExcel.read((InputStream)reader);
        ExcelReaderSheetBuilder sheetBuilder = this.buildSheetName(this.build(builder, attributes), attributes);
        return sheetBuilder.doReadSync();
    }

    public <T extends ExcelModelAbstract> Collection<T> read(InputStream reader, Class<T> tClass) {
        return EasyExcel.read((InputStream)reader).sheet().doReadSync();
    }

    public <T extends ExcelModelAbstract> Collection<T> read(InputStream reader, Class<T> tClass, String sheetName) {
        List data = EasyExcel.read((InputStream)reader).sheet(sheetName).doReadSync();
        return data;
    }

    public <T extends ExcelModelAbstract> void read(InputStream reader, Class<T> tClass, String sheetName, Consumer<List<T>> consumer) {
        EasyExcel.read((InputStream)reader, tClass, new ExcelDataAnalysisEventListener(consumer, 1000)).sheet(sheetName).doRead();
    }

    public <T extends ExcelModelAbstract> void read(InputStream reader, Class<T> tClass, int pageSize, Consumer<List<T>> consumer) {
        EasyExcel.read((InputStream)reader, tClass, new ExcelDataAnalysisEventListener(consumer, pageSize)).sheet().doRead();
    }

    public <T extends ExcelModelAbstract> void read(InputStream reader, Class<T> tClass, int pageSize, Consumer<List<T>> consumer, int rowNum) {
        ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)reader, tClass, new ExcelDataAnalysisEventListener(consumer, pageSize)).sheet().headRowNumber(Integer.valueOf(rowNum))).doRead();
    }

    private ExcelReaderBuilder build(ExcelReaderBuilder builder, Map<String, Object> attributes) {
        if (attributes != null) {
            Iterator<String> iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                switch (key = iterator.next()) {
                    case "ATTRIBUTE_HEADER_ROW_COUNT": {
                        Object headerRowCount = attributes.get("ATTRIBUTE_HEADER_ROW_COUNT");
                        if (headerRowCount instanceof Integer) {
                            builder = (ExcelReaderBuilder)builder.headRowNumber(Integer.valueOf((Integer)headerRowCount));
                            break;
                        }
                        throw new BadTenantException(String.format("Excel\u5934\u6570\u91cf(%s)\u4fe1\u606f\u8bbe\u7f6e\u65e0\u6548!", headerRowCount));
                    }
                }
            }
        }
        return builder;
    }

    private ExcelReaderSheetBuilder buildSheetName(ExcelReaderBuilder builder, Map<String, Object> attributes) {
        Object sheetName;
        if (attributes != null && (sheetName = attributes.get("ATTRIBUTE_SHEET_NAME")) != null) {
            return builder.sheet(String.valueOf(sheetName));
        }
        return builder.sheet();
    }
}

