/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.common.utils.security;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BtoaEncode {
    private static String base64hash = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public static boolean isMatcher(String inStr, String reg) {
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(inStr);
        return matcher.matches();
    }

    public static String btoa(String inStr) {
        if (inStr == null || BtoaEncode.isMatcher(inStr, "([^\\u0000-\\u00ff])")) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int mod = 0;
        int prev = 0;
        for (int i = 0; i < inStr.length(); ++i) {
            char ascii = inStr.charAt(i);
            mod = i % 3;
            switch (mod) {
                case 0: {
                    result.append(String.valueOf(base64hash.charAt(ascii >> 2)));
                    break;
                }
                case 1: {
                    result.append(String.valueOf(base64hash.charAt((prev & 3) << 4 | ascii >> 4)));
                    break;
                }
                case 2: {
                    result.append(String.valueOf(base64hash.charAt((prev & 0xF) << 2 | ascii >> 6)));
                    result.append(String.valueOf(base64hash.charAt(ascii & 0x3F)));
                }
            }
            prev = ascii;
        }
        if (mod == 0) {
            result.append(String.valueOf(base64hash.charAt((prev & 3) << 4)));
            result.append("==");
        } else if (mod == 1) {
            result.append(String.valueOf(base64hash.charAt((prev & 0xF) << 2)));
            result.append("=");
        }
        return result.toString();
    }

    public static String atob(String inStr) {
        if (inStr == null) {
            return null;
        }
        inStr = inStr.replaceAll("\\s|=", "");
        StringBuilder result = new StringBuilder();
        int prev = -1;
        for (int i = 0; i < inStr.length(); ++i) {
            int cur = base64hash.indexOf(inStr.charAt(i));
            int mod = i % 4;
            switch (mod) {
                case 0: {
                    break;
                }
                case 1: {
                    result.append(String.valueOf((char)(prev << 2 | cur >> 4)));
                    break;
                }
                case 2: {
                    result.append(String.valueOf((char)((prev & 0xF) << 4 | cur >> 2)));
                    break;
                }
                case 3: {
                    result.append(String.valueOf((char)((prev & 3) << 6 | cur)));
                }
            }
            prev = cur;
        }
        return result.toString();
    }

    public static String encryption(String str) {
        try {
            String encode = URLEncoder.encode(str, "utf-8");
            encode = encode.replaceAll("\\+", "%20");
            String btoa = BtoaEncode.btoa(encode);
            return btoa;
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("btoa\u52a0\u5bc6\u51fd\u6570\u51fa\u73b0\u9519\u8bef\u3002");
            return str;
        }
    }

    public static String decrypt(String str) {
        String atob = BtoaEncode.atob(str);
        try {
            String decode = URLDecoder.decode(atob, "utf-8");
            return decode;
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("atob\u52a0\u5bc6\u51fd\u6570\u51fa\u73b0\u9519\u8bef\u3002");
            return str;
        }
    }

    public static void main(String[] args) {
        String admin = BtoaEncode.encryption("SELECT * FROM sb_personcertificate where Cardnumber='142729198406131810'");
        System.out.println(admin);
        System.out.println(BtoaEncode.decrypt(admin));
    }
}

