/*
 * Decompiled with CFR 0.152.
 */
package com.wlsk.plugin.qiniu.bl.impl;

import cn.hutool.core.util.RandomUtil;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.wlsk.plugin.qiniu.bl.QiniuService;
import com.wlsk.plugin.qiniu.config.PluginQiNiuOssConfig;
import com.wlsk.plugin.qiniu.domain.model.OssInfoVo;
import com.wlsk.plugin.qiniu.route.QiniuRoute;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class QiniuServiceImpl
implements QiniuService {
    private static final Logger log = LoggerFactory.getLogger(QiniuServiceImpl.class);
    @Autowired
    private PluginQiNiuOssConfig pluginQiNiuOssConfig;
    @Autowired
    private QiniuRoute qiniuRoute;

    @Override
    public String getUploadToken() {
        Auth auth = this.qiniuRoute.initAuth(this.pluginQiNiuOssConfig.getAccessKey(), this.pluginQiNiuOssConfig.getSecretKey());
        String bucketName = this.pluginQiNiuOssConfig.getBucket();
        bucketName = this.qiniuRoute.initBucket(bucketName);
        return auth.uploadToken(bucketName);
    }

    @Override
    public String getBasePath() {
        return this.pluginQiNiuOssConfig.getDomain();
    }

    @Override
    public OssInfoVo upload(MultipartFile file) {
        String suffix = Objects.requireNonNull(file.getOriginalFilename()).substring(file.getOriginalFilename().lastIndexOf("."));
        String fileName = RandomUtil.randomNumbers((int)32) + suffix;
        try {
            return this.qiniuRoute.upload(file.getInputStream(), fileName);
        }
        catch (IOException e) {
            log.error("upload failed : ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getUploadToken(String uuid, String fileName) {
        String accessKey = this.pluginQiNiuOssConfig.getAccessKey();
        String secretKey = this.pluginQiNiuOssConfig.getSecretKey();
        String bucket = this.pluginQiNiuOssConfig.getBucket();
        String domain = this.pluginQiNiuOssConfig.getDomain();
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        StringMap putPolicy = new StringMap();
        putPolicy.put("returnBody", (Object)"{\"key\":\"$(key)\",\"hash\":\"$(etag)\",\"bucket\":\"$(bucket)\",\"fsize\":$(fsize)}");
        return auth.uploadToken(bucket + ":" + fileName, null, 3600L, putPolicy);
    }
}

