/*
 * Decompiled with CFR 0.152.
 */
package com.wlsk.plugin.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.json.JSONUtil;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class ExceptionUtil {
    protected static final Logger log = LoggerFactory.getLogger((String)"GlobalExceptionHandler");

    private ExceptionUtil() {
    }

    public static void printErrorLog(Exception e, HttpServletRequest request, String errorTitle, Environment environment) {
        String method = request.getMethod();
        Map paramMap = ServletUtil.getParamMap((ServletRequest)request);
        String jsonBody = null;
        if (request instanceof ContentCachingRequestWrapper) {
            ContentCachingRequestWrapper wrapper = (ContentCachingRequestWrapper)request;
            jsonBody = StringUtils.toEncodedString((byte[])wrapper.getContentAsByteArray(), (Charset)Charset.forName(wrapper.getCharacterEncoding()));
        }
        String applicationName = environment.getProperty("spring.application.name", "default-app");
        String applicationEnv = ExceptionUtil.getEnv(environment);
        String isEnableNotice = environment.getProperty("feishu.notice", "true");
        StringBuilder errorBuilder = new StringBuilder("\u3010" + applicationName + "\u3011");
        errorBuilder.append("\n ").append(errorTitle).append(" \u3010").append(applicationEnv).append("\u3011");
        errorBuilder.append("\n \u8bf7\u6c42\u5730\u5740\uff1a").append(request.getRequestURL());
        errorBuilder.append("\n \u8bf7\u6c42\u65b9\u5f0f\uff1a[").append(method).append("]");
        errorBuilder.append("\n \u8bf7\u6c42\u65f6\u95f4\uff1a").append(DateUtil.now());
        errorBuilder.append("\n \u8bf7\u6c42\u53c2\u6570\uff1a");
        if (StringUtils.isBlank((CharSequence)jsonBody)) {
            errorBuilder.append("\n " + JSONUtil.toJsonStr((Object)paramMap));
        } else {
            errorBuilder.append("\n " + jsonBody);
        }
        String fullStackTrace = ExceptionUtils.getStackTrace((Throwable)e);
        if (fullStackTrace.length() > 3000) {
            fullStackTrace = fullStackTrace.substring(0, 3000);
        }
        errorBuilder.append("\n \u5f02\u5e38\u4fe1\u606f: " + fullStackTrace);
        log.error(errorBuilder.toString(), (Throwable)e);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("text", errorBuilder.toString());
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("msg_type", "text");
        resultMap.put("content", map);
    }

    public static void printErrorLog(HttpServletRequest request, String errorTitle, String projectUuid, String jobUuid, String requestParem, String response, Environment environment) {
        String applicationEnv = ExceptionUtil.getEnv(environment);
        String app = "java\u4ee3\u7801\u751f\u6210\u62a5\u9519\u4e86";
        StringBuilder errorBuilder = new StringBuilder("\u3010" + app + "\u3011");
        errorBuilder.append("\n ").append(errorTitle).append(" \u3010").append(applicationEnv).append("\u3011");
        errorBuilder.append("\n projectUuid\uff1a").append(projectUuid);
        errorBuilder.append("\n jobUuid\uff1a[").append(jobUuid).append("]");
        errorBuilder.append("\n \u8bf7\u6c42\u65f6\u95f4\uff1a").append(DateUtil.now());
        errorBuilder.append("\n requestParam\uff1a\n").append(requestParem);
        errorBuilder.append("\n response\uff1a\n").append(response);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("text", errorBuilder.toString());
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("msg_type", "text");
        resultMap.put("content", map);
        log.error(errorBuilder.toString());
    }

    public static String getEnv(Environment environment) {
        Object[] activeProfiles = environment.getActiveProfiles();
        Object activeEnv = "";
        activeEnv = ArrayUtils.isEmpty((Object[])activeProfiles) ? "dev" : activeProfiles[0];
        return activeEnv;
    }
}

