/*
 * Decompiled with CFR 0.152.
 */
package com.wlsk.plugin.exception;

import cn.hutool.extra.servlet.ServletUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.wlsk.plugin.domain.enums.CommonCode;
import com.wlsk.plugin.domain.vo.Result;
import com.wlsk.plugin.exception.BusinessException;
import com.wlsk.plugin.exception.InvalidTokenException;
import com.wlsk.plugin.utils.ExceptionUtil;
import java.nio.charset.Charset;
import java.sql.SQLSyntaxErrorException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.util.ContentCachingRequestWrapper;

public abstract class BaseExceptionHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Environment environment;

    @ExceptionHandler(value={Exception.class})
    public Result handleException(Exception e, HttpServletRequest request) {
        ExceptionUtil.printErrorLog(e, request, CommonCode.FAIL.message(), this.environment);
        return Result.FAIL(CommonCode.FAIL.code(), CommonCode.FAIL.message());
    }

    @ExceptionHandler(value={NullPointerException.class})
    public Result<?> nullPointerException(NullPointerException e, HttpServletRequest request) {
        ExceptionUtil.printErrorLog(e, request, CommonCode.NPE_FAIL.message(), this.environment);
        return Result.FAIL(CommonCode.NPE_FAIL.code(), CommonCode.NPE_FAIL.message());
    }

    @ExceptionHandler(value={InvalidTokenException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public Result handleInvalidTokenException(InvalidTokenException e) {
        this.log.error("token\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        return Result.tokenInvalid();
    }

    @ExceptionHandler(value={BusinessException.class})
    public Result handleBusinessException(BusinessException businessException, HttpServletRequest request) {
        Map paramMap = ServletUtil.getParamMap((ServletRequest)request);
        String jsonBody = "";
        String method = request.getMethod();
        if (request instanceof ContentCachingRequestWrapper) {
            ContentCachingRequestWrapper wrapper = (ContentCachingRequestWrapper)request;
            jsonBody = StringUtils.toEncodedString((byte[])wrapper.getContentAsByteArray(), (Charset)Charset.forName(wrapper.getCharacterEncoding()));
        }
        this.log.error("==========\u4e1a\u52a1\u5f02\u5e38=======>\u8bf7\u6c42\u5730\u5740\uff1a{},\u8bf7\u6c42\u65b9\u5f0f\uff1a[{}]\u53c2\u6570\uff1a[{}],\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{request.getRequestURL(), method, jsonBody.isEmpty() ? paramMap : jsonBody, businessException.getMessage()});
        Result<Object> result = businessException.resultCode != null ? Result.FAIL(businessException.resultCode.code(), businessException.resultCode.message()) : (businessException.getErrorCode() != null ? Result.FAIL(businessException.getErrorCode(), businessException.getErrorMsg()) : Result.FAIL(businessException.getErrorMsg()));
        return result;
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public Result<?> illegalArgumentException(IllegalArgumentException e) {
        this.log.error("\u975e\u6cd5\u53c2\u6570\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        return Result.FAIL(CommonCode.INVALID_PARAM.code(), e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public Result handleBindException(BindException e) {
        this.log.error("\u7ed1\u5b9a\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        StringBuilder message = new StringBuilder();
        List fieldErrors = e.getBindingResult().getFieldErrors();
        for (FieldError error : fieldErrors) {
            message.append(error.getField()).append(error.getDefaultMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        return Result.FAIL(CommonCode.INVALID_PARAM.code(), message.toString());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result handleConstraintViolationException(ConstraintViolationException e) {
        this.log.error("\u7ea6\u675f\u51b2\u7a81\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        StringBuilder message = new StringBuilder();
        Set violations = e.getConstraintViolations();
        for (ConstraintViolation violation : violations) {
            Path path = violation.getPropertyPath();
            String[] pathArr = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)path.toString(), (String)".");
            message.append(pathArr[1]).append(violation.getMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        return Result.FAIL(message.toString());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result handlerMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        this.log.error("\u7a0b\u5e8f\u65b9\u6cd5\u53c2\u6570\u65e0\u6548\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        StringBuilder message = new StringBuilder();
        for (FieldError error : e.getBindingResult().getFieldErrors()) {
            message.append(error.getField()).append(error.getDefaultMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        return Result.FAIL(CommonCode.INVALID_PARAM.code(), message.toString());
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Result handleHttpMediaTypeNotSupportedException(HttpMediaTypeNotSupportedException e) {
        String message = "\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301" + StringUtils.substringBetween((String)e.getMessage(), (String)"'", (String)"'") + "\u5a92\u4f53\u7c7b\u578b";
        this.log.error(message);
        return Result.FAIL(CommonCode.REQUEST_PARAM_TYPE_NOT_SUPPORTED.code(), message);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Result httpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        String message = "\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301" + StringUtils.substringBetween((String)e.getMessage(), (String)"'", (String)"'") + "\u8bf7\u6c42\u65b9\u6cd5";
        this.log.error(message);
        return Result.FAIL(CommonCode.REQUEST_METHOD_NOT_SUPPORTED.code(), CommonCode.REQUEST_METHOD_NOT_SUPPORTED.message());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Result httpMessageNotReadableException(HttpMessageNotReadableException e) {
        this.log.error("\u8bf7\u6c42\u683c\u5f0f\u4e0d\u6b63\u786e\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        Throwable cause = e.getCause();
        StringBuilder messageError = new StringBuilder();
        messageError.append("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        if (ObjectUtils.isNotEmpty((Object)cause) && cause instanceof JsonParseException) {
            messageError.append(",json\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\uff01");
        }
        return Result.FAIL(CommonCode.REQUEST_PARAM_TYPE_NOT_SUPPORTED.code(), messageError.toString());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Result missingServletRequestParameterException(MissingServletRequestParameterException e) {
        String parameterName = e.getParameterName();
        String message = "\u8bf7\u6c42\u53c2\u6570[" + parameterName + "]\u4e0d\u80fd\u4e3a\u7a7a !";
        return Result.FAIL(CommonCode.INVALID_PARAM.code(), message);
    }

    @ExceptionHandler(value={ClientAbortException.class})
    public Result clientAbortException(ClientAbortException e) {
        this.log.error("\u5ba2\u6237\u7aef\u4e2d\u6b62\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        return Result.FAIL(CommonCode.BROKEN_PIPE.code(), CommonCode.BROKEN_PIPE.message());
    }

    @ExceptionHandler(value={SQLSyntaxErrorException.class})
    public Result sQLSyntaxErrorException(SQLSyntaxErrorException e) {
        this.log.error("Sql\u8bed\u6cd5\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        return Result.FAIL(CommonCode.DATA_SOURCE_EXCEPTION.code(), "\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u914d\u7f6e\u53c2\u6570\uff01");
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public Result maxUploadSizeExceededException(MaxUploadSizeExceededException e) {
        this.log.error("\u6700\u5927\u4e0a\u4f20\u5927\u5c0f\u8d85\u51fa\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        return Result.FAIL(CommonCode.OVER_MAX_FILE_UPLOAD_SIZE.code(), CommonCode.OVER_MAX_FILE_UPLOAD_SIZE.message());
    }
}

