package com.bcxin.platform.web.controller.wallet;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.order.ComOrderPayDTO;
import com.bcxin.platform.service.wallet.ComWalletPaymentService;
import com.bcxin.platform.util.log.Log;
import com.bcxin.platform.web.controller.base.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <b> 企业钱包支付的controller层 </b>
 *
 * @author llc
 * @date 2020-01-15
 */

@RestController
@RequestMapping("/wallet/wallet-payment")
@Api(tags = {""}, description = "企业钱包支付")
public class ComWalletPaymentController extends BaseController {

    @Autowired
    private ComWalletPaymentService comWalletPaymentService;

    /**
     * 支付校验
     *
     * @return
     * @author llc
     * @date 2020-01-15
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业钱包支付", title = "支付校验", systemType = Log.SYSTEMTYPE_PHONE)
    @ApiOperation(value = "支付校验", httpMethod = "POST", notes = "支付校验", response = Result.class)
    @PostMapping(value = "pay-validate")
    public Result payValidate(@RequestBody ComOrderPayDTO dto) throws V5BusinessException {
        return comWalletPaymentService.payValidate(dto).setBack(getRequest());
    }

    /**
     * 获取支付手机号
     *
     * @return
     * @author llc
     * @date 2020-01-15
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业钱包支付", title = "获取支付手机号", systemType = Log.SYSTEMTYPE_PHONE)
    @ApiOperation(value = "获取支付手机号", httpMethod = "POST", notes = "获取支付手机号", response = Result.class)
    @PostMapping(value = "get-pay-phone")
    public Result getPayPhone(ComOrderPayDTO dto) throws V5BusinessException {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return comWalletPaymentService.getPayPhone(dto).setBack(getRequest());
    }

    /**
     * 发送支付验证码
     *
     * @return
     * @author llc
     * @date 2020-01-15
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业钱包支付", title = "发送支付验证码", systemType = Log.SYSTEMTYPE_PHONE)
    @ApiOperation(value = "发送支付验证码", httpMethod = "POST", notes = "发送支付验证码", response = Result.class)
    @PostMapping(value = "send-pay-verifycode")
    public Result sendPayVerifyCode(ComOrderPayDTO dto) throws V5BusinessException {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return comWalletPaymentService.sendPayVerifyCode(dto).setBack(getRequest());
    }


    /**
     * 支付
     *
     * @return
     * @author llc
     * @date 2020-01-15
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业钱包支付", title = "支付", systemType = Log.SYSTEMTYPE_PHONE)
    @ApiOperation(value = "支付", httpMethod = "POST", notes = "支付", response = Result.class)
    @PostMapping(value = "actual-pay")
    public Result actualPay(@RequestBody ComOrderPayDTO dto) throws V5BusinessException {
        return comWalletPaymentService.actualPay(dto).setBack(getRequest());
    }

}
