package com.bcxin.platform.web.controller.system;

import java.util.List;

import com.bcxin.platform.domain.system.SysRegion;
import com.bcxin.platform.service.system.ISysRegionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import com.bcxin.platform.common.core.controller.BaseController;

/**
 * 地区Controller
 * 
 * @author task
 * @date 2021-01-22
 */
@Controller
@RequestMapping("/region")
public class SysRegionController extends BaseController
{
    private String prefix = "region";

    @Autowired
    private ISysRegionService sysRegionService;

    /**
     * 查询地区列表
     */
    @PostMapping("/list")
    @ResponseBody
    public List<SysRegion> list(SysRegion sysRegion)
    {
        return sysRegionService.selectSysRegionList(sysRegion);
    }

    /**
     * 查询地区列表
     */
    @PostMapping("/getRegions")
    @ResponseBody
    public Object getRegions() {
        return sysRegionService.getRegions();
    }

}
