package com.bcxin.platform.web.controller.product;

import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.product.ConfigProductCategoryDto;
import com.bcxin.platform.dto.product.ProductQueryDto;
import com.bcxin.platform.service.product.ConfigProductService;
import com.bcxin.platform.util.log.Log;
import com.bcxin.platform.web.controller.base.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 配置产品的controller层
 * by llc 2020-01-15
 */
@RestController
@RequestMapping("/product")
@Api(tags = { "" }, description = "产品管理")
public class ConfigProductController extends BaseController {

	@Autowired
	private ConfigProductService configProductService;


	/**
	 * 获取产品列表
	 * @return
	 * @author llc
	 * @date 2020-01-15
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "获取产品列表", title = "获取产品列表", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "获取产品列表", httpMethod = "POST", notes = "获取产品列表", response = ConfigProductCategoryDto.class)
	@PostMapping(value = "get-product-list")
	public Result getProductList(ProductQueryDto dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return configProductService.getProductList(dto).setBack(getRequest());
	}




}
