package com.bcxin.platform.web.controller.manage.wallet;

import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.page.PageDomain;
import com.bcxin.platform.common.core.page.TableSupport;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.ShiroUtils;
import com.bcxin.platform.domain.wallet.PerWalletAccount;
import com.bcxin.platform.dto.SearchParamDTO;
import com.bcxin.platform.service.wallet.manage.PerWalletManageService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

/**
 * <b> 个人钱包信息 </b>
 * @author ZXF
 * @create 2019/09/02 0002 10:28
 * @version
 * @注意事项 </b>
 */
@Controller
@RequestMapping("/manage/per-wallet")
public class PerWalletManageController extends BaseController {

    private String prefix = "manage/per-wallet";

    @Autowired
    private PerWalletManageService perWalletService;

    /**
     * 跳转企业钱包信息列表
     * @return
     */
    @RequiresPermissions("per-wallet:view")
    @GetMapping("/per-wallet-list-view")
    public String perWalletListView() {
        return prefix + "/perWalletList";
    }

    /**
     * 跳转企业账户信息
     * @return
     */
    @GetMapping("/per-wallet-account-view/{perId}")
    public String perWalletAccountView(@PathVariable("perId") String perId, ModelMap mmap) {
        SearchParamDTO dto = new SearchParamDTO();
        dto.setPerId(perId);
        Result ret = perWalletService.getPerWalletAccountByPerId(dto);
        mmap.put("perWalletAccount", ret.getData());
        return prefix + "/perWalletAccount";
    }

    /**
     * 跳转企业收支明细
     * @return
     */
    @GetMapping("/per-wallet-account-trade-detail-view/{perId}/{walletAccountNo}")
    public String perWalletAccountTradeDetailView(@PathVariable("perId") String perId, @PathVariable("walletAccountNo") String walletAccountNo, ModelMap mmap) {
        mmap.put("perId", perId);
        mmap.put("walletAccountNo", walletAccountNo);
        return prefix + "/perWalletAccountTradeDetail";
    }

    /**
     * 跳转企业收支明细-详情
     * @return
     */
    @GetMapping("/per-trade-detail-view")
    public String perTradeDetailView() {
        return prefix + "/perTradeDetail";
    }

    /**
     * 获得企业钱包信息列表
     * @param dto
     * @return
     */
    @RequiresPermissions("per-wallet:list")
    @PostMapping("/page-per-wallet-list")
    @ResponseBody
    public Object pagePerWalletList(SearchParamDTO dto) throws V5BusinessException {
        startPage();
        return getDataTable(perWalletService.pagePerInsList(dto));
    }

    /**
     * 获得账户信息
     * @param paramDTO
     * @return
     */
    @RequiresPermissions("per-wallet:list")
    @PostMapping("/get-per-wallet-account-by-id")
    @ResponseBody
    public Result getPerWalletAccountById(SearchParamDTO paramDTO) throws V5BusinessException {
        return perWalletService.getPerWalletAccountByPerId(paramDTO);
    }

    /**
     * 企业收支明细
     * @param dto
     * @return
     */
    @RequiresPermissions("per-wallet:list")
    @PostMapping("/get-per-wallet-account-trade-detail")
    @ResponseBody
    public Object getPerWalletAccountTradeDetail(SearchParamDTO dto) throws V5BusinessException {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        return getDataTable(perWalletService.getPerWalletAccountTradeDetail(dto,pageNum,pageSize));
    }

    /**
     * <b> 电子回单 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:19
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("per-wallet:list")
    @PostMapping("/get-per-account-trade-voucher")
    @ResponseBody
    public Result getPerAccountTradeVoucher(SearchParamDTO dto) throws V5BusinessException {
        return perWalletService.getPerAccountTradeVoucher(dto);
    }

    /**
     * <b> 交易凭证 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:19
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("per-wallet:list")
    @PostMapping("/get-per-account-pay-voucher")
    @ResponseBody
    public Result getPerAccountPayVoucher(SearchParamDTO dto) throws V5BusinessException {
        return perWalletService.getPerAccountPayVoucher(dto);
    }

    /**
     * <b> 绑定银行卡 </b>
     * @author ZXF
     * @create 2019/09/02 0002 10:42
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("per-wallet:list")
    @PostMapping("/bind-bank-card")
    @ResponseBody
    public Result BindBankCard(PerWalletAccount perWalletAccount) throws V5BusinessException {
        perWalletAccount.setUpdateBy(ShiroUtils.getUserId());
        return perWalletService.updatePerWalletAccount(perWalletAccount);
    }
}
