package com.bcxin.platform.web.controller.manage.ins;


import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.dto.insurance.ComInsDTO;
import com.bcxin.platform.dto.insurance.ComInsPrincipalDTO;
import com.bcxin.platform.service.insurance.manage.ComInsManageService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;


/**
 * <b> 机构管理-保险业务 </b>
 * @author ZXF
 * @create 2022/04/21 0021 9:34
 * @version
 * @注意事项 </b>
 */
@Controller
@RequestMapping("/manage/insurance")
public class ComInsManangeController extends BaseController {

    private String prefix = "manage/insurance";
    @Autowired
    private ComInsManageService comInsService;

    /**
     * 查询保险列表
     *
     * @return
     */
    @RequiresPermissions("insurance:view")
    @GetMapping("/insurance-list-view")
    public String insuranceList() {
        return prefix + "/insuranceList";
    }


    /**
     * 企业保险查询分页
     *
     * @return
     */
    @RequiresPermissions("insurance:list")
    @PostMapping("/page-com-ins-list")
    @ResponseBody
    public Object pageComInsList(ComInsDTO dto) throws V5BusinessException {
        startPage();
        return getDataTable(comInsService.pageComInsList(dto));
    }

    /**
     * 查询保险详情
     *
     * @return
     */
    @RequiresPermissions("insurance:view")
    @GetMapping("/insurance-info/{comInsId}")
    public String insuranceInfo(@PathVariable("comInsId") String comInsId, ModelMap mmap) {
        mmap.put("comIns", comInsService.getComInsInfo(comInsId));
        mmap.put("comInsId", comInsId);
        return prefix + "/insuranceInfo";
    }

    /**
     * 企业保险详情
     *
     * @param dto
     * @return
     * @throws V5BusinessException
     */
    @RequiresPermissions("insurance:list")
    @PostMapping("/com-ins-info-by-id")
    @ResponseBody
    public Result getComInsInfoById(ComInsDTO dto) throws V5BusinessException {
        startPage();
        return comInsService.getComInsInfo(dto);
    }

    /**
     * <b> 根据企业ID，查询保险负责人列 </b>
     * @author ZXF
     * @create 2019/05/17 0017 16:54
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("insurance:list")
    @PostMapping("/select-principal-by-comId")
    @ResponseBody
    public Object selectPrincipalByComId(ComInsPrincipalDTO dto) throws V5BusinessException {
        return getDataTable(comInsService.selectPrincipalByComId(dto));
    }

    /**
     * 修改在保人数
     *
     * @param dto
     * @return
     * @throws V5BusinessException
     */
    @RequiresPermissions("insurance:list")
    @PostMapping("/update-per-num")
    @ResponseBody
    public Result updatePerNum(ComInsDTO dto) throws V5BusinessException {
        return comInsService.updatePerNum(dto);
    }

    /**
     * <b> 保险推荐报表下载 </b>
     * @author ZXF
     * @create 2020/04/07 0007 16:31
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("insurance:list")
    @GetMapping("/down-ins-schedule")
    public void downInsSchedule(HttpServletResponse resp) {
        comInsService.downInsSchedule(resp);
    }
}

