package com.bcxin.platform.web.controller.manage;

import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.ShiroUtils;
import com.bcxin.platform.dto.order.ComOrderDto;
import com.bcxin.platform.dto.order.ComOrderVo;
import com.bcxin.platform.service.meeting.HuaweiMeetMatchService;
import com.bcxin.platform.service.order.ComOrderService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author linqinglin
 * @date 2021/06/22 0022 16:51
 */
@RequestMapping("/manage/order")
@Controller
public class MeetingOrderController extends BaseController {

    private String prefix = "manage/order";

    @Autowired
    private ComOrderService comOrderService;

    @Autowired
    private HuaweiMeetMatchService huaweiMeetMatchService;


    @RequiresPermissions("order:view")
    @GetMapping("/view-order-list")
    public String bktOrderListView(){
        return prefix + "/meetingOrderList";
    }

    @RequiresPermissions("order:view")
    @GetMapping("/view-order-detail")
    public String viewOrderDetail(){
        return prefix + "/meetingOrderDetail";
    }

    @RequiresPermissions("order:view")
    @GetMapping("/view-order-resource")
    public String viewOrderResource(ModelMap mmap){
        mmap.put("comList", huaweiMeetMatchService.findComHuaweiMeetMatchList());
        return prefix + "/meetingOrderResource";
    }

    /**
     * 获取订单列表
     *
     * @return
     * @author wjj
     * @date 2020-01-15
     */
    @RequiresPermissions("order:list")
    @PostMapping(value = "get-order-list")
    @ResponseBody
    public Object getOrderList(ComOrderVo dto) throws Exception {
        startPage();
        return getDataTable(comOrderService.orderList(dto));
    }

    /**
     * <b> 根据被分配机构id查询资源列 </b>
     * @author ZXF
     * @create 2020/05/25 0025 16:08
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("order:list")
    @PostMapping(value = "reasource-list")
    @ResponseBody
    public Object getOrderDetailListByAssignedOrgId(ComOrderDto dto) throws Exception {
        startPage();
        return getDataTable(comOrderService.getOrderDetailListByAssignedOrgId(dto));
    }

    /**
     * 订单操作：设为已配置（变更订单配置状态）
     *
     * @author wjj
     * @date 2020-01-15
     * @param dto
     * @return
     * @throws Exception
     */
    @RequiresPermissions("order:list")
    @PostMapping(value = "change-deploy-status")
    @ResponseBody
    public Result changeDeployStatus(ComOrderDto dto) throws Exception {
        Result result = new Result();
        result.setData(comOrderService.changeDeployStatus(dto));
        return result;
    }

    /**
     * <b> 获取统计信息 </b>
     * @author ZXF
     * @create 2021/07/15 0015 16:56
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("order:list")
    @PostMapping("/get-statistic-info")
    @ResponseBody
    public Object getAllOutsideUserStatisticInfo(ComOrderDto dto) {
        return comOrderService.getOrderStatistic(dto);
    }

    /**
     * <b> 获取订单华为云支付信息 </b>
     * @author ZXF
     * @create 2021/07/15 0015 16:55
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("order:list")
    @PostMapping("/find-order-pay-list-by-order-id")
    @ResponseBody
    public Object findOrderPayListByOrderId(ComOrderDto dto) {
        return comOrderService.findOrderPayListByOrderId(dto);
    }

    /**
     * <b> 采购资源 </b>
     * @author ZXF
     * @create 2021/07/15 0015 16:55
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("order:list")
    @PostMapping("/purchasing-resource")
    @ResponseBody
    public Object purchasingResource(ComOrderDto dto) throws V5BusinessException {
        return comOrderService.purchasingResource(dto,ShiroUtils.getUserId());
    }

    /**
     * <b> 采购资源确认支付 </b>
     * @author ZXF
     * @create 2021/07/15 0015 16:55
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("order:list")
    @PostMapping("/order-confirm-pay")
    @ResponseBody
    public Object orderConfirmPay(ComOrderVo dto) throws V5BusinessException {
        return comOrderService.orderConfirmPay(dto,ShiroUtils.getUserId());
    }

    /**
     * <b> 分配资源 </b>
     * @author ZXF
     * @create 2021/07/15 0015 16:55
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("order:list")
    @PostMapping("/allocation-resource")
    @ResponseBody
    public Object allocationResource(ComOrderDto dto) throws V5BusinessException {
        return comOrderService.allocationResource(dto, ShiroUtils.getUserId());
    }

}
