package com.bcxin.platform.web.controller.insurance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.insurance.ComInsBootScheme;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.insurance.*;
import com.bcxin.platform.service.insurance.ComInsService;
import com.bcxin.platform.service.temporary.ComProjectService;
import com.bcxin.platform.util.log.Log;
import com.bcxin.platform.web.controller.base.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * <p>
 * 企业基础信息表 前端控制器
 * </p>
 *
 * @author ctj
 * @since 2017-12-11
 */
@RestController
@RequestMapping("/enterprise/ins/com-ins")
@Api(tags = { "" }, description = "企业保险") // tag中文会影响路径
public class ComInsController extends BaseController {

	@Autowired
	private ComInsService comInsService;
	@Autowired
	private ComProjectService comProjectService;

	/**
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:38
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业保险", title = "企业保险查询分页", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-com-ins-page")
	@ApiOperation(value = "企业保险查询分页")
	public Result getComInsPage(ComInsDTO dto) throws V5BusinessException {
		return comInsService.getComInsPage(dto).setBack(getRequest());
	}

	/**
	 * <b> 该接口存在bug弃用，但目前不清楚有多少地方在调用不做删除 </b>
	 * @author ZXF
	 * @create 2023/06/05 0005 15:22
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业保险", title = "个人投保保险查询分页", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-per-ins-page")
	@ApiOperation(value = "个人投保保险查询分页")
	public Result getPerInsPage(ComInsDTO dto) throws V5BusinessException {
		String data = getbody();
		if (StringUtils.isEmpty(data)) {
			throw new V5BusinessException(Result.ERROR, "分页字段不存在");
		}
		JSONObject json = JSON.parseObject(data);
		if(json.get("pageNumber")==null||json.get("pageSize") == null){
			throw new V5BusinessException(Result.ERROR, "分页不能为空");
		}
		dto.setPageNumber(Integer.parseInt(String.valueOf(json.get("pageNumber"))));
		dto.setPageSize(Integer.parseInt(String.valueOf(json.get("pageSize"))));
		return comInsService.getPerInsPage(dto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业保险", title = "个人投保保险查询分页", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-per-ins-page-new")
	@ApiOperation(value = "个人投保保险查询分页")
	public Result getPerInsPageNew(ComInsDTO dto) throws V5BusinessException {
		String data = getbody();
		if (StringUtils.isEmpty(data)) {
			throw new V5BusinessException(Result.ERROR, "分页字段不存在");
		}
		JSONObject json = JSON.parseObject(data);
		if(json.get("pageNumber")==null||json.get("pageSize") == null){
			throw new V5BusinessException(Result.ERROR, "分页不能为空");
		}
		dto.setPageNumber(Integer.parseInt(String.valueOf(json.get("pageNumber"))));
		dto.setPageSize(Integer.parseInt(String.valueOf(json.get("pageSize"))));
		dto.setIdCard(String.valueOf(json.get("idCardNo")));
		return comInsService.getPerInsPageNew(dto).setBack(getRequest());
	}

	private String getbody() {
		StringBuilder stringBuilder = new StringBuilder();
		String body = null;
		BufferedReader bufferedReader = null;
		try {
			getRequest().setCharacterEncoding("UTF-8");
			InputStream inputStream = getRequest().getInputStream();
			if (inputStream != null) {
				bufferedReader = new BufferedReader(new InputStreamReader(inputStream,"UTF-8"));
				char[] charBuffer = new char[128];
				int bytesRead = -1;
				while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
					stringBuilder.append(charBuffer, 0, bytesRead);
				}
			} else {
				stringBuilder.append("");
			}
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (bufferedReader != null) {
				try {
					bufferedReader.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}

		body = String.valueOf(stringBuilder);
		return body;
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业保险", title = "根据身份证查询企业保险", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-com-ins-by-idcard")
	@ApiOperation(value = "根据身份证查询企业保险")
	public Result getComInsByIdcard(ComInsDTO dto) throws V5BusinessException {
		return comInsService.getComInsByIdcard(dto).setBack(getRequest());
	}

	/**
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/18 17:59
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业保险", title = "企业保险方案书分页", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-ins-boot-page")
	@ApiOperation(value = "企业保险方案书分页")
	public Result getInsBootPage(ComInsDTO dto) throws V5BusinessException {
		return comInsService.getInsBootPage(dto).setBack(getRequest());
	}

	/**
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:38
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业保险", title = "企业保险详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-com-ins-detail")
	@ApiOperation(value = "企业保险详情")
	public Result getComInsDetail(ComInsDTO dto) throws V5BusinessException {
		return comInsService.getComInsDetail(dto).setBack(getRequest());
	}

	/**
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:38
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "新增企业保险", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/insert-com-ins-underline")
	@ApiOperation(value = "新增企业保险")
	public Result saveComInsUnderline(ComInsDTO dto) throws V5BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		dto.setPerId(currentUser.getPerId());
		return comInsService.saveComInsUnderline(dto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "查询临保项目列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/find-com-project-list")
	@ApiOperation(value = "查询临保项目列表")
	public Result findComProjectList() throws V5BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		return comProjectService.getProjectListByComId(currentUser.getComId()).setBack(getRequest());
	}

	/**
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:38
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "删除企业保险", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/delete-com-ins-underline")
	@ApiOperation(value = "删除企业保险")
	public Result deleteComInsUnderline(ComInsDTO dto) throws V5BusinessException {
		return comInsService.deleteComInsUnderline(dto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "更新授权文件", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/save-auth-file")
	@ApiOperation(value = "更新授权文件")
	public Result saveAuthFile(ComInsDTO dto) throws V5BusinessException {
		return comInsService.saveAuthFile(dto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业保险", title = "在线企业保险用户激活链接生成", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/activate-online-ins-blb-user-link")
	@ApiOperation(value = "在线企业保险用户激活链接生成")
	public Result activateOnlineInsBlbUserLink(ComInsDTO dto) throws V5BusinessException {
		return comInsService.activateOnlineInsBlbUserLink(dto).setBack(getRequest());
	}

	/**
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:38
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业保险", title = "在线企业保险链接生成", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-online-ins-blb-link")
	@ApiOperation(value = "在线企业保险链接生成")
	public Result getOnlineInsBlbLink(ComInsDTO dto) throws V5BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comInsService.getOnlineInsBlbLink(dto).setBack(getRequest());
	}

	/**
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:38
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "企业在线购买的保险详情链接生成", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-online-ins-blb-detail-link")
	@ApiOperation(value = "企业在线购买的保险详情链接生成,百联保订单ID要传")
	public Result getOnlineInsBlbDetailLink(ComInsDTO dto) throws V5BusinessException {
		return comInsService.getOnlineInsBlbDetailLink(dto).setBack(getRequest());
	}

	/**
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:38
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "保全页面链接生成", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-online-ins-blb-preservation-link")
	@ApiOperation(value = "保全页面链接生成,百联保订单ID和人员ID")
	public Result getOnlineInsBlbPreservationLink(ComInsDTO dto) throws V5BusinessException {
		return comInsService.getOnlineInsBlbPreservationLink(dto).setBack(getRequest());
	}

	/**
	 * <b> 选择订单和人员信息推送到百联保做增员保全 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 14:43
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "增员保全", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/save-ins-blb-add-preservation-service")
	@ApiOperation(value = "增员保全,百联保订单ID和人员ID")
	public Result saveInsBlbAddPreservationService(ComInsDTO dto) throws V5BusinessException {
		return comInsService.saveInsBlbAddPreservationService(dto).setBack(getRequest());
	}

	/**
	 * <b> 选择订单和人员信息推送到百联保做减员保全(在保已录入列表) </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 14:43
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "减员保全", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/save-ins-blb-minus-preservation-service")
	@ApiOperation(value = "增员保全,百联保订单ID和人员ID")
	public Result saveInsBlbMinusPreservationService(ComInsDTO dto) throws V5BusinessException {
		return comInsService.saveInsBlbMinusPreservationService(dto).setBack(getRequest());
	}

	/**
	 * <b> 选择订单和人员信息推送到百联保做减员保全(在保未录入列表) </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 14:43
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "选择在保未录入列表人员做减员保全", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/save-ins-blb-minus-preservation-by-not-included")
	@ApiOperation(value = "选择在保未录入列表人员做减员保全,百联保订单ID和在保表ID")
	public Result saveInsBlbMinusPreservationByNotIncluded(ComInsDTO dto) throws V5BusinessException {
		return comInsService.saveInsBlbMinusPreservationByNotIncluded(dto).setBack(getRequest());
	}

	/**
	 * <b> 生成投保页面id带cacheId </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 11:10
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "投保页面链接生成", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-compnay-and-person-put-cache-link")
	@ApiOperation(value = "投保页面链接生成")
	public Result getCompnayAndPersonPutCacheLink(ComInsDTO dto) throws V5BusinessException {
		return comInsService.findCompnayAndPersonPutCache(dto).setBack(getRequest());
	}

	/**
	 * <b> 生成订单列表页面地址并返回 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 11:10
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "订单列表页面链接生成", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-online-ins-blb-order-page-link")
	@ApiOperation(value = "订单列表页面链接生成")
	public Result getOnlineInsBlbOrderPageLink(ComInsDTO dto) throws V5BusinessException {
		return comInsService.getOnlineInsBlbOrderPageLink(dto).setBack(getRequest());
	}

	/**
	 * <b> 生成理赔列表页面地址并返回 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 11:10
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "理赔列表页面链接生成", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-online-ins-blb-report-page-link")
	@ApiOperation(value = "理赔列表页面链接生成")
	public Result getOnlineInsBlbReportPageLink(ComInsDTO dto) throws V5BusinessException {
		return comInsService.getOnlineInsBlbReportPageLink(dto).setBack(getRequest());
	}

	/**
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/3 9:54
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "保全页面链接生成，不带人员信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-online-ins-blb-preservation-page-link")
	@ApiOperation(value = "保全页面链接生成，不带人员信息")
	public Result getOnlineInsBlbPreservationPageLink(ComInsBootScheme dto) throws V5BusinessException {
		return comInsService.getOnlineInsBlbPreservationPageLink(dto).setBack(getRequest());
	}

	/**
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/3 9:54
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "获得百联保保险产品列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-blb-pro-list")
	@ApiOperation(value = "获得百联保保险产品列表")
	public Result getBlbProList(ComInsBootScheme dto) throws V5BusinessException {
		return comInsService.getBlbProList(dto).setBack(getRequest());
	}

	/**
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:38
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "企业初始化提示，根据企业所属规则去判断是否需要保险提示", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/prompt-init-enterprise-ins")
	@ApiOperation(value = "企业初始化提示，根据企业所属规则去判断是否需要保险提示")
	public Result promptInitEnterpriseIns(ComInsDTO dto) throws V5BusinessException {
		return comInsService.promptInitEnterpriseIns(dto).setBack(getRequest());
	}

	/**
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:38
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "保全提示，0无保险去购买，1需要做保全，", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/prompt-init-per-add-del-ins")
	@ApiOperation(value = "保全提示，0无保险去购买，1需要做保全，")
	public Result promptInitPerAddDelIns(ComInsDTO dto) throws V5BusinessException {
		return comInsService.promptInitPerAddDelIns(dto).setBack(getRequest());
	}

	/**
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:38
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "保存方案书", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/save-book-scheme")
	@ApiOperation(value = "保存方案书")
	public Result saveBookScheme(ComInsBootScheme dto) throws V5BusinessException {
		return comInsService.saveBookScheme(dto).setBack(getRequest());
	}

	/**
	 * 下载方案书PDF
	 * 
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:38
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-boot-scheme-pdf-link")
	@ApiOperation(value = "获取方案书的PDF的下载链接")
	public Result getBootSchemePdfLink(ComInsDTO dto) throws V5BusinessException {
		return comInsService.getBootSchemePdfLink(dto).setBack(getRequest());
	}

	/**
	 * 读取企业初始化温馨提示的接口
	 * 
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:38
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/prompt-company-init-gen")
	@ApiOperation(value = "温馨提示")
	public Result promptCompanyInitGen(ComInsDTO dto) throws V5BusinessException {
		return comInsService.promptCompanyInitGen(dto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "根据保险规则通知当前登录的企业", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/send-ins-prompt-to-company")
	@ApiOperation(value = "根据保险规则通知当前登录的企业")
	public Result sendInsPromptToCompany(ComInsDTO dto) throws V5BusinessException {
		return comInsService.sendInsPromptToCompany(dto).setBack(getRequest());
	}

	/**
	 * 获取线上人员参保列表
	 * 
	 * @param dto
	 * @return
	 * @throws V5BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "获取线上人员参保列表", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-online-ins-per-list")
	@ApiOperation(value = "获取线上人员参保列表")
	public Result getOnlineInsPerList(ComOnlineInsPerDTO dto) throws V5BusinessException {
		return comInsService.getOnlineInsPerList(dto).setBack(getRequest());
	}

	@PostMapping("/del-all-lose-per-info")
	@ApiOperation(value = "线上线下过期保险删除所有人员", notes = "定时器固定时间点查询符合过期条件的线上线下保险单删除人员信息")
	@Log(operation = Log.OPERA_TYPE_DEL, modle = "企业保险", title = "线上线下过期保险删除所有人员", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	public Result delAllLosePerInfo() throws V5BusinessException {
		return comInsService.delAllLosePerInfo();
	}

	/**
	 * <b> 根据条件查询未投保的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "根据条件查询未投保的人员信息", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/find-uninsured-per-list")
	@ApiOperation(value = "根据条件查询未投保的人员信息")
	public Result findUninsuredPerList(InsPerDTO dto) throws V5BusinessException {
		return comInsService.findUninsuredPerList(dto).setBack(getRequest());
	}

	/**
	 * <b> 导出根据条件筛选未投保的人员信息 </b>
	 * @author ZXF
	 * @create 2020/05/26 0026 10:21
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "导出根据条件筛选未投保的人员信息", title = "导出根据条件筛选未投保的人员信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "export-uninsured-per-list")
	@ApiOperation(value = "导出根据条件筛选未投保的人员信息")
	public void exportUninsuredPerList(InsPerDTO dto) throws V5BusinessException {
		comInsService.exportUninsuredPerList(dto,getResponse());
	}

	/**
	 * <b> 根据条件查询已过滤的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "根据条件查询已过滤的人员信息", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/find-filter-per-list")
	@ApiOperation(value = "根据条件查询已过滤的人员信息")
	public Result findFilterPerList(InsPerDTO dto) throws V5BusinessException {
		return comInsService.findFilterPerList(dto).setBack(getRequest());
	}

	/**
	 * <b> 根据条件查询已投保的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "根据条件查询已投保的人员信息", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/find-under-warranty-per-list")
	@ApiOperation(value = "根据条件查询已投保的人员信息")
	public Result findUnderWarrantyPerList(InsPerDTO dto) throws V5BusinessException {
		return comInsService.findUnderWarrantyPerList(dto).setBack(getRequest());
	}

	/**
	 * <b> 导出根据条件筛选已投保的人员信息 </b>
	 * @author ZXF
	 * @create 2020/05/26 0026 10:21
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "导出根据条件筛选已投保的人员信息", title = "导出根据条件筛选已投保的人员信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "export-under-warranty-per-list")
	@ApiOperation(value = "导出根据条件筛选已投保的人员信息")
	public void exportUnderWarrantyPerList(InsPerDTO dto) throws V5BusinessException {
		comInsService.exportUnderWarrantyPerList(dto,getResponse());
	}

	/**
	 * <b> 根据条件查询已投保未录入的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "根据条件查询已投保未录入的人员信息", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/find-not-included-insurance-per-list")
	@ApiOperation(value = "根据条件查询已投保未录入的人员信息")
	public Result findNotIncludedInsurancePerList(InsPerDTO dto) throws V5BusinessException {
		return comInsService.findNotIncludedInsurancePerList(dto).setBack(getRequest());
	}

	/**
	 * <b> 导出根据条件筛选已投保未录入的人员信息 </b>
	 * @author ZXF
	 * @create 2020/05/26 0026 10:21
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "导出根据条件筛选已投保未录入的人员信息", title = "导出根据条件筛选已投保未录入的人员信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "export-not-included-insurance-per-list")
	@ApiOperation(value = "导出根据条件筛选已投保未录入的人员信息")
	public void exportNotIncludedInsurancePerList(InsPerDTO dto) throws V5BusinessException {
		comInsService.exportNotIncludedInsurancePerList(dto,getResponse());
	}

	/**
	 * <b> 查询线下或线上保险列表 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "查询线下或线上保险列表", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/find-offline-or-online-policy")
	@ApiOperation(value = "查询线下或线上保险列表")
	public Result findOfflineOrOnlinePolicy(InsPerDTO dto) throws V5BusinessException {
		return comInsService.findOfflineOrOnlinePolicy(dto).setBack(getRequest());
	}

	/**
	 * <b> 人员批量添加过滤记录 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员批量添加过滤记录", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/add-batch-filter-person")
	@ApiOperation(value = "人员批量添加过滤记录")
	public Result addBatchFilterPerson(ComInsDTO dto) throws V5BusinessException {
		return comInsService.addBatchFilterPerson(dto).setBack(getRequest());
	}

	/**
	 * <b> 人员批量解除过滤记录 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_DEL, modle = "人员批量解除过滤记录", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/del-batch-filter-person")
	@ApiOperation(value = "人员批量解除过滤记录")
	public Result delBatchFilterPerson(ComInsDTO dto) throws V5BusinessException {
		return comInsService.delBatchFilterPerson(dto).setBack(getRequest());
	}

	/**
	 * <b> 查询保单已关联在保人员数量 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_DEL, modle = "查询保单已关联在保人员数量", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/find-under-warranty-per-list-count")
	@ApiOperation(value = "查询保单已关联在保人员数量")
	public Result findUnderWarrantyPerListCount(InsPerDTO dto) throws V5BusinessException {
		return comInsService.findUnderWarrantyPerListCount(dto).setBack(getRequest());
	}

	/**
	 * <b> 人员批量关联线下保单 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员批量关联线下保单", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/add-batch-relevance-per")
	@ApiOperation(value = "人员批量关联线下保单")
	public Result addBatchRelevancePer(ComInsDTO dto) throws V5BusinessException {
		return comInsService.addBatchRelevancePer(dto).setBack(getRequest());
	}

	/**
	 * <b> 线下保单添加备注 </b>
	 * @author ZXF
	 * @create 2020/04/20 0020 15:59
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "线下保单添加备注", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/update-com-ins-remark")
	@ApiOperation(value = "线下保单添加备注")
	public Result updateComInsRemark(ComInsDTO dto) throws V5BusinessException {
		return comInsService.updateComInsRemark(dto).setBack(getRequest());
	}

	/**
	 * <b> 人员批量减员线下保单 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员批量减员线下保单", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/minus-batch-relevance-per")
	@ApiOperation(value = "人员批量减员线下保单")
	public Result minusBatchRelevancePer(ComInsDTO dto) throws V5BusinessException {
		return comInsService.minusBatchRelevancePer(dto).setBack(getRequest());
	}

	/**
	 * <b> 查询在保人员离职人数 </b>
	 * @author ZXF
	 * @create 2019/05/08 0008 9:47
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "查询在保人员离职人数", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/find-y-incumbency-per-count")
	@ApiOperation(value = "查询在保人员离职人数")
	public Result findYIncumbencyPerCount(InsPerDTO dto) throws V5BusinessException {
		return comInsService.findYIncumbencyPerCount(dto).setBack(getRequest());
	}

	/**
	 * <b> 批量删除保险负责人 </b>
	 * @author ZXF
	 * @create 2019/05/17 0017 16:53
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "批量删除保险负责人", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/del-batch-principal")
	@ApiOperation(value = "批量删除保险负责人")
	public Result delBatchPrincipal(ComInsPrincipalDTO dto) throws V5BusinessException {
		return comInsService.delBatchPrincipal(dto).setBack(getRequest());
	}

	/**
	 * <b> 批量插入保险负责人 </b>
	 * @author ZXF
	 * @create 2019/05/17 0017 16:53
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "批量插入保险负责人", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/insert-batch-principal")
	@ApiOperation(value = "批量插入保险负责人")
	public Result insertBatchPrincipal(ComInsPrincipalDTO dto) throws V5BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		dto.setPerId(currentUser.getPerId());
		return comInsService.insertBatchPrincipal(dto).setBack(getRequest());
	}

	/**
	 * <b> 根据企业ID，查询保险负责人列 </b>
	 * @author ZXF
	 * @create 2019/05/17 0017 16:54
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "根据企业ID，查询保险负责人列", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/select-principal-by-comId")
	@ApiOperation(value = "根据企业ID，查询保险负责人列")
	public Result selectPrincipalByComId(ComInsPrincipalDTO dto) throws V5BusinessException {
		return comInsService.selectPrincipalByComId(dto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "搜索未投保人员或已投保并离职人员向对应企业定时推送站内消息提醒", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/send-insurance-operation-msg")
	@ApiOperation(value = "搜索未投保人员或已投保并离职人员向对应企业定时推送站内消息提醒")
	public Result sendInsuranceOperationMsg() throws V5BusinessException {
		return comInsService.sendInsuranceOperationMsg().setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "搜索已投保未录入人员身份证去百联保匹配获取姓名（数据补充时用）", title = "", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/find-blb-per-name")
	@ApiOperation(value = "搜索已投保未录入人员身份证去百联保匹配获取姓名（数据补充时用）")
	public Result findBlbPerName() throws V5BusinessException {
		return comInsService.findBlbPerName().setBack(getRequest());
	}

	@PostMapping("/batch-upload-ins-per")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员投保", title = "批量导入投保人员", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	public Result batchUploadInsPer(@RequestParam("xfile") MultipartFile file) throws Exception {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登陆超时或者未登陆").setBack(getRequest());
		}
		return comInsService.batchUploadInsPer(currentUser.getPerId(), currentUser.getComId(), file);
	}

	@PostMapping("/batch-upload-ins-per/{tlkProjectId}")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员投保", title = "批量导入投保人员(临保根据项目校验)", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	public Result batchUploadInsPer(@PathVariable("tlkProjectId") String tlkProjectId,@RequestParam("xfile") MultipartFile file) throws Exception {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登陆超时或者未登陆").setBack(getRequest());
		}
		return comInsService.batchUploadInsPer(tlkProjectId, currentUser.getPerId(), currentUser.getComId(), file);
	}

	@PostMapping("/minus-batch-upload-ins-per")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "在保人员减员", title = "批量导入在保人员", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	public Result minusBatchUploadInsPer(@RequestParam("xfile") MultipartFile file) throws Exception {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登陆超时或者未登陆").setBack(getRequest());
		}
		return comInsService.minusBatchUploadInsPer(currentUser.getPerId(), currentUser.getComId(), file);
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员投保", title = "导出错误人员Excel", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "export-err-ins-per")
	public Result exportErrInsPer(String importBatchId) throws V5BusinessException {
		return comInsService.downErrInsPer(importBatchId, getResponse()).setBack(getRequest());
	}

	/**
	 * <b> 批量模板上传人员线上做增员 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 14:43
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "增员保全", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/temp-batch-ins-per-to-add-preservation-service")
	@ApiOperation(value = "批量模板上传人员线上做增员")
	public Result tempBatchInsPerToAddPreservationService(ComInsDTO dto) throws V5BusinessException {
		return comInsService.tempBatchInsPerToAddPreservationService(dto).setBack(getRequest());
	}

	/**
	 * <b> 批量模板上传人员关联线下保单 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 14:43
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "批量模板上传人员关联线下保单", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/temp-batch-ins-per-to-relevance")
	@ApiOperation(value = "批量模板上传人员关联线下保单")
	public Result tempBatchInsPerToRelevance(ComInsDTO dto) throws V5BusinessException {
		return comInsService.tempBatchInsPerToRelevance(dto).setBack(getRequest());
	}

	/**
	 * <b> 批量模板上传人员生成投保页面id带cacheId链接 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 11:10
	 * @version
	 * @注意事项 </b>
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业保险", title = "批量模板上传人员生成投保页面id带cacheId链接", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-compnay-and-temp-batch-ins-per-put-cache")
	@ApiOperation(value = "批量模板上传人员生成投保页面id带cacheId链接")
	public Result findCompnayAndTempBatchInsPerPutCache(ComInsDTO dto) throws V5BusinessException {
		return comInsService.findCompnayAndTempBatchInsPerPutCache(dto).setBack(getRequest());
	}

	/**
	 * <b> 定时查询线下保单中标注百联保的单子去百联保拉取在保人数 </b>
	 * @author ZXF
	 * @create 2020/04/20 0020 10:09
	 * @version
	 * @注意事项 </b>
	 */
	@PostMapping("/sync-ins-num")
	@ApiOperation(value = "定时管理", notes = "定时同步线下百联保投保的在保人数")
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "定时管理", title = "定时同步线下百联保投保的在保人数", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	public Result syncInsNumTaskToBLB() throws V5BusinessException {
		return comInsService.syncInsNumTaskToBLB();
	}

}
