package com.bcxin.platform.web.controller.grant;

import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.grant.ComGrantRecord;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.service.grant.ComGrantRecordService;
import com.bcxin.platform.util.log.Log;
import com.bcxin.platform.web.controller.base.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * 企业发放记录服务的controller层
 * @author llc
 * @date 2020-03-27
 */
@RestController
@RequestMapping("/com/grant-record/")
@Api(tags = { "" }, description = "企业薪资发放服务")
public class ComGrantRecordController extends BaseController {

	@Autowired
	private ComGrantRecordService comGrantRecordService;


	/**
	 * 获取企业发放记录列表
	 * @param comGrantRecord
	 * @author llc
	 * @date 2020-03-27
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业发放记录", title = "获取企业发放记录列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "获取企业发放记录列表", httpMethod = "POST", notes = "获取企业发放记录列表", response = Map.class)
	@PostMapping(value = "page-com-grant-record-list")
	public Result pageComGrantRecordList(ComGrantRecord comGrantRecord) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登陆超时或者未登陆").setBack(getRequest());
		}
		return comGrantRecordService.pageComGrantRecordList(comGrantRecord).setBack(getRequest());
	}



	/**
	 * 保存企业线下发放记录
	 * @param comGrantRecord
	 * @author by llc
	 * @date 2020-03-06
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业发放记录", title = "保存企业线下发放记录", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "保存企业线下发放记录", httpMethod = "POST", notes = "保存企业线下发放记录", response = Map.class)
	@PostMapping(value = "save-off-line-grant-record")
	public Result saveOffLineGrantRecord(ComGrantRecord comGrantRecord) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登陆超时或者未登陆").setBack(getRequest());
		}
		return comGrantRecordService.saveOffLineGrantRecord(comGrantRecord).setBack(getRequest());
	}

	/**
	 * 删除企业线下发放记录
	 * @param comGrantRecord
	 * @author by llc
	 * @date 2020-03-06
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业发放记录", title = "删除企业线下发放记录", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "删除企业线下发放记录", httpMethod = "POST", notes = "删除企业线下发放记录", response = Map.class)
	@PostMapping(value = "delete-off-line-grant-record")
	public Result deleteOffLineGrantRecord(ComGrantRecord comGrantRecord) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登陆超时或者未登陆").setBack(getRequest());
		}
		return comGrantRecordService.deleteOffLineGrantRecord(comGrantRecord).setBack(getRequest());
	}



}
