package com.bcxin.platform.web.controller.attend;

import com.bcxin.oaflow.dto.MakeUpCardDto;
import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.validator.ValidatorUtils;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.bcxin.platform.domain.attend.AttendClock;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.attend.AttendClockDto;
import com.bcxin.platform.dto.attend.AttendClockStateDto;
import com.bcxin.platform.service.attend.AttendClockService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 考勤打卡记录Controller
 * 
 * @author lin
 * @date 2021-08-27
 */
@RestController
@RequestMapping("/attend/clock")
public class AttendClockController extends BaseController{

    @Autowired
    private AttendClockService attendClockService;


    /**
     * 查询考勤打卡记录列表
     */
    @PostMapping("/searchForPage")
    public TableDataInfo searchForPage(AttendClockDto attendClock){
        startPage();
        List<AttendClockDto> list = attendClockService.selectList(attendClock);
        return getDataTable(list);
    }

    /**
     * 修改考勤打卡记录
     */
    @GetMapping("/findById/{id}")
    public AjaxResult findById(@PathVariable("id") Long id){
        AttendClock attendClock = attendClockService.findById(id);
        return AjaxResult.success(null,attendClock);
    }

    /**
     * 删除考勤打卡记录
     */
    @Log(title = "考勤打卡记录", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    public AjaxResult remove(String ids){
        return toAjax(attendClockService.deleteByIds(ids));
    }


    /**
     * 手动补卡
     */
    @Log(title = "考勤打卡记录", businessType = BusinessType.UPDATE)
    @PostMapping( "/updateState")
    public AjaxResult updateState(AttendClockStateDto clockDetailDto){
        ValidatorUtils.validateEntity(clockDetailDto, UpdateGroup.class);
        return toAjax(attendClockService.updateState(clockDetailDto));
    }

    /**
     * 获取缺卡时间
     */
    @GetMapping("/getMissCard")
    public AjaxResult getMissCard(AttendClockDto searchDto){
        CurrentUser currentUser = new CurrentUser(getRequest());
        searchDto.setPerId(currentUser.getPerId());
        List<MakeUpCardDto> missCardDates = attendClockService.getMissCard(searchDto);
        return AjaxResult.success(null,missCardDates);
    }
}
