package com.bcxin.platform.web.controller.attend;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.poi.ExcelUtil;
import com.bcxin.platform.common.utils.validator.ValidatorUtils;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.domain.attend.AttendCalendar;
import com.bcxin.platform.service.attend.AttendCalendarService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 考勤打卡日历套Controller
 * 
 * @author lin
 * @date 2021-08-10
 */
@RestController
@RequestMapping("/attend/calendar")
public class AttendCalendarController extends BaseController{

    @Autowired
    private AttendCalendarService attendCalendarService;

    /**
     * 查询考勤打卡日历套列表
     */
    @PostMapping("/list")
    public TableDataInfo list( AttendCalendar attendCalendar){
        List<AttendCalendar> list = attendCalendarService.selectList(attendCalendar);
        return getDataTable(list);
    }
    /**
     * 分页查询考勤打卡日历套列表
     */
    @PostMapping("/searchForPage")
    public TableDataInfo searchForPage( AttendCalendar attendCalendar){
        startPage();
        List<AttendCalendar> list = attendCalendarService.selectList(attendCalendar);
        return getDataTable(list);
    }

    /**
     * 导出考勤打卡日历套列表
     */
    @Log(title = "考勤打卡日历套", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public AjaxResult export( AttendCalendar attendCalendar){
        List<AttendCalendar> list = attendCalendarService.selectList(attendCalendar);
        ExcelUtil<AttendCalendar> util = new ExcelUtil<AttendCalendar>(AttendCalendar.class);
        return util.exportExcel(list, "calendar");
    }

    /**
     * 根据主键id查询
     */
    @GetMapping("/findById/{id}")
    public AjaxResult findById(@PathVariable("id") Long id){
        AttendCalendar attendCalendar = attendCalendarService.findById(id);
        return AjaxResult.success(null,attendCalendar);
    }

    /**
     * 保存考勤打卡日历套
     */
    @Log(title = "考勤打卡日历套", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    public AjaxResult editSave( AttendCalendar attendCalendar){
        ValidatorUtils.validateEntity(attendCalendar, AddGroup.class);
        return toAjax(attendCalendarService.update(attendCalendar));
    }

    /**
     * 删除考勤打卡日历套
     */
    @Log(title = "考勤打卡日历套", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    public AjaxResult remove( String ids){
        return toAjax(attendCalendarService.deleteByIds(ids));
    }
}
