package com.bcxin.platform.web.controller.app.attend;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.domain.attend.AttendShift;
import com.bcxin.platform.dto.app.AppAttendShiftDto;
import com.bcxin.platform.dto.attend.AttendShiftDto;
import com.bcxin.platform.service.attend.AttendShiftService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 考勤班次Controller
 * 
 * @author lin
 * @date 2021-08-10
 */
@RestController
@RequestMapping("/app/attend/shift")
public class AppAttendShiftController extends BaseController{


    @Autowired
    private AttendShiftService attendShiftService;

    /**
     * 查询考勤班次列表
     */
    @PostMapping("/list")
    public TableDataInfo list(AttendShiftDto attendShift){
        attendShift.setActive(Constants.Y);
        List<AttendShiftDto> list = attendShiftService.selectList(attendShift);
        return getDataTable(list);
    }
    /**
     * 查询考勤班次列表
     */
    @PostMapping("findByAttendId")
    public AjaxResult findByAttendId(AttendShiftDto attendShift){
        List<AppAttendShiftDto> list = attendShiftService.findByAttendId(attendShift);
        return AjaxResult.success(list);
    }

    /**
     * 根据id查询考勤班次
     */
    @GetMapping("/findById/{id}")
    public AjaxResult findById(@PathVariable("id") Long id){
        AttendShift attendShift = attendShiftService.findById(id);
        return AjaxResult.success(null,attendShift);
    }

    /**
     * 保存考勤班次
     */
    @Log(title = "考勤班次", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    public AjaxResult editSave(AttendShift attendShift){
        return toAjax(attendShiftService.update(attendShift));
    }

    /**
     * 删除考勤班次
     */
    @Log(title = "考勤班次", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    public AjaxResult remove(String ids){
        return toAjax(attendShiftService.deleteByIds(ids));
    }
}
