package com.bcxin.platform.web.controller.app.attend;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.domain.attend.AttendSchedulConflict;
import com.bcxin.platform.dto.app.AppAttendSchedulConflictDto;
import com.bcxin.platform.service.attend.AttendSchedulConflictService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 考勤排班冲突Controller
 * 
 * @author lin
 * @date 2022-02-14
 */
@RestController
@RequestMapping("/app/attend/schedul/conflict")
public class AppAttendSchedulConflictController extends BaseController{

    @Autowired
    private AttendSchedulConflictService attendSchedulConflictService;

    /**
     * 查询考勤排班冲突列表
     */
    @PostMapping("/list")
    public TableDataInfo list(AttendSchedulConflict attendSchedulConflict){
        startPage();
        List<AttendSchedulConflict> list = attendSchedulConflictService.selectList(attendSchedulConflict);
        return getDataTable(list);
    }

    /**
     * 查询考勤排班冲突列表
     */
    @PostMapping("/findByAttendId")
    public AjaxResult findByAttendId(Long attendId){
        List<AppAttendSchedulConflictDto> list = attendSchedulConflictService.findByAttendId(attendId);
        return AjaxResult.success(list);
    }

    /**
     * 覆盖原有排班
     */
    @Log(title = "考勤排班冲突", businessType = BusinessType.UPDATE)
    @PostMapping("/cover")
    public AjaxResult cover(AttendSchedulConflict attendSchedulConflict){
        return toAjax(attendSchedulConflictService.cover(attendSchedulConflict));
    }

    /**
     * 删除考勤排班冲突
     */
    @Log(title = "考勤排班冲突", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    public AjaxResult remove(String ids){
        return toAjax(attendSchedulConflictService.deleteByIds(ids));
    }
}
