package com.bcxin.platform.util.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LogInterceptor implements HandlerInterceptor {// ,AfterReturningAdvice

	private Logger log = LoggerFactory.getLogger(getClass());

	// @Resource(name = "RedisService")
	// private RedisService redisService;

	// @Autowired
	// private SendMessage sendMessage;

	public LogInterceptor() {
	}

	/**
	 * 请求处理之前进行调用
	 *
	 * @param request
	 * @param httpServletResponse
	 * @param handler
	 * @return
	 * @throws Exception
	 */
	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse httpServletResponse, Object handler)
			throws Exception {
		log.info("请求的uri " + request.getRequestURI());
		return true;
	}

	/**
	 * 当前请求进行处理之后，也就是Controller 方法调用之后执行，但是它会在DispatcherServlet 进行视图返回渲染之前被调用，
	 * 所以我们可以在这个方法中对Controller 处理之后的ModelAndView 对象进行操作。
	 *
	 * @param request
	 * @param httpServletResponse
	 * @param handler
	 * @param modelAndView
	 * @throws Exception
	 */
	@Override
	public void postHandle(HttpServletRequest request, HttpServletResponse httpServletResponse, Object handler,
			ModelAndView modelAndView) throws Exception {
		// System.out.println("postHandle");
		log.info("postHandle");
	}

	/**
	 * 获取Ip地址
	 *
	 * @param request
	 * @return
	 */
	public String getIpAddr(HttpServletRequest request) {
		// System.out.println("getIpAddr");
		String ip = request.getHeader(" x-forwarded-for ");
		if (ip == null || ip.length() == 0 || " unknown ".equalsIgnoreCase(ip)) {
			ip = request.getHeader(" Proxy-Client-IP ");
		}
		if (ip == null || ip.length() == 0 || " unknown ".equalsIgnoreCase(ip)) {
			ip = request.getHeader(" WL-Proxy-Client-IP ");
		}
		if (ip == null || ip.length() == 0 || " unknown ".equalsIgnoreCase(ip)) {
			ip = request.getRemoteAddr();
		}
		return ip;
	}

	/**
	 * 将ErrorStack转化为String.
	 */
	public static String getStackTraceAsString(Throwable e) {
		// System.out.println("getStackTraceAsString");
		if (e == null) {
			return "";
		}
		StringWriter stringWriter = new StringWriter();
		e.printStackTrace(new PrintWriter(stringWriter));
		return stringWriter.toString();
	}

	/**
	 * 该方法将在整个请求结束之后，也就是在DispatcherServlet 渲染了对应的视图之后执行。 这个方法的主要作用是用于进行资源清理工作的
	 *
	 * @param request
	 * @param response
	 * @param handler
	 * @param e
	 * @throws Exception
	 */
	@Override
	public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e)
			throws Exception {
		log.info("afterCompletion");
		// System.out.println("afterCompletion");
		// try {
		// if (handler != null) {
		// if (handler instanceof HandlerMethod) {
		// HandlerMethod handler2 = (HandlerMethod) handler;
		// Log log = handler2.getMethod().getAnnotation(Log.class);
		// if (null != log) {
		// // 获取操作系统等信息
		// StringBuffer sb = new StringBuffer();
		// sb.append("操作系统名称:" + System.getProperty("os.name"));// 操作系统名称
		// sb.append("操作系统构架" + System.getProperty("os.arch"));// 操作系统构架
		// sb.append("操作系统版本" + System.getProperty("os.version"));// 操作系统版本
		// LogEntity logEntity = new LogEntity();
		//// if (log.systemType().equals(Log.SYSTEMTYPE_BACKMANAGE)) {
		//// CurrentUser loginUser = UserUtils.getCurrentUser();
		//// if (loginUser != null) {
		//// logEntity.setOperatorID(loginUser.getUserid());
		//// logEntity.setCreateBy(loginUser.getUsername());
		//// }
		//// } else if (log.systemType().equals(Log.SYSTEMTYPE_PHONE)) {
		//// SystemUser systemUser =
		// SystemUserUtils.getCurrentSystemUser(request);
		//// if (systemUser != null) {
		//// logEntity.setOperatorID(systemUser.getUid().toString());
		//// logEntity.setCreateBy(systemUser.getFullname());
		//// }
		//// }
		// logEntity.setSystemType(log.systemType());
		// logEntity.setCreateDate(new Date());
		// logEntity.setType(log.operation());
		// logEntity.setRequestUrl(request.getRequestURI());
		// logEntity.setRemoteAddr(getIpAddr(request));
		// logEntity.setModle(log.modle());
		// logEntity.setTitle(log.title());
		// logEntity.setUserAgent(sb.toString());
		// logEntity.setRemoteAddr(request.getRemoteAddr());
		// logEntity.setMethod(request.getMethod());
		// Map<String, String[]> map = request.getParameterMap();
		//// String jsonData = JSON.toJSONString(map);
		// logEntity.setParams("");
		// // 如果controller报错，则记录异常错误
		// if (e != null) {
		// logEntity.setException(getStackTraceAsString(e));
		// }
		//// try {
		//// sendMessage.sendMessage(QueueCode.REDIS_QUEUE_SMS_WEB, logEntity);
		//// logger.info("log create a new log ======", logEntity);
		//// } catch (Exception e1) {
		//// logger.info("fail to save operation log ", e1);
		//// }
		// }
		// }
		// }
		// } catch (Exception el) {
		// el.printStackTrace();
		// }
	}
}