package com.bcxin.platform.service.wallet.manage;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.bcxin.platform.common.constant.DictConst;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.wallet.ComWalletAccount;
import com.bcxin.platform.domain.wallet.ComWalletChangeEvent;
import com.bcxin.platform.dto.SearchParamDTO;
import com.bcxin.platform.mapper.wallet.manage.ComWalletManageMapper;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.util.DateUtils;
import com.bcxin.platform.util.JwtUtil;
import com.bcxin.platform.util.constants.CommonConst;
import com.bcxin.platform.util.constants.PaymentServiceConst;
import com.bcxin.platform.util.excel.ExcelUtil;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.*;

/**
 * <b> 企业钱包信息 </b>
 * @author ZXF
 * @create 2019/09/02 0002 11:06
 * @version
 * @注意事项 </b>
 */
@Service("comWalletManageService")
public class ComWalletManageServiceImpl implements ComWalletManageService {

    private Logger logger = LoggerFactory.getLogger(ComWalletManageServiceImpl.class);

    @Autowired
    private ComWalletManageMapper comWalletMapper;
    @Autowired
    private CommonService commonService;
//    @Autowired
//    private SysMessageServiceImpl sysMessageService;
//    @Autowired
//    private UserOutsideMapper userOutsideMapper;


    /**
     * <b> 企业钱包列表的分页查询 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:46
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<Map<String,Object>> pageComWalletList(SearchParamDTO dto) {
        /*查询有效记录*/
        return comWalletMapper.pageComWalletList(dto);
    }

    /**
     * <b> 对账数据分页查询 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:46
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<Map<String,Object>> pageComWalletReconciliationList(SearchParamDTO dto) {
        /*查询有效记录*/
        return comWalletMapper.pageComWalletReconciliationList(dto);
    }

    /**
     * <b> 企业钱包账户-收支明细分页查询 </b>
     * @author ZXF
     * @create 2020/11/11 0011 14:06
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<Map<String,Object>> pageComWalletAccountDetailList(SearchParamDTO dto) {
        /*查询有效记录*/
        return comWalletMapper.pageComWalletAccountDetailList(dto);
    }

    /**
     * <b> 查询企业钱包账户 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:46
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result getComWalletAccountByComId(SearchParamDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "参数comId不能为空");
        }
        Map<String, Object> rec = comWalletMapper.getComWalletAccountByComId(dto.getComId());
        /*** 调用支付平台接口获取账户相关资料 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("comId", comWalletMapper.getMerchantNoByComId(dto.getComId()));
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", JwtUtil.createJWT(p));//加密生成token
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        Result r1 = JSON.parseObject(
                HttpUtil.post(platUrl + PaymentServiceConst.GET_WALLET_ACCOUNT, requestMap)
                , Result.class);
        System.out.println(JSON.toJSONString(r1));
        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(r1.getRetType())) {
            Map<String, Object> map = (Map<String, Object>) r1.getData();
            /*** 账户状态 ***/
            rec.put("accountStatus",PaymentServiceConst.getAccountStatus(map.get("account_state").toString()));
            //获取金额
            requestMap = new HashMap<>();
            p.put("walletAccountNo", rec.get("walletAccountNo"));
            requestMap.put("token", JwtUtil.createJWT(p));//加密生成token
            Result r2 = JSON.parseObject(
                    HttpUtil.post(platUrl + PaymentServiceConst.GET_COM_WALLET_ACCOUNT_AMOUNT, requestMap)
                    , Result.class);
            System.out.println(JSON.toJSONString(r2));
            if (Result.SUCCESS.equals(r2.getRetType())) {
                Map<String, Object> map2 = (Map<String, Object>) r2.getData();
                /*** 账户总额 ***/
                rec.put("totalAmount", map2.get("ledger_bal"));
                /*** 可用余额 ***/
                rec.put("availableAmount", map2.get("available_bal"));
                /*** 冻结金额 ***/
                rec.put("frozenAmount", map2.get("funds_held"));
            } else {
                /*** 返回失败则抛错 ***/
                throw new V5BusinessException(Result.ERROR,r2.getMsg());
            }
        } else {
            /*** 返回失败则抛错 ***/
            throw new V5BusinessException(Result.ERROR,r1.getMsg());
        }
        return Result.success(Result.SUCCESS_MSG,rec);
    }

    /**
     * <b> 查询所有企业钱包账户 </b>
     * @author ZXF
     * @create 2022/07/25 0025 13:53
     * @version
     * @注意事项 </b>
     */
    @Override
    public void taskComWalletAccountByAllComId() throws V5BusinessException {
        List<Map<String, Object>> recList = comWalletMapper.findComWalletAccountByAllComId();
        for(Map<String, Object> rec : recList){
            /*** 调用支付平台接口获取账户相关资料 ***/
            Map<Object, Object> p = new HashMap<>();
            p.put("comId", comWalletMapper.getMerchantNoByComId(Long.parseLong(rec.get("comId")+"")));
            Map<String, Object> requestMap = new HashMap<>();
            requestMap.put("token", JwtUtil.createJWT(p));//加密生成token
            String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
            Result r1 = JSON.parseObject(
                    HttpUtil.post(platUrl + PaymentServiceConst.GET_WALLET_ACCOUNT, requestMap)
                    , Result.class);
            /*** 如果返回成功 ***/
            if (Result.SUCCESS.equals(r1.getRetType())) {
                Map<String, Object> map = (Map<String, Object>) r1.getData();
                /*** 账户状态 ***/
                rec.put("accountStatus",PaymentServiceConst.getAccountStatus(map.get("account_state").toString()));
                //获取金额
                requestMap = new HashMap<>();
                p.put("walletAccountNo", rec.get("walletAccountNo"));
                requestMap.put("token", JwtUtil.createJWT(p));//加密生成token
                Result r2 = JSON.parseObject(
                        HttpUtil.post(platUrl + PaymentServiceConst.GET_COM_WALLET_ACCOUNT_AMOUNT, requestMap)
                        , Result.class);
                if (Result.SUCCESS.equals(r2.getRetType())) {
                    Map<String, Object> map2 = (Map<String, Object>) r2.getData();
                    comWalletMapper.saveOrUpdateDualAccount(Long.parseLong(rec.get("comId")+"")
                            ,rec.get("comName")+""
                            ,rec.get("walletAccountNo")+""
                            ,map2.get("ledger_bal")+""
                            ,map2.get("available_bal")+""
                            ,map2.get("funds_held")+"");
                }
            }
            try {
                Thread.sleep(300);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * <b> 更新企业钱包账户 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:48
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result updateComWalletAccount(ComWalletAccount comWalletAccount) throws V5BusinessException {
        if (comWalletAccount.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "参数comId不能为空");
        }
        if (StringUtils.isEmpty(comWalletAccount.getMobilePhone())) {
            throw new V5BusinessException(Result.ERROR, "参数绑定手机号不能为空");
        }
        int count = comWalletMapper.updateComWalletAccount(comWalletAccount);
        if(count == 0){
            return Result.fail(Result.ERROR_MSG);
        }
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * <b> 获取企业钱包账户交易明细 </b>
     * @author ZXF
     * @create 2019/09/03 0003 10:36
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<Map<String, Object>> getComWalletAccountTradeDetail(SearchParamDTO dto,Integer page,Integer rows) throws V5BusinessException {

        if (dto.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
        }
        if (StringUtils.isEmpty(dto.getWalletAccountNo())) {
            throw new V5BusinessException(Result.ERROR, "企业钱包账户号不能为空");
        }
        if (page == null) {
            throw new V5BusinessException(Result.ERROR, "第几页不能为空");
        }
        if (rows == null) {
            throw new V5BusinessException(Result.ERROR, "每页多少行不能为空");
        }
        if (StringUtils.isEmpty(dto.getStartTime())) {
            throw new V5BusinessException(Result.ERROR, "开始日期不能为空");
        }
        if (StringUtils.isEmpty(dto.getEndTime())) {
            throw new V5BusinessException(Result.ERROR, "结束日期不能为空");
        }

        /*** 调用支付平台接口获取账户交易明细 ***/

        Map<Object, Object> p = new HashMap<>();
        p.put("id", comWalletMapper.getMerchantNoByComId(dto.getComId()));
        p.put("pageNumber", page.toString());
        p.put("pageSize", rows.toString());
        p.put("walletAccountNo", dto.getWalletAccountNo());
        p.put("startDate", dto.getStartTime());
        p.put("endDate", dto.getEndTime());

        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.GET_COM_WALLET_ACCOUNT_TRADE_DETAIL, requestMap);
        Result result = JSON.parseObject(resultStr, Result.class);
        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {

            Map<String, Object> map = (Map<String, Object>) result.getData();
            if (Integer.parseInt(map.get("total_size").toString()) == 0) {
                return new ArrayList();
            } else {
                /*** 解析返回的列表数据 ***/
                ArrayList<Map> recordlist = JSON.parseObject(map.get("balance_records").toString(), new TypeReference<ArrayList<Map>>() {
                });
                List<Map<String, Object>> list = new ArrayList<>();
                if (recordlist.size() > 0) {
                    for (Map<String, Object> record : recordlist) {
                        Map<String, Object> m = new HashMap<>();
                        m.put("trade_date", record.get("trade_date").toString().substring(0, record.get("trade_date").toString().length() - 2)); // 交易时间
                        m.put("trade_flow_no", record.get("trade_flow_no")); // 交易流水号
                        m.put("flow_no", record.get("flow_no")); // 账务流水号
                        m.put("accounts_deal_type", PaymentServiceConst.getAccountDealType(record.get("accounts_deal_type").toString())); //账务处理类型
                        m.put("accounts_deal_date", record.get("accounts_deal_date").toString().substring(0, record.get("accounts_deal_date").toString().length() - 2)); // 账务处理时间
                        m.put("amount", record.get("amount")); // 交易金额
                        m.put("balance", record.get("balance")); // 交易后余额
                        m.put("direction", PaymentServiceConst.getDirection(record.get("direction").toString())); // 资金流向
                        m.put("hand_status", PaymentServiceConst.getHandStatus(record.get("hand_status").toString())); // 处理状态
                        m.put("create_date", record.get("create_date").toString().substring(0, record.get("create_date").toString().length() - 2)); // 订单创建时间
                        m.put("serviceType", PaymentServiceConst.getServiceType(record.get("service_code").toString())); // 服务类型
                        m.put("trade_type", PaymentServiceConst.getTradeType(record.get("trade_type").toString())); // 交易类型
                        m.put("account_in", StringUtils.isEmpty(record.get("account_in").toString())?"-":record.get("account_in")); // 收款方账户
                        m.put("account_out", StringUtils.isEmpty(record.get("account_out").toString())?"-":record.get("account_out")); // 付款方账户
                        m.put("wallet_account_no", dto.getWalletAccountNo()); // 主体账户号
                        m.put("comId", dto.getComId()); // 主体账户号
                        // 收款方账户中文
                        if (StringUtils.isEmpty(record.get("account_in").toString())) {
                            m.put("account_in_name", "-");
                        } else {
                            String comName = comWalletMapper.getComNameByWalletNo(record.get("account_in").toString());
                            m.put("account_in_name",StringUtils.isEmpty(comName)?"-":comName);
                        }
                        // 收款方账户中文
                        if (StringUtils.isEmpty(record.get("account_out").toString())) {
                            m.put("account_out_name", "-");
                        } else {
                            String comName = comWalletMapper.getComNameByWalletNo(record.get("account_out").toString());
                            m.put("account_out_name",StringUtils.isEmpty(comName)?"-":comName);
                        }
                        m.put("memo", StringUtils.isEmpty(record.get("memo").toString())?"-":record.get("memo")); // 备注
                        list.add(m);
                    }
                }
                return list;
            }
        } else {
            /*** 返回失败则抛错 ***/
            throw new V5BusinessException(Result.ERROR,result.getMsg());
        }
    }

    /**
     * <b> 电子回单 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:19
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result getComAccountTradeVoucher(SearchParamDTO dto) throws V5BusinessException {
        if (dto.getTradeFlowNo() == null) {
            throw new V5BusinessException(Result.ERROR, "交易流水号不能为空");
        }
        /*** 调用支付平台接口获取电子回单 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("comId", comWalletMapper.getMerchantNoByComId(dto.getComId()));
        p.put("bizOrderNo", dto.getTradeFlowNo());
        p.put("walletAccountNo", dto.getWalletAccountNo());
        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        return JSON.parseObject(
                HttpUtil.post(platUrl + PaymentServiceConst.ACCOUNT_TRADE_VOUCHER, requestMap)
                , Result.class);//base_content
    }


    /**
     * <b> 交易凭证 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:20
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result getComAccountPayVoucher(SearchParamDTO dto) throws V5BusinessException {
        if (dto.getTradeFlowNo() == null) {
            throw new V5BusinessException(Result.ERROR, "交易流水号不能为空");
        }
        /*** 调用支付平台接口获取电子回单 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("bizOrderNo", dto.getTradeFlowNo());
        //加密生成token
        String token = JwtUtil.createJWT(p);
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.ACCOUNT_PAY_VOUCHER, requestMap);
        return JSON.parseObject(resultStr, Result.class);//
    }

    /**
     * <b> 托底账户收支明细 </b>
     * @author ZXF
     * @create 2019/09/03 0003 15:42
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<Map<String,Object>> pageAccountBaseRecord(SearchParamDTO dto) throws V5BusinessException {
        /*查询有效记录*/
        return comWalletMapper.pageAccountBaseRecordList(dto);
    }

    /**
     * <b> 获取所有银行编码下拉数据 </b>
     * @author ZXF
     * @create 2019/09/02 0002 17:07
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result getAllBankCodeData() {
        return Result.success(Result.SUCCESS_MSG, comWalletMapper.getAllBankCodeData());
    }

    /**
     * <b> 获得钱包信息修改审批列表 </b>
     * @author ZXF
     * @create 2019/09/11 0011 10:41
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<Map<String,Object>> pageComWalletApproveList(SearchParamDTO dto) {
        /*查询有效记录*/
        return comWalletMapper.pageComWalletApproveList(dto);
    }

    /**
     * <b> 获得钱包信息修改审批信息-详情 </b>
     * @author ZXF
     * @create 2019/09/11 0011 10:41
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result getComWalletApproveById(SearchParamDTO dto) throws V5BusinessException {
        if (dto.getId() == null) {
            throw new V5BusinessException(Result.ERROR, "审批Id不能为空");
        }
        Map<String, Object> rec = comWalletMapper.getComWalletApproveById(dto.getId());
        return Result.success(Result.SUCCESS_MSG, rec);
    }

    /**
     * <b> 获得钱包信息修改字段信息列 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:46
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<Map<String,Object>> pageComWalletChangeList(SearchParamDTO dto) {
        //dto.getQ()放的是ComWalletChangeEvent的id
        return comWalletMapper.getComWalletChangeDetailById(Long.parseLong(dto.getQ()));
    }

    /**
     * <b> 钱包信息变更保存 </b>
     * @author ZXF
     * @create 2019/09/11 0011 14:38
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result updateComWalletApproveStatus(ComWalletChangeEvent comWalletChangeEvent) throws V5BusinessException {
        if (comWalletChangeEvent.getComWalletChangeEventId() == null) {
            throw new V5BusinessException(Result.ERROR, "审批Id不能为空");
        }
        if (comWalletChangeEvent.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业Id不能为空");
        }
        if (StringUtils.isEmpty(comWalletChangeEvent.getApproveStatus())) {
            throw new V5BusinessException(Result.ERROR, "审批状态不能为空");
        }
        Map<String,Object> accountMap = comWalletMapper.getComWalletAccountByComId(comWalletChangeEvent.getComId());
        if(accountMap == null){
            throw new V5BusinessException(Result.ERROR, "未找到钱包信息");
        }
        //审批通过才去修改钱包的相关信息
        if(DictConst.APPROVESTATUS_SPTG.equals(comWalletChangeEvent.getApproveStatus())){
            //对接支付平台修改信息
            Map<Object,Object> p = Maps.newHashMap();
            p.put("oldBankCardNoUrl",comWalletChangeEvent.getBankCardUrl());
            p.put("comId",comWalletMapper.getMerchantNoByComId(comWalletChangeEvent.getComId()));
            p.put("comName",String.valueOf(accountMap.get("comName")));
            p.put("mobilePhone",String.valueOf(accountMap.get("mobilePhone")));
            String bCard = comWalletMapper.getInfoByFieldAndId("bankCardNo",comWalletChangeEvent.getComWalletChangeEventId());
            p.put("newBankCardNo",StringUtils.isNotEmpty(bCard)?bCard:String.valueOf(accountMap.get("bankCardNo")));
            String bCode = comWalletMapper.getInfoByFieldAndId("bankCode",comWalletChangeEvent.getComWalletChangeEventId());
            p.put("newBankCode",StringUtils.isNotEmpty(bCode)?bCode:String.valueOf(accountMap.get("bankCode")));
            p.put("oldBankCardNo",String.valueOf(accountMap.get("bankCardNo")));
            String token = JwtUtil.createJWT(p);
            Map<String,Object> requestMap = Maps.newHashMap();
            requestMap.put("token",token);
            String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
            Result result = JSON.parseObject(
                    HttpUtil.post(platUrl + PaymentServiceConst.COM_ACCOUNT_BIND, requestMap)
                    , Result.class);
            if(Result.ERROR.equals(result.getRetType())){
                return result;
            }
            //查询变更列表信息，并组织部分sql参数做修改
            List<Map<String,Object>> list = comWalletMapper.getComWalletChangeDetailById(comWalletChangeEvent.getComWalletChangeEventId());
            if(list.size()>0){
                //TODO 如果修改的是同一个表的数据直接这样拼接，如果list中存在不同表变更下面的拼接就不适用
                String tj = "";
                for (Map map : list ) {
                    tj = tj + map.get("changeCode") + " = '" + map.get("changeAfterInfo") + "' , ";
                }
                String sqlStr = "UPDATE com_wallet_account SET "
                        +tj+
                        " updateTime = '"+ DateUtils.getDate("yyyy-MM-dd HH:mm:ss")+
                        "' , updateBy = '"+comWalletChangeEvent.getApprovePerId()+
                        "' WHERE comId = "+comWalletChangeEvent.getComId();
                comWalletMapper.changeAccountBySql(sqlStr);
            }
        }
        //修改审批表结果信息
        comWalletChangeEvent.setApproveTime(new Date());
        comWalletMapper.updateComWalletApproveStatus(comWalletChangeEvent);
        //审批不通过发消息
        if(DictConst.APPROVESTATUS_SPBTG.equals(comWalletChangeEvent.getApproveStatus())){
            //查询审批信息
            Map<String, Object> rec = comWalletMapper.getComWalletApproveById(comWalletChangeEvent.getComWalletChangeEventId());
            //查询新旧字段信息
            Map<String, Object> fMap = comWalletMapper.getComWalletChangeFieldsById(comWalletChangeEvent.getComWalletChangeEventId());
            if(rec!=null&&fMap!=null){
                String title = "企业钱包信息修改审核不通过";
                String content = "修改类型："
                        +rec.get("typeName")+"\\n原信息："
                        +fMap.get("oldChange")+"\\n新信息："
                        +fMap.get("newChange")+"\\n审批结果："
                        +rec.get("statusName")+"\\n审批备注："
                        +rec.get("approveContent")+"。";
                //查询主管理员id
//                Map map = userOutsideMapper.getAdminByComId(comWalletChangeEvent.getComId());
//                String perId = map != null ? String.valueOf(map.get("perId")) : CommonConst.BLANK_CHAR;
//                if(StringUtils.isNotEmpty(perId)){
//                    sysMessageService.sendMessage(title, content, "010110", perId, String.valueOf(comWalletChangeEvent.getComId()), "10", "3", "");
//                }
            }
        }
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * <b> 用于定时器捞取托底户接口数据 </b>
     * @author ZXF
     * @create 2019/10/11 0011 17:13
     * @version
     * @注意事项 </b>
     */
    @Override
    public void accountBaseRecordJob() throws Exception {
        //key自己编的只为了区分redis的key而已
        String conditions = commonService.getConditions("TDH-001");
        //查询条件取redis或用默认值
        Map<String, String> mapConditions;
        if(StringUtils.isNotEmpty(conditions)){
            mapConditions = JSON.parseObject(conditions,Map.class);
        }else{
            mapConditions = Maps.newHashMap();
            mapConditions.put("pageNumber","1");
            mapConditions.put("pageSize","500");
            mapConditions.put("startDate","2019-08-01");
            mapConditions.put("endDate","2019-08-03");
        }
        logger.debug("    ================ 托底户参数："+mapConditions.toString());
        //当前日期在区间内(开始日期<=当前日期<=结束日期)，直接跳出不做业务，会出现数据同步延迟3天的情况，但胜在数据准确避免当天的数据5分钟就请求一次接口
        if(DateUtils.dateCompare(mapConditions.get("startDate"),DateUtils.getDate())
                && DateUtils.dateCompare(DateUtils.getDate(),mapConditions.get("endDate"))){
            logger.debug("    ================ 托底户达到当前天范围...");
            return;
        }

        /*** 调用支付平台接口获取托底账户收支明细 ***/
        Map<Object, Object> p = Maps.newHashMap();
        p.put("pageNumber", mapConditions.get("pageNumber"));
        p.put("pageSize", mapConditions.get("pageSize"));
        p.put("startDate", mapConditions.get("startDate"));
        p.put("endDate", mapConditions.get("endDate"));
        //加密生成token
        String token = JwtUtil.createJWT(p);
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        Result result = JSON.parseObject(
                HttpUtil.post(platUrl + PaymentServiceConst.ACCOUNT_BASE_RECORD, requestMap)
                , Result.class);
        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {

            Map<String, Object> map = (Map<String, Object>) result.getData();
            System.out.println(map);
            if (Integer.parseInt(map.get("total_rows").toString()) == 0) {
                //当前日期条件查无数据时，日期条件叠3天、分页重置，且日期不大于当前天(上面开头已做过滤)
                p = new HashMap<>();
                p.put("pageNumber", "1");
                p.put("pageSize", "500");
                p.put("startDate", DateUtils.dateAdd(CommonConst.BLANK_CHAR,mapConditions.get("endDate"),CommonConst.DATE_CODE_YMD,1));
                p.put("endDate", DateUtils.dateAdd(CommonConst.BLANK_CHAR,mapConditions.get("endDate"),CommonConst.DATE_CODE_YMD,1));
                commonService.setConditions("TDH-001",JSONObject.toJSONString(p));
                logger.debug("    ================ 托底户时间区间查无数据，参数重置、缓存...");
                return;
            } else {
                //当前条件查到数据，不满足500条...检查日期是否超过当前时间，超过就暂停，不超过日期条件叠3天、分页重置
                if (Integer.parseInt(map.get("total_rows").toString()) < 500) {
                    p = new HashMap<>();
                    p.put("pageNumber", "1");
                    p.put("pageSize", "500");
                    p.put("startDate", DateUtils.dateAdd(CommonConst.BLANK_CHAR,mapConditions.get("endDate"),CommonConst.DATE_CODE_YMD,1));
                    p.put("endDate", DateUtils.dateAdd(CommonConst.BLANK_CHAR,mapConditions.get("endDate"),CommonConst.DATE_CODE_YMD,1));
                    logger.debug("    ================ 托底户时间区间查询数据不足500条，参数分页重置、日期变更...");
                }else{
                    //当前条件查到数据，满足500条...设置分页到缓存
                    p = new HashMap<>();
                    p.put("pageNumber", String.valueOf(Integer.parseInt(mapConditions.get("pageNumber"))+1));
                    p.put("pageSize", "500");
                    p.put("startDate", mapConditions.get("startDate"));
                    p.put("endDate", mapConditions.get("endDate"));
                    logger.debug("    ================ 托底户时间区间查询数据满足500条，参数日期不变、分页变更...");
                }

                /*** 解析返回的列表数据 ***/
                ArrayList<Map> recordlist = JSON.parseObject(map.get("tran_hist_detail").toString(), new TypeReference<ArrayList<Map>>() {
                });
                List<Map<String, Object>> list = new ArrayList<>();
                if (recordlist.size() > 0) {
                    for (Map<String, Object> record : recordlist) {
                        Map<String, Object> m = new HashMap<>();
                        m.put("balType", PaymentServiceConst.getBalType(record.get("bal_type").toString())); //余额类型 CA：钞 TT：汇.
                        m.put("reversalTranType", record.get("reversal_tran_type")); //冲正交易类型 *.
                        m.put("tranDesc", record.get("tran_desc")); //交易描述.
                        m.put("statusInfo", record.get("status_info")); //状态描述
                        m.put("tfrAcctType", record.get("tfr_acct_type")); //引用账户类型.
                        m.put("tranTime", record.get("tran_time")); //交易时间.
                        m.put("reference", record.get("reference")); //交易参考号.
                        m.put("tfrAcctName", record.get("tfr_acct_name")); //对方户名.
                        m.put("ccy", record.get("ccy")); //币种 *.
                        m.put("previousBalAmt", record.get("previous_bal_amt")); //上次余额.
                        m.put("othBankCode", record.get("oth_bank_code")); //对方行号.
                        m.put("tradeSerialNo", record.get("seq_no")); //交易流水号.
                        m.put("effectDate", record.get("effect_date")); //生效日期.
                        m.put("tranDate", record.get("tran_date")); //交易日期.
                        m.put("tranCode", record.get("tran_code")); //交易码.
                        m.put("tranType", record.get("tran_type")); //交易类型 *.
                        m.put("actualBalAmt", record.get("actual_bal_amt")); //交易后余额.
                        m.put("ledgerBal", record.get("ledger_bal")); //.
                        m.put("reverse", PaymentServiceConst.getReverse(record.get("reverse").toString())); //冲正标识 Y：冲正交易 N：非冲正交易.
                        m.put("tfrAcctNo", record.get("tfr_acct_no")); //引用账户号码.
                        m.put("crDrPrevious", PaymentServiceConst.getCrDr(record.get("cr_dr_previous").toString())); //上次余额的借贷标志 D：借 C：贷.
                        m.put("postDate", record.get("post_date")); //入账日期.
                        m.put("crDrMaintInd", PaymentServiceConst.getCrDr(record.get("cr_dr_maint_ind").toString())); //借贷标记 D：借 C：贷.
                        m.put("tradeAmount", record.get("tran_amt")); //交易金额.
                        m.put("othBankName", record.get("oth_bank_name")); //对方行名.
                        m.put("status", record.get("status")); //状态 *.
                        list.add(m);
                    }
                }
                //保存数据
                if(list.size()>0){
                    comWalletMapper.batchInsertAccountBaseRecord(list);
                }
                commonService.setConditions("TDH-001",JSONObject.toJSONString(p));
            }
        } else {
            /*** 返回失败则抛错 ***/
            logger.error(result.getMsg());
            if("查询无返回记录".equals(result.getMsg())){
                p = new HashMap<>();
                p.put("pageNumber", "1");
                p.put("pageSize", "500");
                p.put("startDate", DateUtils.dateAdd(CommonConst.BLANK_CHAR,mapConditions.get("endDate"),CommonConst.DATE_CODE_YMD,1));
                p.put("endDate", DateUtils.dateAdd(CommonConst.BLANK_CHAR,mapConditions.get("endDate"),CommonConst.DATE_CODE_YMD,1));
                commonService.setConditions("TDH-001",JSONObject.toJSONString(p));
                logger.debug("    ================ 托底户时间区间查无数据，参数重置、缓存...");
            }
        }
    }

    /**
     * <b> 导出企业钱包账户对账数据 </b>
     * @author ZXF
     * @create 2019/10/16 0016 14:56
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result exprokComWalletReconciliation(SearchParamDTO dto, HttpServletResponse response) throws V5BusinessException {
        if (StringUtils.isEmpty(dto.getFundFlowType())) {
            return Result.fail("资金流向不能为空");
        }
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            String fileName = "对账数据" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition",
                    "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("对账数据");


            /*** 查询企业钱包账户对账数据列表 ***/
            List<Map<String,Object>> list = comWalletMapper.pageComWalletReconciliationList(dto);

            /*** 填充文本样式 ***/
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);

            /**** 生成sheet1的内容 ***/
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short) 11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("黑体");
            titleStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);// 水平居中
            titleStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);// 垂直居中
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));

            /**** 生成sheet1的内容 ***/
            /*** 获取企业钱包账户对账统计数据 ***/
            Map<String,Object> map = comWalletMapper.getWalletReconciliationSum(dto);
            String headerTitle = "";
            if(map ==  null){
                headerTitle =  MessageFormat.format("总笔数：【{0}】笔 | 总金额：【{1}】元 | 成功笔数：【{2}】笔 | 成功金额：【{3}】元 | 失败笔数：【{4}】笔 | 失败金额：【{5}】元 | 处理中笔数：【{6}】笔 | 处理中金额：【{7}】元",
                        0,0,0,0,0,0,0,0);
            }else{
                headerTitle =  MessageFormat.format("总笔数：【{0}】笔 | 总金额：【{1}】元 | 成功笔数：【{2}】笔 | 成功金额：【{3}】元 | 失败笔数：【{4}】笔 | 失败金额：【{5}】元 | 处理中笔数：【{6}】笔 | 处理中金额：【{7}】元",
                        map.get("totalCount"),map.get("sumAmount"),map.get("successCount"),map.get("successAmount"),map.get("errorCount"),map.get("errorAmount"),map.get("processingCount"),map.get("processingAmount"));
            }

            /*** 填充第一行数据 ***/
            HSSFCellStyle titleStyle1 = wb.createCellStyle();
            HSSFFont titleFont1 = wb.createFont();
            titleFont1.setFontHeightInPoints((short) 11);
            titleFont1.setColor(HSSFColor.RED.index);
            titleFont1.setFontName("黑体");
            titleStyle1.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);// 垂直居中
            titleStyle1.setFont(titleFont1);
            titleStyle1.setWrapText(true);
            HSSFRow rowFirst = sheet1.createRow(0); // 第一个sheet的第一行为标题
            rowFirst.setHeight((short) (1000));
            sheet1.addMergedRegion(new CellRangeAddress(0, (short) 0, 0, 13));
            HSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle1);

            /*** 填充第二行数据 ***/
            HSSFRow secondFirst = sheet1.createRow(1);
            String[] secondArr = {"序号", "交易流水号", "银行交易类型", "交易状态", "交易订单创建时间", "交易金额", "出账方户名", "出账方账号", "出账方银行", "入账方户名", "入账方账号", "入账方银行", "入账方证件号", "备注"};
            int column;
            for (int i = 0; i < secondArr.length; i++) {
                HSSFCell cell = secondFirst.createCell(i); // 获取第二行的每个单元格
                if (i == 0) {
                    column = 1500;
                } else if (i == 4) {
                    column = 5000;
                } else if (i == 1 ||i == 7||i == 10||i == 13){
                    column = 8000;
                } else if (i == 6||i == 9){
                    column = 10000;
                }else if (i == 13){
                    column = 14000;
                }else {
                    column = 4000;
                }
                sheet1.setColumnWidth(i, column); // 设置每列的列宽
                sheet1.setDefaultColumnStyle(i, stringStyle); // 设置单元格格式 --文本格式
                cell.setCellStyle(titleStyle); // 文本格式
            }

            /*** 填充第二行数据 ***/
            for (int i = 0; i < secondArr.length; i++) {
                HSSFCell cell = secondFirst.createCell(i); // 获取第一行的每个单元格
                cell.setCellValue(secondArr[i]);
                cell.setCellStyle(titleStyle);
            }

            /*** 字体颜色样式 ***/
            CellStyle greenStyle = ExcelUtil.getColorStyle(wb, IndexedColors.SEA_GREEN.index);// 青绿色样式
            CellStyle redStyle = ExcelUtil.getColorStyle(wb, IndexedColors.RED.index); // 红色样式
            CellStyle blueStyle = ExcelUtil.getColorStyle(wb, IndexedColors.BLUE.index); // 红色样式
            HSSFRow row = null;
            int rowIndex = 2;
            for (Map<String, Object> result : list) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue(rowIndex-1);
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.get("tradeSerialNo") != null ? result.get("tradeSerialNo").toString() : null); // 交易流水号
                HSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(result.get("bankTradeType") != null ? result.get("bankTradeType").toString() : null); // 银行交易类型
                HSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(result.get("tradeStatus") != null ? result.get("tradeStatus").toString() : null); // 交易状态
                if (ObjectUtil.equal(result.get("tradeStatus"), "交易成功")) {
                    cell3.setCellStyle(greenStyle);
                } else if(ObjectUtil.equal(result.get("tradeStatus"), "交易失败")) {
                    cell3.setCellStyle(redStyle);
                }else{
                    cell3.setCellStyle(blueStyle);
                }
                HSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(result.get("tradeStartTime") != null ? result.get("tradeStartTime").toString() : null); // 交易订单创建时间
                HSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(result.get("tradeAmount") != null ? result.get("tradeAmount").toString() : null); // 交易金额
                cell5.setCellStyle(redStyle);
                HSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(result.get("expendAccountName") != null ? result.get("expendAccountName").toString() : null);// 出账方户名
                HSSFCell cell7 = row.createCell(7);
                cell7.setCellValue(result.get("expendAccountNo") != null ? result.get("expendAccountNo").toString() : null);// 出账方账号
                HSSFCell cell8 = row.createCell(8);
                cell8.setCellValue(result.get("expendBank") != null ? result.get("expendBank").toString() : null);// 出账方银行
                HSSFCell cell9 = row.createCell(9);
                cell9.setCellValue(result.get("incomeAccountName") != null ? result.get("incomeAccountName").toString() : null);// 入账方户名
                HSSFCell cell10 = row.createCell(10);
                cell10.setCellValue(result.get("incomeAccountNo") != null ? result.get("incomeAccountNo").toString() : null);// 入账方账号
                HSSFCell cell11 = row.createCell(11);
                cell11.setCellValue(result.get("incomeBank") != null ? result.get("incomeBank").toString() : null);// 入账方银行
                HSSFCell cell12 = row.createCell(12);
                cell12.setCellValue(result.get("incomeCerNo") != null ? result.get("incomeCerNo").toString() : null);// 入账方证件号
                HSSFCell cell13 = row.createCell(13);
                cell13.setCellValue(result.get("remark") != null ? result.get("remark").toString() : null);// 备注
                rowIndex++;
            }
            wb.write(os);
            os.close();
            wb.close();
        } catch (Exception e) {
            throw new V5BusinessException(Result.ERROR, e.getMessage());
        } finally {
            try {
                os.close();
                wb.close();
            } catch (IOException e1) {
            }
        }
        return Result.success("导出对账文件失败");
    }

    public static void main(String[] args) {

        Map<Object, Object> p = new HashMap<>();
        p.put("id", "591286668472877057");
        p.put("pageNumber", "1");
        p.put("pageSize", "100");
        p.put("walletAccountNo", "3008001013547579000010");
        p.put("startDate", "2021-12-29");
        p.put("endDate", "2022-01-08");

        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = "http://pay.bcxin.com.cn:81/";
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.GET_COM_WALLET_ACCOUNT_TRADE_DETAIL, requestMap);
        System.out.println(resultStr);
    }
}
